/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.freeform;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.ant.freeform.spi.support.Util;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditCookie;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class WebFreeFormActionProvider
implements ActionProvider {
    static final String FILE_SCRIPT_PATH = "nbproject/ide-file-targets.xml";
    static final String GENERAL_SCRIPT_PATH = "nbproject/ide-targets.xml";
    private static final String LOAD_PROPS_TARGET = "-load-props";
    private static final String CHECK_PROPS_TARGET = "-check-props";
    private static final String INIT_TARGET = "-init";
    private static final String DEBUG_TARGET = "debug-nb";
    private static final String DISPLAY_BROWSER = "debug-display-browser";
    private static final String[] DEBUG_PROPERTIES = new String[]{"jpda.session.name", "jpda.host", "jpda.address", "jpda.transport", "debug.sourcepath", "client.url"};
    private static final String DEBUG_PROPERTIES_TEMPLATE = "/org/netbeans/modules/web/freeform/resources/debug-properties.template";
    private final Project project;
    private final AntProjectHelper helper;
    private final AuxiliaryConfiguration aux;
    private static final String[] SUPPORTED_ACTIONS = new String[]{"debug"};

    public WebFreeFormActionProvider(Project project, AntProjectHelper antProjectHelper, AuxiliaryConfiguration auxiliaryConfiguration) {
        this.project = project;
        this.helper = antProjectHelper;
        this.aux = auxiliaryConfiguration;
    }

    public boolean isActionEnabled(String string, Lookup lookup) throws IllegalArgumentException {
        boolean bl = false;
        if (string.equals("debug")) {
            bl = true;
        }
        return bl;
    }

    public void invokeAction(String string, Lookup lookup) throws IllegalArgumentException {
        try {
            try {
                if (string.equals("debug")) {
                    this.handleDebug();
                }
            }
            catch (SAXException sAXException) {
                throw (IOException)new IOException(sAXException.toString()).initCause(sAXException);
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    public String[] getSupportedActions() {
        return SUPPORTED_ACTIONS;
    }

    private void handleDebug() throws IOException, SAXException {
        if (!this.alert(NbBundle.getMessage(WebFreeFormActionProvider.class, (String)"ACTION_debug"), GENERAL_SCRIPT_PATH)) {
            return;
        }
        String string = this.writeDebugProperties();
        Document document = this.readCustomScript(GENERAL_SCRIPT_PATH);
        if (document == null) {
            document = this.createCustomScript();
        }
        this.writeComments(document);
        this.writeTargets(document, string);
        this.writeCustomScript(document, GENERAL_SCRIPT_PATH);
        this.addBinding("debug", GENERAL_SCRIPT_PATH, DEBUG_TARGET, null, null, null, null, null);
        this.jumpToBinding("debug");
        this.jumpToBuildScript(GENERAL_SCRIPT_PATH, DEBUG_TARGET);
        this.openFile(string);
    }

    private boolean alert(String string, String string2) {
        String string3 = ProjectUtils.getInformation((Project)this.project).getDisplayName();
        String string4 = NbBundle.getMessage(WebFreeFormActionProvider.class, (String)"TITLE_generate_target_dialog", (Object)string, (Object)string3);
        String string5 = NbBundle.getMessage(WebFreeFormActionProvider.class, (String)"TEXT_generate_target_dialog", (Object)string, (Object)string2);
        NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string5, 3);
        message.setTitle(string4);
        message.setOptionType(2);
        JButton jButton = new JButton(NbBundle.getMessage(WebFreeFormActionProvider.class, (String)"LBL_generate"));
        jButton.setDefaultCapable(true);
        message.setOptions(new Object[]{jButton, NotifyDescriptor.CANCEL_OPTION});
        return DialogDisplayer.getDefault().notify((NotifyDescriptor)message) == jButton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Document readCustomScript(String string) throws IOException, SAXException {
        Document document = null;
        FileObject fileObject = this.helper.getProjectDirectory().getFileObject(string);
        if (fileObject != null) {
            InputStream inputStream = fileObject.getInputStream();
            try {
                document = XMLUtil.parse((InputSource)new InputSource(inputStream), (boolean)false, (boolean)true, null, null);
            }
            finally {
                inputStream.close();
            }
        }
        return document;
    }

    Document createCustomScript() {
        Document document = XMLUtil.createDocument((String)"project", null, null, null);
        Element element = document.getDocumentElement();
        element.setAttribute("basedir", "..");
        String string = ProjectUtils.getInformation((Project)this.project).getDisplayName();
        element.setAttribute("name", NbBundle.getMessage(WebFreeFormActionProvider.class, (String)"LBL_generated_script_name", (Object)string));
        this.copyProperties(Util.getPrimaryConfigurationData((AntProjectHelper)this.helper), element);
        return document;
    }

    private void copyProperties(Element element, Element element2) {
        Element element3 = Util.getPrimaryConfigurationData((AntProjectHelper)this.helper);
        Element element4 = Util.findElement((Element)element3, (String)"properties", (String)"http://www.netbeans.org/ns/freeform-project/2");
        if (element4 != null) {
            for (Element element5 : Util.findSubElements((Element)element4)) {
                String string;
                Element element6 = element2.getOwnerDocument().createElement("property");
                if (element5.getLocalName().equals("property")) {
                    string = element5.getAttribute("name");
                    assert (string != null);
                    String string2 = Util.findText((Element)element5);
                    assert (string2 != null);
                    element6.setAttribute("name", string);
                    element6.setAttribute("value", string2);
                } else if (element5.getLocalName().equals("property-file")) {
                    string = Util.findText((Element)element5);
                    assert (string != null);
                    element6.setAttribute("file", string);
                } else assert (false) : element5;
                element2.appendChild(element6);
            }
        }
    }

    private void writeComments(Document document) {
        Comment comment = document.createComment(" " + NbBundle.getMessage(WebFreeFormActionProvider.class, (String)"COMMENT_edit_target") + " ");
        Comment comment2 = document.createComment(" " + NbBundle.getMessage(WebFreeFormActionProvider.class, (String)"COMMENT_more_info_debug") + " ");
        Element element = document.getDocumentElement();
        element.appendChild(comment);
        element.appendChild(comment2);
    }

    private void writeTargets(Document document, String string) {
        this.createLoadPropertiesTarget(document, string);
        this.createCheckPropertiesTarget(document);
        this.createInitTarget(document);
        this.createDebugTarget(document);
        this.createDisplayBrowserTarget(document);
    }

    private void createLoadPropertiesTarget(Document document, String string) {
        Element element = document.createElement("target");
        element.setAttribute("name", LOAD_PROPS_TARGET);
        Element element2 = document.createElement("property");
        element2.setAttribute("file", string);
        element.appendChild(element2);
        document.getDocumentElement().appendChild(element);
    }

    private void createCheckPropertiesTarget(Document document) {
        Element element = document.createElement("target");
        element.setAttribute("name", CHECK_PROPS_TARGET);
        for (int i = 0; i < DEBUG_PROPERTIES.length; ++i) {
            Element element2 = document.createElement("fail");
            element2.setAttribute("unless", DEBUG_PROPERTIES[i]);
            element.appendChild(element2);
        }
        document.getDocumentElement().appendChild(element);
    }

    private void createInitTarget(Document document) {
        Element element = document.createElement("target");
        element.setAttribute("name", INIT_TARGET);
        element.setAttribute("depends", "-load-props, -check-props");
        document.getDocumentElement().appendChild(element);
    }

    private void createDebugTarget(Document document) {
        Element element = document.createElement("target");
        element.setAttribute("name", DEBUG_TARGET);
        element.setAttribute("depends", INIT_TARGET);
        element.setAttribute("if", "netbeans.home");
        Element element2 = document.createElement("nbjpdaconnect");
        element2.setAttribute("name", "${jpda.session.name}");
        element2.setAttribute("host", "${jpda.host}");
        element2.setAttribute("address", "${jpda.address}");
        element2.setAttribute("transport", "${jpda.transport}");
        Element element3 = document.createElement("sourcepath");
        Element element4 = document.createElement("path");
        element4.setAttribute("path", "${debug.sourcepath}");
        element3.appendChild(element4);
        element2.appendChild(element3);
        element.appendChild(element2);
        Element element5 = document.createElement("antcall");
        element5.setAttribute("target", DISPLAY_BROWSER);
        element.appendChild(element5);
        document.getDocumentElement().appendChild(element);
    }

    private void createDisplayBrowserTarget(Document document) {
        Element element = document.createElement("target");
        element.setAttribute("name", DISPLAY_BROWSER);
        Element element2 = document.createElement("nbbrowse");
        element2.setAttribute("url", "${client.url}");
        element.appendChild(element2);
        document.getDocumentElement().appendChild(element);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeCustomScript(Document document, String string) throws IOException {
        FileObject fileObject = this.helper.getProjectDirectory().getFileObject(string);
        if (fileObject == null) {
            fileObject = FileUtil.createData((FileObject)this.helper.getProjectDirectory(), (String)string);
        }
        FileLock fileLock = fileObject.lock();
        try {
            OutputStream outputStream = fileObject.getOutputStream(fileLock);
            try {
                XMLUtil.write((Document)document, (OutputStream)outputStream, (String)"UTF-8");
            }
            finally {
                outputStream.close();
            }
        }
        finally {
            fileLock.releaseLock();
        }
    }

    void addBinding(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) throws IOException {
        Element element = Util.getPrimaryConfigurationData((AntProjectHelper)this.helper);
        Element element2 = Util.findElement((Element)element, (String)"ide-actions", (String)"http://www.netbeans.org/ns/freeform-project/2");
        if (element2 == null) {
            return;
        }
        Document document = element.getOwnerDocument();
        Element element3 = document.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "action");
        element3.setAttribute("name", string);
        Element element4 = document.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "script");
        element4.appendChild(document.createTextNode(string2));
        element3.appendChild(element4);
        Element element5 = document.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "target");
        element5.appendChild(document.createTextNode(string3));
        element3.appendChild(element5);
        element2.appendChild(element3);
        if (string4 != null) {
            Element element6;
            Element element7 = document.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "context");
            Element element8 = document.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "property");
            element8.appendChild(document.createTextNode(string4));
            element7.appendChild(element8);
            Element element9 = document.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "folder");
            element9.appendChild(document.createTextNode(string5));
            element7.appendChild(element9);
            if (string6 != null) {
                element6 = document.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "pattern");
                element6.appendChild(document.createTextNode(string6));
                element7.appendChild(element6);
            }
            element6 = document.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "format");
            element6.appendChild(document.createTextNode(string7));
            element7.appendChild(element6);
            Element element10 = document.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "arity");
            if (string8 != null) {
                Element element11 = document.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "separated-files");
                element11.appendChild(document.createTextNode(string8));
                element10.appendChild(element11);
            } else {
                element10.appendChild(document.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "one-file-only"));
            }
            element7.appendChild(element10);
            element3.appendChild(element7);
        } else {
            Element element12;
            Element element13 = Util.findElement((Element)element, (String)"view", (String)"http://www.netbeans.org/ns/freeform-project/2");
            if (element13 != null && (element12 = Util.findElement((Element)element13, (String)"context-menu", (String)"http://www.netbeans.org/ns/freeform-project/2")) != null) {
                Element element14 = document.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "ide-action");
                element14.setAttribute("name", string);
                element12.appendChild(element14);
            }
        }
        Util.putPrimaryConfigurationData((AntProjectHelper)this.helper, (Element)element);
        ProjectManager.getDefault().saveProject(this.project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String writeDebugProperties() throws IOException {
        Object object;
        String string;
        String string2 = "debug";
        int n = 0;
        do {
            string = "nbproject/" + string2 + (n != 0 ? String.valueOf(n) : "") + ".properties";
            ++n;
        } while (this.helper.resolveFileObject(string) != null);
        FileObject fileObject = FileUtil.createData((FileObject)this.project.getProjectDirectory(), (String)string);
        FileLock fileLock = fileObject.lock();
        BufferedOutputStream bufferedOutputStream = null;
        InputStream inputStream = null;
        try {
            int n2;
            bufferedOutputStream = new BufferedOutputStream(fileObject.getOutputStream(fileLock));
            inputStream = this.getClass().getResourceAsStream(DEBUG_PROPERTIES_TEMPLATE);
            object = new byte[4096];
            do {
                n2 = inputStream.read((byte[])object);
                ((OutputStream)bufferedOutputStream).write((byte[])object, 0, n2);
            } while (n2 == ((byte[])object).length);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (bufferedOutputStream != null) {
                ((OutputStream)bufferedOutputStream).close();
            }
            fileLock.releaseLock();
        }
        object = this.helper.getProperties(string);
        ProjectInformation projectInformation = ProjectUtils.getInformation((Project)this.project);
        object.setProperty("jpda.session.name", projectInformation.getName());
        object.setProperty("src.folders", this.findSourceFolders("java"));
        object.setProperty("web.docbase.dir", this.findSourceFolders("doc_root"));
        String string3 = this.findContextPath();
        object.setProperty("client.url", object.getProperty("client.url") + (string3 != null ? string3 : "/"));
        this.helper.putProperties(string, (EditableProperties)object);
        return string;
    }

    private void jumpToBinding(String string) {
        this.jumpToFile("nbproject/project.xml", string, "action", "name");
    }

    private void jumpToBuildScript(String string, String string2) {
        this.jumpToFile(string, string2, "target", "name");
    }

    private void jumpToFile(String string, String string2, String string3, String string4) {
        DataObject dataObject;
        int n;
        FileObject fileObject = this.helper.getProjectDirectory().getFileObject(string);
        if (fileObject == null) {
            return;
        }
        try {
            n = WebFreeFormActionProvider.findLine(fileObject, string2, string3, string4);
        }
        catch (IOException iOException) {
            Logger.getLogger("global").log(Level.INFO, null, iOException);
            return;
        }
        catch (SAXException sAXException) {
            Logger.getLogger("global").log(Level.INFO, null, sAXException);
            return;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Logger.getLogger("global").log(Level.INFO, null, parserConfigurationException);
            return;
        }
        if (n == -1) {
            n = 0;
        }
        try {
            dataObject = DataObject.find((FileObject)fileObject);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            throw new AssertionError((Object)dataObjectNotFoundException);
        }
        LineCookie lineCookie = (LineCookie)dataObject.getCookie(LineCookie.class);
        if (lineCookie != null) {
            try {
                lineCookie.getLineSet().getCurrent(n).show(2);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                Logger.getLogger(WebFreeFormActionProvider.class.getName()).log(Level.WARNING, indexOutOfBoundsException + " [file=" + fileObject + " match=" + string2 + " line=" + n + "]");
                lineCookie.getLineSet().getCurrent(0).show(2);
            }
        }
    }

    private void openFile(String string) {
        DataObject dataObject;
        FileObject fileObject = this.helper.getProjectDirectory().getFileObject(string);
        if (fileObject == null) {
            return;
        }
        try {
            dataObject = DataObject.find((FileObject)fileObject);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            throw new AssertionError((Object)dataObjectNotFoundException);
        }
        EditCookie editCookie = (EditCookie)dataObject.getCookie(EditCookie.class);
        if (editCookie != null) {
            editCookie.edit();
        }
    }

    static final int findLine(FileObject fileObject, final String string, final String string2, final String string3) throws IOException, SAXException, ParserConfigurationException {
        InputSource inputSource = new InputSource(fileObject.getURL().toString());
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setNamespaceAware(true);
        SAXParser sAXParser = sAXParserFactory.newSAXParser();
        final int[] nArray = new int[]{-1};
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class Handler
        extends DefaultHandler {
            private Locator locator;

            Handler() {
            }

            @Override
            public void setDocumentLocator(Locator locator) {
                this.locator = locator;
            }

            @Override
            public void startElement(String string4, String string22, String string32, Attributes attributes) throws SAXException {
                if (nArray[0] == -1 && string22.equals(string2) && string.equals(attributes.getValue(string3))) {
                    nArray[0] = this.locator.getLineNumber() - 1;
                }
            }
        }
        sAXParser.parse(inputSource, (DefaultHandler)new Handler());
        return nArray[0];
    }

    private String findSourceFolders(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        Element element = Util.getPrimaryConfigurationData((AntProjectHelper)this.helper);
        Element element2 = Util.findElement((Element)element, (String)"folders", (String)"http://www.netbeans.org/ns/freeform-project/2");
        if (element2 != null) {
            for (Element element3 : Util.findSubElements((Element)element2)) {
                Element element4;
                Element element5 = Util.findElement((Element)element3, (String)"type", (String)"http://www.netbeans.org/ns/freeform-project/2");
                if (element5 == null || !Util.findText((Element)element5).equals(string) || (element4 = Util.findElement((Element)element3, (String)"location", (String)"http://www.netbeans.org/ns/freeform-project/2")) == null) continue;
                String string2 = Util.findText((Element)element4);
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(":");
                }
                stringBuffer.append(string2);
            }
        }
        return stringBuffer.toString();
    }

    private String findContextPath() {
        Element element = this.aux.getConfigurationFragment("web-data", "http://www.netbeans.org/ns/freeform-project-web/2", true);
        Element element2 = Util.findElement((Element)element, (String)"web-module", (String)"http://www.netbeans.org/ns/freeform-project-web/2");
        if (element2 == null) {
            return null;
        }
        Element element3 = Util.findElement((Element)element2, (String)"context-path", (String)"http://www.netbeans.org/ns/freeform-project-web/2");
        if (element3 == null) {
            return null;
        }
        return Util.findText((Element)element3);
    }
}

