/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject.ui;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.CharConversionException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JSeparator;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.ruby.rubyproject.AutoTestSupport;
import org.netbeans.modules.ruby.rubyproject.RakeTargetsAction;
import org.netbeans.modules.ruby.rubyproject.RakeTargetsDebugAction;
import org.netbeans.modules.ruby.rubyproject.RubyProject;
import org.netbeans.modules.ruby.rubyproject.UpdateHelper;
import org.netbeans.modules.ruby.rubyproject.ui.TreeRootNode;
import org.netbeans.modules.ruby.spi.project.support.rake.PropertyEvaluator;
import org.netbeans.modules.ruby.spi.project.support.rake.ReferenceHelper;
import org.netbeans.spi.project.SubprojectProvider;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.netbeans.spi.project.ui.support.DefaultProjectOperations;
import org.netbeans.spi.project.ui.support.NodeFactorySupport;
import org.netbeans.spi.project.ui.support.ProjectSensitiveActions;
import org.openide.ErrorManager;
import org.openide.actions.FindAction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileStatusListener;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;
import org.openide.xml.XMLUtil;

public class RubyLogicalViewProvider
implements LogicalViewProvider {
    private static final boolean INCLUDE_IRB_CONSOLE = Boolean.getBoolean("ruby.irbconsole");
    private final RubyProject project;
    private final UpdateHelper helper;
    private final PropertyEvaluator evaluator;
    private final SubprojectProvider spp;
    private final ReferenceHelper resolver;
    private List<ChangeListener> changeListeners;
    private static final String[] BREAKABLE_PROPERTIES = new String[]{"javac.classpath", "run.classpath", "debug.classpath", "run.test.classpath", "debug.test.classpath", "javac.test.classpath"};
    private static Image brokenProjectBadge = Utilities.loadImage((String)"org/netbeans/modules/ruby/rubyproject/ui/resources/brokenProjectBadge.gif", (boolean)true);

    public RubyLogicalViewProvider(RubyProject rubyProject, UpdateHelper updateHelper, PropertyEvaluator propertyEvaluator, SubprojectProvider subprojectProvider, ReferenceHelper referenceHelper) {
        this.project = rubyProject;
        assert (rubyProject != null);
        this.helper = updateHelper;
        assert (updateHelper != null);
        this.evaluator = propertyEvaluator;
        assert (propertyEvaluator != null);
        this.spp = subprojectProvider;
        assert (subprojectProvider != null);
        this.resolver = referenceHelper;
    }

    public Node createLogicalView() {
        return new RubyLogicalViewRootNode();
    }

    public PropertyEvaluator getEvaluator() {
        return this.evaluator;
    }

    public ReferenceHelper getRefHelper() {
        return this.resolver;
    }

    public UpdateHelper getUpdateHelper() {
        return this.helper;
    }

    public Node findPath(Node node, Object object) {
        Project project = (Project)node.getLookup().lookup(Project.class);
        if (project == null) {
            return null;
        }
        if (object instanceof FileObject) {
            FileObject fileObject = (FileObject)object;
            Project project2 = FileOwnerQuery.getOwner((FileObject)fileObject);
            if (!project.equals(project2)) {
                return null;
            }
            Node[] nodeArray = node.getChildren().getNodes(true);
            for (int i = 0; i < nodeArray.length; ++i) {
                Node node2;
                TreeRootNode.PathFinder pathFinder = (TreeRootNode.PathFinder)nodeArray[i].getLookup().lookup(TreeRootNode.PathFinder.class);
                if (pathFinder != null && (node2 = pathFinder.findPath(nodeArray[i], object)) != null) {
                    return node2;
                }
                node2 = ((DataObject)nodeArray[i].getLookup().lookup(DataObject.class)).getPrimaryFile();
                if (!fileObject.equals(node2)) continue;
                return nodeArray[i];
            }
        }
        return null;
    }

    public synchronized void addChangeListener(ChangeListener changeListener) {
        if (this.changeListeners == null) {
            this.changeListeners = new ArrayList<ChangeListener>();
        }
        this.changeListeners.add(changeListener);
    }

    public synchronized void removeChangeListener(ChangeListener changeListener) {
        if (this.changeListeners == null) {
            return;
        }
        this.changeListeners.remove(changeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBroken() {
        ChangeListener[] changeListenerArray;
        Object object = this;
        synchronized (object) {
            if (this.changeListeners == null) {
                return;
            }
            changeListenerArray = this.changeListeners.toArray(new ChangeListener[this.changeListeners.size()]);
        }
        object = new ChangeEvent(this);
        for (int i = 0; i < changeListenerArray.length; ++i) {
            changeListenerArray[i].stateChanged((ChangeEvent)object);
        }
    }

    public boolean hasBrokenLinks() {
        return false;
    }

    public boolean hasInvalidJdkVersion() {
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class RubyLogicalViewRootNode
    extends AbstractNode
    implements Runnable,
    FileStatusListener,
    ChangeListener,
    PropertyChangeListener {
        private Image icon;
        private Lookup lookup;
        private boolean broken;
        private boolean illegalState;
        private Set<FileObject> files;
        private Map<FileSystem, FileStatusListener> fileSystemListeners;
        private RequestProcessor.Task task;
        private final Object privateLock;
        private boolean iconChange;
        private boolean nameChange;
        private ChangeListener sourcesListener;
        private Map<SourceGroup, PropertyChangeListener> groupsListeners;

        public RubyLogicalViewRootNode() {
            super(NodeFactorySupport.createCompositeChildren((Project)RubyLogicalViewProvider.this.project, (String)"Projects/org-netbeans-modules-ruby-rubyproject/Nodes"), Lookups.singleton((Object)RubyLogicalViewProvider.this.project));
            this.privateLock = new Object();
            this.setIconBaseWithExtension("org/netbeans/modules/ruby/rubyproject/ui/resources/jruby.png");
            super.setName(ProjectUtils.getInformation((Project)RubyLogicalViewProvider.this.project).getDisplayName());
            if (RubyLogicalViewProvider.this.hasBrokenLinks()) {
                this.broken = true;
            } else if (RubyLogicalViewProvider.this.hasInvalidJdkVersion()) {
                this.illegalState = true;
            }
            this.setProjectFiles(RubyLogicalViewProvider.this.project);
        }

        public String getShortDescription() {
            String string = RubyPlatform.platformDescriptionFor((Project)RubyLogicalViewProvider.this.project);
            if (string == null) {
                string = NbBundle.getMessage(RubyLogicalViewProvider.class, (String)"RubyLogicalViewProvider.PlatformNotFound");
            }
            String string2 = FileUtil.getFileDisplayName((FileObject)RubyLogicalViewProvider.this.project.getProjectDirectory());
            return NbBundle.getMessage(RubyLogicalViewProvider.class, (String)"RubyLogicalViewProvider.ProjectTooltipDescription", (Object)string2, (Object)string);
        }

        protected final void setProjectFiles(Project project) {
            Sources sources = ProjectUtils.getSources((Project)project);
            if (this.sourcesListener == null) {
                this.sourcesListener = WeakListeners.change((ChangeListener)this, (Object)sources);
                sources.addChangeListener(this.sourcesListener);
            }
            this.setGroups(Arrays.asList(sources.getSourceGroups("generic")));
        }

        private final void setGroups(Collection collection) {
            if (this.groupsListeners != null) {
                for (SourceGroup object : this.groupsListeners.keySet()) {
                    PropertyChangeListener propertyChangeListener = this.groupsListeners.get(object);
                    object.removePropertyChangeListener(propertyChangeListener);
                }
            }
            this.groupsListeners = new HashMap<SourceGroup, PropertyChangeListener>();
            HashSet hashSet = new HashSet();
            for (PropertyChangeListener propertyChangeListener : collection) {
                PropertyChangeListener propertyChangeListener2 = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)propertyChangeListener);
                this.groupsListeners.put((SourceGroup)propertyChangeListener, propertyChangeListener2);
                propertyChangeListener.addPropertyChangeListener(propertyChangeListener2);
                FileObject fileObject = propertyChangeListener.getRootFolder();
                hashSet.add(fileObject);
            }
            this.setFiles(hashSet);
        }

        protected final void setFiles(Set<FileObject> set) {
            FileStatusListener fileStatusListener;
            if (this.fileSystemListeners != null) {
                for (FileSystem object2 : this.fileSystemListeners.keySet()) {
                    fileStatusListener = this.fileSystemListeners.get(object2);
                    object2.removeFileStatusListener(fileStatusListener);
                }
            }
            this.fileSystemListeners = new HashMap<FileSystem, FileStatusListener>();
            this.files = set;
            if (set == null) {
                return;
            }
            Iterator<FileSystem> iterator = set.iterator();
            HashSet<FileSystem> hashSet = new HashSet<FileSystem>();
            while (iterator.hasNext()) {
                ErrorManager errorManager;
                fileStatusListener = (FileObject)iterator.next();
                try {
                    FileSystem fileStateInvalidException = fileStatusListener.getFileSystem();
                    if (hashSet.contains(fileStateInvalidException)) continue;
                    hashSet.add(fileStateInvalidException);
                    errorManager = FileUtil.weakFileStatusListener((FileStatusListener)this, (Object)fileStateInvalidException);
                    fileStateInvalidException.addFileStatusListener((FileStatusListener)errorManager);
                    this.fileSystemListeners.put(fileStateInvalidException, (FileStatusListener)errorManager);
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    errorManager = ErrorManager.getDefault();
                    errorManager.annotate((Throwable)fileStateInvalidException, 0, "Cannot get " + fileStatusListener + " filesystem, ignoring...", null, null, null);
                    errorManager.notify(1, (Throwable)fileStateInvalidException);
                }
            }
        }

        public String getHtmlDisplayName() {
            String string = super.getDisplayName();
            try {
                string = XMLUtil.toElementContent((String)string);
            }
            catch (CharConversionException charConversionException) {
                return string;
            }
            return this.broken || this.illegalState ? "<font color=\"#A40000\">" + string + "</font>" : null;
        }

        public Image getIcon(int n) {
            Image image = this.getMyIcon(n);
            if (this.files != null && this.files.iterator().hasNext()) {
                try {
                    FileObject fileObject = this.files.iterator().next();
                    image = fileObject.getFileSystem().getStatus().annotateIcon(image, n, this.files);
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    ErrorManager.getDefault().notify(1, (Throwable)fileStateInvalidException);
                }
            }
            return image;
        }

        private Image getMyIcon(int n) {
            Image image = super.getIcon(n);
            return this.broken || this.illegalState ? Utilities.mergeImages((Image)image, (Image)brokenProjectBadge, (int)8, (int)0) : image;
        }

        public Image getOpenedIcon(int n) {
            Image image = this.getMyOpenedIcon(n);
            if (this.files != null && this.files.iterator().hasNext()) {
                try {
                    FileObject fileObject = this.files.iterator().next();
                    image = fileObject.getFileSystem().getStatus().annotateIcon(image, n, this.files);
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    ErrorManager.getDefault().notify(1, (Throwable)fileStateInvalidException);
                }
            }
            return image;
        }

        private Image getMyOpenedIcon(int n) {
            Image image = super.getOpenedIcon(n);
            return this.broken || this.illegalState ? Utilities.mergeImages((Image)image, (Image)brokenProjectBadge, (int)8, (int)0) : image;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean bl;
            boolean bl2;
            Object object = this.privateLock;
            synchronized (object) {
                bl2 = this.iconChange;
                bl = this.nameChange;
                this.iconChange = false;
                this.nameChange = false;
            }
            if (bl2) {
                this.fireIconChange();
                this.fireOpenedIconChange();
            }
            if (bl) {
                this.fireDisplayNameChange(null, null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void annotationChanged(FileStatusEvent fileStatusEvent) {
            if (this.task == null) {
                this.task = RequestProcessor.getDefault().create((Runnable)this);
            }
            Object object = this.privateLock;
            synchronized (object) {
                if (!this.iconChange && fileStatusEvent.isIconChange() || !this.nameChange && fileStatusEvent.isNameChange()) {
                    for (FileObject fileObject : this.files) {
                        if (!fileStatusEvent.hasChanged(fileObject)) continue;
                        this.iconChange |= fileStatusEvent.isIconChange();
                        this.nameChange |= fileStatusEvent.isNameChange();
                    }
                }
            }
            this.task.schedule(50);
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            this.setProjectFiles(RubyLogicalViewProvider.this.project);
            this.fireShortDescriptionChange(null, null);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.setProjectFiles(RubyLogicalViewProvider.this.project);
        }

        public Action[] getActions(boolean bl) {
            return this.getAdditionalActions();
        }

        public boolean canRename() {
            return true;
        }

        public void setName(String string) {
            DefaultProjectOperations.performDefaultRenameOperation((Project)RubyLogicalViewProvider.this.project, (String)string);
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(RubyLogicalViewRootNode.class);
        }

        private Action[] getAdditionalActions() {
            ResourceBundle resourceBundle = NbBundle.getBundle(RubyLogicalViewProvider.class);
            ArrayList<Action> arrayList = new ArrayList<Action>();
            arrayList.add(CommonProjectActions.newFileAction());
            arrayList.add(null);
            arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"build", (String)resourceBundle.getString("LBL_BuildAction_Name"), null));
            arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"rebuild", (String)resourceBundle.getString("LBL_RebuildAction_Name"), null));
            arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"clean", (String)resourceBundle.getString("LBL_CleanAction_Name"), null));
            arrayList.add(null);
            arrayList.add((Action)SystemAction.get(RakeTargetsAction.class));
            arrayList.add((Action)SystemAction.get(RakeTargetsDebugAction.class));
            arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"rdoc", (String)resourceBundle.getString("LBL_RDocAction_Name"), null));
            arrayList.add(null);
            if (INCLUDE_IRB_CONSOLE) {
                arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"irb-console", (String)"IRB", null));
                arrayList.add(null);
            }
            arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"run", (String)resourceBundle.getString("LBL_RunAction_Name"), null));
            arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"debug", (String)resourceBundle.getString("LBL_DebugAction_Name"), null));
            arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"test", (String)resourceBundle.getString("LBL_TestAction_Name"), null));
            if (AutoTestSupport.isInstalled(RubyLogicalViewProvider.this.project)) {
                arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"autotest", (String)resourceBundle.getString("LBL_AutoTest"), null));
            }
            arrayList.add(CommonProjectActions.setProjectConfigurationAction());
            arrayList.add(null);
            arrayList.add(CommonProjectActions.setAsMainProjectAction());
            arrayList.add(CommonProjectActions.openSubprojectsAction());
            arrayList.add(CommonProjectActions.closeProjectAction());
            arrayList.add(null);
            arrayList.add(CommonProjectActions.renameProjectAction());
            arrayList.add(CommonProjectActions.moveProjectAction());
            arrayList.add(CommonProjectActions.copyProjectAction());
            arrayList.add(CommonProjectActions.deleteProjectAction());
            arrayList.add(null);
            arrayList.add((Action)SystemAction.get(FindAction.class));
            Collection collection = Lookups.forPath((String)"Projects/Actions").lookupAll(Object.class);
            if (!collection.isEmpty()) {
                arrayList.add(null);
                for (Object e : collection) {
                    if (e instanceof Action) {
                        arrayList.add((Action)e);
                        continue;
                    }
                    if (!(e instanceof JSeparator)) continue;
                    arrayList.add(null);
                }
            }
            arrayList.add(null);
            arrayList.add(CommonProjectActions.customizeProjectAction());
            return arrayList.toArray(new Action[arrayList.size()]);
        }
    }
}

