/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject.classpath;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.netbeans.api.ruby.platform.RubyInstallation;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.api.ruby.platform.RubyPlatformProvider;
import org.netbeans.modules.gsfpath.spi.classpath.ClassPathImplementation;
import org.netbeans.modules.gsfpath.spi.classpath.PathResourceImplementation;
import org.netbeans.modules.gsfpath.spi.classpath.support.ClassPathSupport;
import org.netbeans.modules.ruby.platform.gems.GemManager;
import org.netbeans.modules.ruby.spi.project.support.rake.PropertyEvaluator;
import org.openide.util.Exceptions;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class BootClassPathImplementation
implements ClassPathImplementation,
PropertyChangeListener {
    private static final Logger LOGGER;
    private static final Pattern GEM_EXCLUDE_FILTER;
    private static final Pattern GEM_INCLUDE_FILTER;
    private final PropertyEvaluator evaluator;
    private String activePlatformName;
    private boolean isActivePlatformValid;
    private List<PathResourceImplementation> resourcesCache;
    private PropertyChangeSupport support = new PropertyChangeSupport(this);

    public BootClassPathImplementation(PropertyEvaluator propertyEvaluator) {
        if (propertyEvaluator != null) {
            assert (propertyEvaluator != null);
            this.evaluator = propertyEvaluator;
            propertyEvaluator.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)propertyEvaluator));
        } else {
            this.evaluator = null;
        }
    }

    public synchronized List<PathResourceImplementation> getResources() {
        if (this.resourcesCache == null) {
            Serializable serializable2;
            ArrayList<PathResourceImplementation> arrayList = new ArrayList<PathResourceImplementation>();
            RubyPlatform rubyPlatform = new RubyPlatformProvider(this.evaluator).getPlatform();
            if (rubyPlatform == null) {
                LOGGER.severe("Cannot resolve platform for project");
            }
            if (!rubyPlatform.hasRubyGemsInstalled()) {
                LOGGER.fine("Not RubyGems installed, returning empty result");
                return Collections.emptyList();
            }
            GemManager gemManager = this.getGemManager();
            assert (gemManager != null) : "not null when RubyGems are installed";
            for (Serializable serializable2 : gemManager.getNonGemLoadPath()) {
                arrayList.add(ClassPathSupport.createResource((URL)serializable2));
            }
            Map map = gemManager.getGemUrls();
            serializable2 = GEM_INCLUDE_FILTER;
            Pattern pattern = GEM_EXCLUDE_FILTER;
            String string = this.evaluator.getProperty("ruby.includegems");
            String string2 = this.evaluator.getProperty("ruby.excludegems");
            try {
                if (string != null && string.length() > 0) {
                    serializable2 = Pattern.compile(string);
                }
                if (string2 != null && string2.length() > 0) {
                    pattern = Pattern.compile(string2);
                }
            }
            catch (PatternSyntaxException patternSyntaxException) {
                Exceptions.printStackTrace((Throwable)patternSyntaxException);
            }
            for (URL uRL : map.values()) {
                String string3;
                if (serializable2 != null && ((Pattern)serializable2).matcher(string3 = BootClassPathImplementation.getGemName(uRL)).find()) {
                    arrayList.add(ClassPathSupport.createResource((URL)uRL));
                    continue;
                }
                if (pattern != null && pattern.matcher(string3 = BootClassPathImplementation.getGemName(uRL)).find()) continue;
                arrayList.add(ClassPathSupport.createResource((URL)uRL));
            }
            this.resourcesCache = Collections.unmodifiableList(arrayList);
        }
        return this.resourcesCache;
    }

    private static String getGemName(URL uRL) {
        String string = uRL.getFile();
        if (string.endsWith("/lib/")) {
            string = string.substring(string.lastIndexOf(47, string.length() - 6) + 1, string.length() - 5);
        }
        return string;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource() == RubyInstallation.getInstance() && propertyChangeEvent.getPropertyName().equals("roots")) {
            this.resetCache();
        }
    }

    private GemManager getGemManager() {
        return new RubyPlatformProvider(this.evaluator).getPlatform().getGemManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetCache() {
        BootClassPathImplementation bootClassPathImplementation = this;
        synchronized (bootClassPathImplementation) {
            this.resourcesCache = null;
        }
        this.support.firePropertyChange("resources", null, null);
    }

    static {
        Object object;
        LOGGER = Logger.getLogger(BootClassPathImplementation.class.getName());
        String string = System.getProperty("ruby.prj.excludegems");
        if (string == null) {
            object = "^(rails|action[a-z]+|activesupport)-\\d+\\.\\d+\\.\\d+(-\\S+)?$";
            GEM_EXCLUDE_FILTER = Pattern.compile((String)object);
        } else if ("none".equals(string)) {
            GEM_EXCLUDE_FILTER = null;
        } else {
            try {
                object = Pattern.compile(string);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                Logger.getAnonymousLogger().log(Level.WARNING, "Invalid regular expression: " + string);
                Logger.getAnonymousLogger().log(Level.WARNING, patternSyntaxException.toString());
                object = null;
            }
            GEM_EXCLUDE_FILTER = object;
        }
        object = System.getProperty("ruby.prj.includegems");
        if (object == null || "all".equals(object)) {
            GEM_INCLUDE_FILTER = null;
        } else {
            Pattern pattern;
            try {
                pattern = Pattern.compile((String)object);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                Logger.getAnonymousLogger().log(Level.WARNING, "Invalid regular expression: " + (String)object);
                Logger.getAnonymousLogger().log(Level.WARNING, patternSyntaxException.toString());
                pattern = null;
            }
            GEM_INCLUDE_FILTER = pattern;
        }
    }
}

