/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject;

import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.ruby.rubyproject.RakeTargetsAction;
import org.netbeans.modules.ruby.rubyproject.RubyProject;
import org.netbeans.modules.ruby.rubyproject.ui.customizer.RubyProjectProperties;
import org.netbeans.modules.ruby.spi.project.support.rake.EditableProperties;
import org.netbeans.modules.ruby.spi.project.support.rake.ProjectGenerator;
import org.netbeans.modules.ruby.spi.project.support.rake.RakeProjectHelper;
import org.netbeans.modules.ruby.spi.project.support.rake.ReferenceHelper;
import org.openide.ErrorManager;
import org.openide.filesystems.FileAlreadyLockedException;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RubyProjectGenerator {
    public static final String DEFAULT_SRC_NAME = "src.dir";
    public static final String DEFAULT_TEST_SRC_NAME = "test.src.dir";

    private RubyProjectGenerator() {
    }

    public static RakeProjectHelper createProject(File file, String string, String string2, RubyPlatform rubyPlatform) throws IOException {
        FileObject fileObject = FileUtil.createFolder((File)file);
        RakeProjectHelper rakeProjectHelper = RubyProjectGenerator.createProject(fileObject, string, "lib", "test", string2, false, rubyPlatform);
        Project project = ProjectManager.getDefault().findProject(fileObject);
        ProjectManager.getDefault().saveProject(project);
        FileObject fileObject2 = fileObject.createFolder("lib");
        fileObject.createFolder("test");
        if (string2 != null) {
            RubyProjectGenerator.createFromTemplate(string2, fileObject2, "Templates/Ruby/main.rb");
        }
        RubyProjectGenerator.createFromTemplate("Rakefile", fileObject, "Templates/Ruby/Rakefile");
        FileObject fileObject3 = fileObject.createData("README");
        RubyProjectGenerator.writeLines(fileObject3, NbBundle.getMessage(RubyProjectGenerator.class, (String)"TXT_README_Content", (Object)string));
        RakeTargetsAction.refreshTargets(project);
        return rakeProjectHelper;
    }

    public static RakeProjectHelper createProject(File file, final String string, final File[] fileArray, final File[] fileArray2, RubyPlatform rubyPlatform) throws IOException {
        assert (fileArray != null && fileArray2 != null) : "Package roots can't be null";
        FileObject fileObject = FileUtil.createFolder((File)file);
        final RakeProjectHelper rakeProjectHelper = RubyProjectGenerator.createProject(fileObject, string, null, null, null, false, rubyPlatform);
        final RubyProject rubyProject = (RubyProject)ProjectManager.getDefault().findProject(fileObject);
        final ReferenceHelper referenceHelper = rubyProject.getReferenceHelper();
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                public Void run() throws Exception {
                    Element element;
                    String string5;
                    EditableProperties editableProperties;
                    int n;
                    String string2;
                    int n2;
                    Element element2 = rakeProjectHelper.getPrimaryConfigurationData(true);
                    Document document = element2.getOwnerDocument();
                    NodeList nodeList = element2.getElementsByTagNameNS("http://www.netbeans.org/ns/ruby-project/1", "source-roots");
                    assert (nodeList.getLength() == 1);
                    Element element3 = (Element)nodeList.item(0);
                    nodeList = element2.getElementsByTagNameNS("http://www.netbeans.org/ns/ruby-project/1", "test-roots");
                    assert (nodeList.getLength() == 1);
                    Element element4 = (Element)nodeList.item(0);
                    for (n2 = 0; n2 < fileArray.length; ++n2) {
                        if (n2 == 0) {
                            string2 = RubyProjectGenerator.DEFAULT_SRC_NAME;
                        } else {
                            String string3 = fileArray[n2].getName();
                            string2 = string3 + ".dir";
                        }
                        n = 1;
                        editableProperties = rakeProjectHelper.getProperties("nbproject/project.properties");
                        while (editableProperties.containsKey((Object)string2)) {
                            string2 = string + ++n + ".dir";
                        }
                        string5 = referenceHelper.createForeignFileReference(fileArray[n2], "ruby");
                        element = document.createElementNS("http://www.netbeans.org/ns/ruby-project/1", "root");
                        element.setAttribute("id", string2);
                        element3.appendChild(element);
                        editableProperties = rakeProjectHelper.getProperties("nbproject/project.properties");
                        editableProperties.put(string2, string5);
                        rakeProjectHelper.putProperties("nbproject/project.properties", editableProperties);
                    }
                    for (n2 = 0; n2 < fileArray2.length; ++n2) {
                        if (!fileArray2[n2].exists()) {
                            fileArray2[n2].mkdirs();
                        }
                        if (n2 == 0) {
                            string2 = RubyProjectGenerator.DEFAULT_TEST_SRC_NAME;
                        } else {
                            String string4 = fileArray2[n2].getName();
                            string2 = "test." + string4 + ".dir";
                        }
                        n = 1;
                        editableProperties = rakeProjectHelper.getProperties("nbproject/project.properties");
                        while (editableProperties.containsKey((Object)string2)) {
                            string2 = "test." + string + ++n + ".dir";
                        }
                        string5 = referenceHelper.createForeignFileReference(fileArray2[n2], "ruby");
                        element = document.createElementNS("http://www.netbeans.org/ns/ruby-project/1", "root");
                        element.setAttribute("id", string2);
                        element4.appendChild(element);
                        editableProperties = rakeProjectHelper.getProperties("nbproject/project.properties");
                        editableProperties.put(string2, string5);
                        rakeProjectHelper.putProperties("nbproject/project.properties", editableProperties);
                    }
                    rakeProjectHelper.putPrimaryConfigurationData(element2, true);
                    ProjectManager.getDefault().saveProject((Project)rubyProject);
                    return null;
                }
            });
        }
        catch (MutexException mutexException) {
            ErrorManager.getDefault().notify((Throwable)mutexException);
        }
        return rakeProjectHelper;
    }

    private static RakeProjectHelper createProject(FileObject fileObject, String string, String string2, String string3, String string4, boolean bl, RubyPlatform rubyPlatform) throws IOException {
        Object object;
        Element element;
        RakeProjectHelper rakeProjectHelper = ProjectGenerator.createProject((FileObject)fileObject, (String)"org.netbeans.modules.ruby.rubyproject");
        Element element2 = rakeProjectHelper.getPrimaryConfigurationData(true);
        Document document = element2.getOwnerDocument();
        Element element3 = document.createElementNS("http://www.netbeans.org/ns/ruby-project/1", "name");
        element3.appendChild(document.createTextNode(string));
        element2.appendChild(element3);
        EditableProperties editableProperties = rakeProjectHelper.getProperties("nbproject/project.properties");
        Element element4 = document.createElementNS("http://www.netbeans.org/ns/ruby-project/1", "source-roots");
        if (string2 != null) {
            element = document.createElementNS("http://www.netbeans.org/ns/ruby-project/1", "root");
            element.setAttribute("id", DEFAULT_SRC_NAME);
            element4.appendChild(element);
            editableProperties.setProperty(DEFAULT_SRC_NAME, string2);
        }
        element2.appendChild(element4);
        element = document.createElementNS("http://www.netbeans.org/ns/ruby-project/1", "test-roots");
        if (string3 != null) {
            object = document.createElementNS("http://www.netbeans.org/ns/ruby-project/1", "root");
            object.setAttribute("id", DEFAULT_TEST_SRC_NAME);
            element.appendChild((Node)object);
            editableProperties.setProperty(DEFAULT_TEST_SRC_NAME, string3);
        }
        element2.appendChild(element);
        rakeProjectHelper.putPrimaryConfigurationData(element2, true);
        object = FileEncodingQuery.getDefaultEncoding();
        editableProperties.setProperty("source.encoding", ((Charset)object).name());
        if (!bl) {
            editableProperties.setProperty("main.file", string4 == null ? "" : string4);
        }
        RubyProjectProperties.storePlatform(editableProperties, rubyPlatform);
        rakeProjectHelper.putProperties("nbproject/project.properties", editableProperties);
        return rakeProjectHelper;
    }

    private static DataObject createFromTemplate(String string, FileObject fileObject, String string2) throws IOException {
        Object object;
        String string3;
        String string4;
        int n = string.lastIndexOf(47);
        if (n == -1) {
            string4 = string.trim();
            string3 = null;
        } else {
            string4 = string.substring(n + 1).trim();
            string3 = string.substring(0, n).trim();
        }
        if (string4.length() == 0) {
            return null;
        }
        FileObject fileObject2 = Repository.getDefault().getDefaultFileSystem().findResource(string2);
        if (fileObject2 == null) {
            return null;
        }
        DataObject dataObject = DataObject.find((FileObject)fileObject2);
        FileObject fileObject3 = fileObject;
        if (string3 != null) {
            object = string3.replace('.', '/');
            fileObject3 = FileUtil.createFolder((FileObject)fileObject, (String)object);
        }
        object = DataFolder.findFolder((FileObject)fileObject3);
        int n2 = string4.lastIndexOf(46);
        if (n2 != -1) {
            string4 = string4.substring(0, n2);
        }
        return dataObject.createFromTemplate(object, string4);
    }

    private static void writeLines(FileObject fileObject, String ... stringArray) throws FileAlreadyLockedException, IOException {
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(fileObject.getOutputStream(), "UTF-8"));
        for (String string : stringArray) {
            printWriter.println(string);
        }
        printWriter.close();
    }
}

