/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.ruby.platform.RubyExecution;
import org.netbeans.modules.ruby.platform.execution.ExecutionDescriptor;
import org.netbeans.modules.ruby.rubyproject.RakeSupport;
import org.netbeans.modules.ruby.rubyproject.RakeTargetsDebugAction;
import org.netbeans.modules.ruby.rubyproject.RubyFileLocator;
import org.openide.ErrorManager;
import org.openide.LifecycleManager;
import org.openide.awt.Actions;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.ContextAwareAction;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RakeTargetsAction
extends SystemAction
implements ContextAwareAction {
    private static Map<FileObject, List<RakeTarget>> recentTargets = new HashMap<FileObject, List<RakeTarget>>();
    private static volatile boolean refreshing;
    private static final String RAKE_T_OUTPUT = "nbproject/private/rake-t.txt";
    private static final String REFRESH_TARGETS = "netbeans-refresh-targets";
    private static final String RAKE_ABORTED = "rake aborted!";
    protected boolean debug;

    public String getName() {
        return NbBundle.getMessage(RakeTargetsAction.class, (String)"LBL_run_targets_action");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        assert (false) : "Action should never be called without a context";
    }

    public Action createContextAwareInstance(Lookup lookup) {
        return new ContextAction(lookup, this.debug);
    }

    private static JMenu createMenu(Project project, boolean bl) {
        return new LazyMenu(project, bl);
    }

    private static List<RakeTarget> getRakeTargets(Project project) {
        try {
            String string = RakeTargetsAction.readRakeTargets(project);
            if (string == null) {
                string = RakeTargetsAction.getDefaultRakeOutput();
            }
            return RakeTargetsAction.parseTargets(new StringReader(string));
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
            return Collections.emptyList();
        }
    }

    private static List<RakeTarget> parseTargets(Reader reader) throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(reader);
        ArrayList<RakeTarget> arrayList = new ArrayList<RakeTarget>(40);
        HashMap<String, RakeTarget> hashMap = new HashMap<String, RakeTarget>(50);
        HashSet<String> hashSet = new HashSet<String>();
        while ((string = bufferedReader.readLine()) != null) {
            String string2;
            if (string.startsWith(RAKE_ABORTED) || !string.startsWith("rake ")) continue;
            int n = 5;
            int n2 = string.indexOf(32, n);
            if (n2 == -1 && (n2 = string.indexOf(35)) == -1) {
                n2 = string.length();
            }
            if (!hashSet.add(string2 = string.substring(n, n2))) continue;
            String string3 = null;
            int n3 = string.indexOf(35, n2);
            if (n3 != -1 && n3 < string.length() - 2) {
                string3 = string.substring(n3 + 2);
            }
            RakeTarget rakeTarget = null;
            String[] stringArray = string2.split(":");
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < stringArray.length - 1; ++i) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(':');
                }
                stringBuilder.append(stringArray[i]);
                String string4 = stringBuilder.toString();
                RakeTarget rakeTarget2 = (RakeTarget)hashMap.get(string4);
                if (rakeTarget2 == null) {
                    RakeTarget rakeTarget3 = new RakeTarget(stringArray[i]);
                    if (rakeTarget == null) {
                        arrayList.add(rakeTarget3);
                    } else {
                        rakeTarget.addChild(rakeTarget3);
                    }
                    hashMap.put(string4, rakeTarget3);
                    rakeTarget = rakeTarget3;
                    continue;
                }
                rakeTarget = rakeTarget2;
            }
            RakeTarget rakeTarget4 = new RakeTarget(string2, stringArray[stringArray.length - 1], string3);
            if (rakeTarget != null) {
                rakeTarget.addChild(rakeTarget4);
                continue;
            }
            arrayList.add(rakeTarget4);
        }
        return arrayList;
    }

    private static String readRakeTargets(Project project) {
        final FileObject fileObject = project.getProjectDirectory();
        try {
            final StringBuilder stringBuilder = new StringBuilder(5000);
            fileObject.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() throws IOException {
                    FileObject fileObject2 = fileObject.getFileObject(RakeTargetsAction.RAKE_T_OUTPUT);
                    if (fileObject2 == null) {
                        return;
                    }
                    BufferedReader bufferedReader = null;
                    try {
                        String string;
                        InputStream inputStream = fileObject2.getInputStream();
                        bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                        while ((string = bufferedReader.readLine()) != null) {
                            stringBuilder.append(string);
                            stringBuilder.append('\n');
                        }
                    }
                    finally {
                        if (bufferedReader != null) {
                            bufferedReader.close();
                        }
                    }
                }
            });
            if (stringBuilder.length() > 0) {
                return stringBuilder.toString();
            }
            return null;
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
            return null;
        }
    }

    static void writeRakeTargets(Project project, final String string) {
        final FileObject fileObject = project.getProjectDirectory();
        try {
            fileObject.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                public void run() throws IOException {
                    FileObject fileObject2 = fileObject.getFileObject(RakeTargetsAction.RAKE_T_OUTPUT);
                    if (fileObject2 != null) {
                        fileObject2.delete();
                    }
                    fileObject2 = FileUtil.createData((FileObject)fileObject, (String)RakeTargetsAction.RAKE_T_OUTPUT);
                    OutputStream outputStream = fileObject2.getOutputStream();
                    BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream));
                    bufferedWriter.write(string);
                    ((Writer)bufferedWriter).close();
                }
            });
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
    }

    static String getDefaultRakeOutput() {
        return "rake db:fixtures:load          # Load fixtures into the current environment's database.  Load specific fixtures using FIXTURES=x,y\nrake db:migrate                # Migrate the database through scripts in db/migrate. Target specific version with VERSION=x\nrake db:schema:dump            # Create a db/schema.rb file that can be portably used against any DB supported by AR\nrake db:schema:load            # Load a schema.rb file into the database\nrake db:sessions:clear         # Clear the sessions table\nrake db:sessions:create        # Creates a sessions table for use with CGI::Session::ActiveRecordStore\nrake db:structure:dump         # Dump the database structure to a SQL file\nrake db:test:clone             # Recreate the test database from the current environment's database schema\nrake db:test:clone_structure   # Recreate the test databases from the development structure\nrake db:test:prepare           # Prepare the test database and load the schema\nrake db:test:purge             # Empty the test database\nrake doc:app                   # Build the app HTML Files\nrake doc:clobber_app           # Remove rdoc products\nrake doc:clobber_plugins       # Remove plugin documentation\nrake doc:clobber_rails         # Remove rdoc products\nrake doc:plugins               # Generate documation for all installed plugins\nrake doc:rails                 # Build the rails HTML Files\nrake doc:reapp                 # Force a rebuild of the RDOC files\nrake doc:rerails               # Force a rebuild of the RDOC files\nrake log:clear                 # Truncates all *.log files in log/ to zero bytes\nrake rails:freeze:edge         # Lock to latest Edge Rails or a specific revision with REVISION=X (ex: REVISION=4021) or a tag with TAG=Y (ex: TAG=rel_1-1-0)\nrake rails:freeze:gems         # Lock this application to the current gems (by unpacking them into vendor/rails)\nrake rails:unfreeze            # Unlock this application from freeze of gems or edge and return to a fluid use of system gems\nrake rails:update              # Update both configs, scripts and public/javascripts from Rails\nrake rails:update:configs      # Update config/boot.rb from your current rails install\nrake rails:update:javascripts  # Update your javascripts from your current rails install\nrake rails:update:scripts      # Add new scripts to the application script/ directory\nrake stats                     # Report code statistics (KLOCs, etc) from the application\nrake test                      # Test all units and functionals\nrake test:functionals          # Run the functional tests in test/functional\nrake test:integration          # Run the integration tests in test/integration\nrake test:plugins              # Run the plugin tests in vendor/plugins/** /test (or specify with PLUGIN=name)\nrake test:recent               # Test recent changes\nrake test:uncommitted          # Test changes since last checkin (only Subversion)\nrake test:units                # Run the unit tests in test/unit\nrake tmp:cache:clear           # Clears all files and directories in tmp/cache\nrake tmp:clear                 # Clear session, cache, and socket files from tmp/\nrake tmp:create                # Creates tmp directories for sessions, cache, and sockets\nrake tmp:pids:clear            # Clears all files in tmp/pids\nrake tmp:sessions:clear        # Clears all files in tmp/sessions\nrake tmp:sockets:clear         # Clears all files in tmp/sockets\n";
    }

    public static void refreshTargets(Project project) {
        if (!RubyPlatform.hasValidRake((Project)project, (boolean)true)) {
            return;
        }
        refreshing = true;
        String string = RakeTargetsAction.hiddenRakeRunner(project);
        RakeTargetsAction.writeRakeTargets(project, string);
        refreshing = false;
    }

    private static String hiddenRakeRunner(Project project) {
        FileObject fileObject = RakeSupport.findRakeFile(project);
        File file = fileObject == null ? FileUtil.toFile((FileObject)project.getProjectDirectory()) : FileUtil.toFile((FileObject)fileObject.getParent());
        String string = RubyPlatform.gemManagerFor((Project)project).getRake();
        RubyPlatform rubyPlatform = RubyPlatform.platformFor((Project)project);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(RakeTargetsAction.hiddenRakeRunner(rubyPlatform, string, file, "-T"));
        return stringBuffer.toString();
    }

    private static String hiddenRakeRunner(RubyPlatform rubyPlatform, String string, File file, String string2) {
        StringBuilder stringBuilder;
        block10: {
            ArrayList<String> arrayList = new ArrayList<String>();
            File file2 = rubyPlatform.getInterpreterFile();
            if (!file2.getName().startsWith("jruby") || RubyExecution.LAUNCH_JRUBY_SCRIPT) {
                arrayList.add(file2.getPath());
            }
            arrayList.addAll(RubyExecution.getRubyArgs((RubyPlatform)rubyPlatform));
            arrayList.add(string);
            arrayList.add(string2);
            String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
            ProcessBuilder processBuilder = new ProcessBuilder(stringArray);
            processBuilder.directory(file);
            processBuilder.redirectErrorStream(true);
            Map<String, String> map = processBuilder.environment();
            new RubyExecution(new ExecutionDescriptor(rubyPlatform, "rake", file).cmd(file2)).setupProcessEnvironment(map);
            int n = -1;
            stringBuilder = new StringBuilder(5000);
            try {
                String string3;
                Process process = processBuilder.start();
                InputStream inputStream = process.getInputStream();
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                try {
                    while ((string3 = bufferedReader.readLine()) != null) {
                        stringBuilder.append(string3);
                        stringBuilder.append("\n");
                    }
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
                n = process.waitFor();
                if (n == 0) break block10;
                try {
                    inputStream = process.getErrorStream();
                    inputStreamReader = new InputStreamReader(inputStream);
                    bufferedReader = new BufferedReader(inputStreamReader);
                    while ((string3 = bufferedReader.readLine()) != null) {
                        stringBuilder.append(string3);
                        stringBuilder.append('\n');
                    }
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
            catch (InterruptedException interruptedException) {
                ErrorManager.getDefault().notify((Throwable)interruptedException);
            }
        }
        return stringBuilder.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RakeTarget {
        private final String target;
        private final String description;
        private final String displayName;
        private List<RakeTarget> children;

        public RakeTarget(String string) {
            this(null, string, null);
        }

        public RakeTarget(String string, String string2, String string3) {
            this.target = string;
            this.displayName = string2;
            this.description = string3;
        }

        public boolean isTarget() {
            return this.target != null;
        }

        public String getTarget() {
            return this.target;
        }

        public List<RakeTarget> getChildren() {
            return this.children;
        }

        public String getDescription() {
            return this.description;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public void addChild(RakeTarget rakeTarget) {
            if (this.children == null) {
                this.children = new ArrayList<RakeTarget>();
            }
            this.children.add(rakeTarget);
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            RakeTarget rakeTarget = (RakeTarget)object;
            return this.target == rakeTarget.target || this.target != null && this.target.equals(rakeTarget.target);
        }

        public int hashCode() {
            int n = 7;
            n = 59 * n + (this.target != null ? this.target.hashCode() : 0);
            return n;
        }
    }

    private static final class TargetMenuItemHandler
    implements ActionListener,
    Runnable {
        private final Project project;
        private final RakeTarget target;
        private final boolean debug;

        public TargetMenuItemHandler(Project project, RakeTarget rakeTarget, boolean bl) {
            this.project = project;
            this.target = rakeTarget;
            this.debug = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            RequestProcessor.getDefault().post((Runnable)this);
        }

        public void run() {
            if (!RubyPlatform.hasValidRake((Project)this.project, (boolean)true)) {
                return;
            }
            if (this.target.getTarget().equals(RakeTargetsAction.REFRESH_TARGETS)) {
                refreshing = true;
                final ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(RakeTargetsAction.class, (String)"RefreshingTargets"));
                progressHandle.start();
                progressHandle.switchToIndeterminate();
                RequestProcessor.getDefault().post(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            RakeTargetsAction.refreshTargets(TargetMenuItemHandler.this.project);
                        }
                        finally {
                            if (progressHandle != null) {
                                progressHandle.finish();
                            }
                        }
                    }
                });
                return;
            }
            LifecycleManager.getDefault().saveAll();
            RubyFileLocator rubyFileLocator = new RubyFileLocator(Lookup.EMPTY, this.project);
            String string = NbBundle.getMessage(RakeTargetsAction.class, (String)"Rake");
            ProjectInformation projectInformation = ProjectUtils.getInformation((Project)this.project);
            if (projectInformation != null) {
                string = projectInformation.getDisplayName();
            }
            File file = null;
            FileObject fileObject = RakeSupport.findRakeFile(this.project);
            if (fileObject == null) {
                file = FileUtil.toFile((FileObject)this.project.getProjectDirectory());
            }
            RakeSupport rakeSupport = new RakeSupport(this.project);
            String string2 = this.target.getTarget();
            if (string2 != null && (string2.equals("test") || string2.startsWith("test:"))) {
                rakeSupport.setTest(true);
            }
            rakeSupport.runRake(file, fileObject, string, rubyFileLocator, true, this.debug, string2);
            if (fileObject != null) {
                ArrayList<RakeTarget> arrayList = (ArrayList<RakeTarget>)recentTargets.get(fileObject);
                if (arrayList == null) {
                    arrayList = new ArrayList<RakeTarget>();
                    recentTargets.put(fileObject, arrayList);
                }
                arrayList.remove(this.target);
                arrayList.add(this.target);
            }
        }
    }

    private static final class LazyMenu
    extends JMenu {
        private final Project project;
        private boolean initialized;
        private final boolean debug;

        public LazyMenu(Project project, boolean bl) {
            super(((RakeTargetsAction)SystemAction.get(bl ? RakeTargetsDebugAction.class : RakeTargetsAction.class)).getName());
            this.debug = bl;
            this.project = project;
        }

        public JPopupMenu getPopupMenu() {
            if (refreshing) {
                super.removeAll();
                JMenuItem jMenuItem = new JMenuItem(NbBundle.getMessage(RakeTargetsAction.class, (String)"Refreshing"));
                this.add(jMenuItem);
                this.initialized = false;
                return super.getPopupMenu();
            }
            if (!this.initialized) {
                Object object;
                Object object2;
                this.initialized = true;
                super.removeAll();
                List list = RakeTargetsAction.getRakeTargets(this.project);
                boolean bl = false;
                FileObject fileObject = RakeSupport.findRakeFile(this.project);
                if (fileObject != null && (object2 = (List)recentTargets.get(fileObject)) != null) {
                    for (int i = object2.size() - 1; i >= 0; --i) {
                        object = (RakeTarget)object2.get(i);
                        assert (((RakeTarget)object).isTarget());
                        JMenuItem jMenuItem = new JMenuItem(((RakeTarget)object).getTarget());
                        jMenuItem.addActionListener(new TargetMenuItemHandler(this.project, (RakeTarget)object, this.debug));
                        jMenuItem.setToolTipText(((RakeTarget)object).getDescription());
                        this.add(jMenuItem);
                        bl = true;
                    }
                }
                if (bl) {
                    bl = false;
                    this.addSeparator();
                }
                for (RakeTarget rakeTarget : list) {
                    if (rakeTarget.isTarget()) {
                        object = new JMenuItem(rakeTarget.getDisplayName());
                        ((AbstractButton)object).addActionListener(new TargetMenuItemHandler(this.project, rakeTarget, this.debug));
                        ((JComponent)object).setToolTipText(rakeTarget.getDescription());
                        this.add((JMenuItem)object);
                    } else {
                        object = this.buildMenu(rakeTarget);
                        this.add((JMenuItem)object);
                    }
                    bl = true;
                }
                if (bl) {
                    bl = false;
                    this.addSeparator();
                }
                object2 = new JMenuItem(NbBundle.getMessage(RakeTargetsAction.class, (String)"RefreshTargets"));
                ((AbstractButton)object2).addActionListener(new TargetMenuItemHandler(this.project, new RakeTarget(RakeTargetsAction.REFRESH_TARGETS, null, null), this.debug));
                ((JComponent)object2).setToolTipText(NbBundle.getMessage(RakeTargetsAction.class, (String)"RefreshTargetsHint"));
                this.add((JMenuItem)object2);
            }
            return super.getPopupMenu();
        }

        private JMenu buildMenu(RakeTarget rakeTarget) {
            assert (!rakeTarget.isTarget());
            JMenu jMenu = new JMenu(rakeTarget.getDisplayName());
            List<RakeTarget> list = rakeTarget.getChildren();
            for (RakeTarget rakeTarget2 : list) {
                JMenuItem jMenuItem;
                if (rakeTarget2.isTarget()) {
                    jMenuItem = new JMenuItem(rakeTarget2.getDisplayName());
                    jMenuItem.addActionListener(new TargetMenuItemHandler(this.project, rakeTarget2, this.debug));
                    jMenuItem.setToolTipText(rakeTarget2.getDescription());
                    jMenu.add(jMenuItem);
                    continue;
                }
                jMenuItem = this.buildMenu(rakeTarget2);
                jMenu.add(jMenuItem);
            }
            return jMenu;
        }
    }

    private static final class ContextAction
    extends AbstractAction
    implements Presenter.Popup {
        private final Project project;
        private final boolean debug;

        public ContextAction(Lookup lookup, boolean bl) {
            super(((RakeTargetsAction)SystemAction.get(bl ? RakeTargetsDebugAction.class : RakeTargetsAction.class)).getName());
            this.debug = bl;
            Collection collection = lookup.lookupAll(Project.class);
            this.project = collection.size() == 1 ? (Project)collection.iterator().next() : null;
            super.setEnabled(this.project != null);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            assert (false) : "Action should not be called directly";
        }

        public JMenuItem getPopupPresenter() {
            if (this.project != null) {
                return RakeTargetsAction.createMenu(this.project, this.debug);
            }
            return new Actions.MenuItem((Action)this, false);
        }

        public void setEnabled(boolean bl) {
            assert (false) : "No modifications to enablement status permitted";
        }
    }
}

