/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.ruby.spi.project.support.rake.PropertyEvaluator;
import org.netbeans.modules.ruby.spi.project.support.rake.PropertyUtils;
import org.netbeans.modules.ruby.spi.project.support.rake.RakeProjectHelper;
import org.netbeans.modules.ruby.spi.project.support.rake.ReferenceHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectPropertyExtender {
    private PropertyEvaluator evaluator;
    private ReferenceHelper referenceHelper;
    private RakeProjectHelper antProjectHelper;
    private Set<String> wellKnownPaths;
    private String libraryPrefix;
    private String librarySuffix;
    private String antArtifactPrefix;

    public ProjectPropertyExtender(PropertyEvaluator propertyEvaluator, ReferenceHelper referenceHelper, RakeProjectHelper rakeProjectHelper, String[] stringArray, String string, String string2, String string3) {
        this.evaluator = propertyEvaluator;
        this.referenceHelper = referenceHelper;
        this.antProjectHelper = rakeProjectHelper;
        this.wellKnownPaths = stringArray == null ? null : new HashSet<String>(Arrays.asList(stringArray));
        this.libraryPrefix = string;
        this.librarySuffix = string2;
        this.antArtifactPrefix = string3;
    }

    public Iterator<Item> itemsIterator(String string) {
        return this.itemsList(string).iterator();
    }

    private boolean isWellKnownPath(String string) {
        return this.wellKnownPaths == null ? false : this.wellKnownPaths.contains(string);
    }

    public List<Item> itemsList(String string) {
        String[] stringArray = PropertyUtils.tokenizePath((String)(string == null ? "" : string));
        ArrayList<Item> arrayList = new ArrayList<Item>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            Item item;
            if (this.isWellKnownPath(stringArray[i])) {
                item = Item.create(stringArray[i]);
            } else {
                String string2 = this.evaluator.evaluate(stringArray[i]);
                File file = null;
                if (string2 != null) {
                    file = this.antProjectHelper.resolveFile(string2);
                }
                item = file == null || !file.exists() ? Item.createBroken(0, stringArray[i]) : Item.create(file, stringArray[i]);
            }
            arrayList.add(item);
        }
        return arrayList;
    }

    public String[] encodeToStrings(Iterator<Item> iterator) {
        String[] stringArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        while (iterator.hasNext()) {
            stringArray = iterator.next();
            String string = null;
            switch (stringArray.getType()) {
                case 0: {
                    string = stringArray.getReference();
                    if (stringArray.isBroken() || string != null) break;
                    File file = stringArray.getFile();
                    string = this.referenceHelper.createForeignFileReference(file, null);
                    break;
                }
                case 3: {
                    string = stringArray.getReference();
                }
            }
            if (string == null) continue;
            arrayList.add(string);
        }
        stringArray = new String[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            stringArray[i] = i < arrayList.size() - 1 ? (String)arrayList.get(i) + ":" : (String)arrayList.get(i);
        }
        return stringArray;
    }

    public static class Item {
        public static final int TYPE_JAR = 0;
        public static final int TYPE_LIBRARY = 1;
        public static final int TYPE_ARTIFACT = 2;
        public static final int TYPE_CLASSPATH = 3;
        private static final String BROKEN = "BrokenReference";
        private Object object;
        private URI artifactURI;
        private int type;
        private String property;

        private Item(int n, Object object, String string) {
            this.type = n;
            this.object = object;
            this.property = string;
        }

        private Item(int n, Object object, URI uRI, String string) {
            this(n, object, string);
            this.artifactURI = uRI;
        }

        public static Item create(File file, String string) {
            if (file == null) {
                throw new IllegalArgumentException("file must not be null");
            }
            return new Item(0, file, string);
        }

        public static Item create(String string) {
            if (string == null) {
                throw new IllegalArgumentException("property must not be null");
            }
            return new Item(3, null, string);
        }

        public static Item createBroken(int n, String string) {
            if (string == null) {
                throw new IllegalArgumentException("property must not be null in broken items");
            }
            return new Item(n, BROKEN, string);
        }

        public int getType() {
            return this.type;
        }

        public File getFile() {
            if (this.getType() != 0) {
                throw new IllegalArgumentException("Item is not of required type - JAR");
            }
            return (File)this.object;
        }

        public URI getArtifactURI() {
            if (this.getType() != 2) {
                throw new IllegalArgumentException("Item is not of required type - ARTIFACT");
            }
            return this.artifactURI;
        }

        public String getReference() {
            return this.property;
        }

        public boolean isBroken() {
            return this.object == BROKEN;
        }

        public int hashCode() {
            int n = this.getType();
            if (this.object == BROKEN) {
                return BROKEN.hashCode();
            }
            switch (this.getType()) {
                case 3: {
                    n += this.property.hashCode();
                    break;
                }
                default: {
                    n += this.object.hashCode();
                }
            }
            return n;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Item)) {
                return false;
            }
            Item item = (Item)object;
            if (this.getType() != item.getType()) {
                return false;
            }
            if (this.isBroken() != item.isBroken()) {
                return false;
            }
            if (this.isBroken()) {
                return this.getReference().equals(item.getReference());
            }
            switch (this.getType()) {
                case 3: {
                    return this.property.equals(item.property);
                }
            }
            return this.object.equals(item.object);
        }
    }
}

