/*
 * Decompiled with CFR 0.152.
 */
package com.sun.errorhandler;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class DebugClientTestThread
extends Thread {
    BufferedReader in = null;
    PrintWriter out = null;
    JTextArea textArea = null;
    StringBuffer message = new StringBuffer();
    Socket clientSocket = null;
    boolean connected = false;
    boolean connectionFailed = false;

    public DebugClientTestThread(JTextArea textArea) {
        this.textArea = textArea;
    }

    public void run() {
        try {
            this.clientSocket = new Socket("localhost", 4444);
            this.displayText("Connected to server\n");
            this.connected = true;
        }
        catch (UnknownHostException exc) {
            this.displayText("Could not connect. unknown host." + exc.getLocalizedMessage());
            this.connectionFailed = true;
        }
        catch (IOException exc) {
            this.displayText("Couldn't get I/O for the connection" + exc.getLocalizedMessage());
            this.connectionFailed = true;
        }
        try {
            this.out = new PrintWriter(this.clientSocket.getOutputStream(), true);
            this.in = new BufferedReader(new InputStreamReader(this.clientSocket.getInputStream()));
        }
        catch (IOException exc) {
            this.displayText("Could not get the socket I/O" + exc.getLocalizedMessage());
        }
        while (this.connected) {
            try {
                String line = this.in.readLine();
                if (line != null) {
                    this.displayText(line);
                    this.message.append(line + "\n");
                    continue;
                }
                this.connected = false;
                this.displayText("Connection closed");
            }
            catch (IOException exc) {
                this.displayText(exc.getLocalizedMessage());
                this.connected = false;
            }
        }
    }

    public boolean isConnected() {
        while (!this.connected) {
            if (!this.connectionFailed) continue;
            return false;
        }
        return this.connected;
    }

    public void disconnect() {
        if (this.connected) {
            try {
                this.out.close();
                this.in.close();
                this.clientSocket.close();
            }
            catch (IOException exc) {
                this.displayText("Error occured while disconnecting socket" + exc.getLocalizedMessage());
            }
            this.out = null;
            this.in = null;
            this.clientSocket = null;
            this.connected = false;
        }
    }

    public void sendMessage(String text) {
        if (this.out != null) {
            this.out.println(text);
        }
    }

    public String getMessage() {
        return this.message.toString();
    }

    private void displayText(final String line) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DebugClientTestThread.this.textArea.append(line);
            }
        });
    }
}

