/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.server.output;

import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.server.output.FileInputProvider;
import org.netbeans.api.server.output.LineProcessor;
import org.netbeans.api.server.output.LineReader;
import org.netbeans.modules.server.output.LineParsingHelper;
import org.openide.util.Parameters;

public class FileLineReader
implements LineReader {
    private static final Logger LOGGER = Logger.getLogger(FileLineReader.class.getName());
    private static final int BUFFER_SIZE = 128;
    private final LineParsingHelper helper = new LineParsingHelper();
    private final FileInputProvider fileProvider;
    private final ByteBuffer buffer = ByteBuffer.allocateDirect(128);
    private FileInputProvider.FileInput currentFile;
    private ReadableByteChannel channel;
    private long fileLength;
    private boolean closed;

    public FileLineReader(FileInputProvider fileInputProvider) {
        Parameters.notNull((CharSequence)"fileProvider", (Object)fileInputProvider);
        this.fileProvider = fileInputProvider;
    }

    public int readLines(LineProcessor lineProcessor, boolean bl) {
        Object object;
        int n;
        block15: {
            if (this.closed) {
                throw new IllegalStateException("Already closed reader");
            }
            n = 0;
            try {
                object = this.fileProvider.getFileInput();
                if (this.currentFile != object && (this.currentFile == null || !this.currentFile.equals(object)) || this.fileLength > this.currentFile.getFile().length() || this.channel == null) {
                    if (this.channel != null) {
                        this.channel.close();
                    }
                    this.currentFile = object;
                    if (this.currentFile != null && this.currentFile.getFile().exists() && this.currentFile.getFile().canRead()) {
                        this.channel = Channels.newChannel(new FileInputStream(this.currentFile.getFile()));
                    }
                    if (this.fileLength > 0L) {
                        lineProcessor.reset();
                    }
                    this.fileLength = 0L;
                }
                if (this.channel == null) {
                    return n;
                }
                this.buffer.clear();
                int n2 = this.channel.read(this.buffer);
                if (n2 > 0) {
                    this.fileLength += (long)n2;
                    this.buffer.position(0).limit(n2);
                    String[] stringArray = this.helper.parse(this.buffer, this.currentFile.getCharset());
                    n += stringArray.length;
                    if (lineProcessor != null) {
                        for (String string : stringArray) {
                            lineProcessor.processLine(string);
                        }
                    }
                }
            }
            catch (IOException iOException) {
                LOGGER.log(Level.INFO, null, iOException);
                if (this.channel == null) break block15;
                try {
                    this.channel.close();
                }
                catch (IOException iOException2) {
                    LOGGER.log(Level.FINE, null, iOException);
                }
            }
        }
        if (bl && (object = this.helper.getTrailingLine(true)) != null) {
            if (lineProcessor != null) {
                lineProcessor.processLine((String)object);
            }
            ++n;
        }
        return n;
    }

    public void close() throws IOException {
        this.closed = true;
        if (this.channel != null) {
            this.channel.close();
            this.channel = null;
        }
    }
}

