/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.server.output;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.server.output.LineProcessor;
import org.netbeans.api.server.output.LineReader;
import org.netbeans.modules.server.output.ReaderThread;
import org.openide.util.Parameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ReaderManager {
    private static final Logger LOGGER;
    private final List<ReaderThread> threads = new ArrayList<ReaderThread>();
    private boolean started = false;
    private int finishedCount = 0;

    private ReaderManager(Pair ... pairArray) {
        for (int i = 0; i < pairArray.length; ++i) {
            if (pairArray[i] == null) continue;
            this.threads.add(new ReaderThread(this, pairArray[i].getReader(), pairArray[i].getProcessor()));
        }
    }

    public static ReaderManager newManager(Pair ... pairArray) {
        return new ReaderManager(pairArray);
    }

    public static ReaderManager newManager(LineReader lineReader, LineProcessor lineProcessor) {
        return ReaderManager.newManager(new Pair(lineReader, lineProcessor));
    }

    public synchronized void start() {
        if (this.started) {
            return;
        }
        LOGGER.log(Level.FINE, "Starting reader manager");
        for (ReaderThread readerThread : this.threads) {
            readerThread.start();
        }
        this.started = true;
    }

    public synchronized void stop() {
        LOGGER.log(Level.FINE, "Stopping reader manager");
        for (ReaderThread readerThread : this.threads) {
            readerThread.interrupt();
        }
    }

    public synchronized boolean isRunning() {
        return this.finishedCount < this.threads.size();
    }

    List<ReaderThread> getThreads() {
        return Collections.unmodifiableList(this.threads);
    }

    private synchronized void notifyFinished(ReaderThread readerThread) {
        ++this.finishedCount;
    }

    static {
        ReaderThread.Accessor.DEFAULT = new ReaderThread.Accessor(){

            public void notifyFinished(ReaderManager readerManager, ReaderThread readerThread) {
                readerManager.notifyFinished(readerThread);
            }
        };
        LOGGER = Logger.getLogger(ReaderManager.class.getName());
    }

    public static final class Pair {
        private final LineReader reader;
        private final LineProcessor processor;

        public Pair(LineReader lineReader, LineProcessor lineProcessor) {
            Parameters.notNull((CharSequence)"reader", (Object)lineReader);
            this.reader = lineReader;
            this.processor = lineProcessor;
        }

        private LineReader getReader() {
            return this.reader;
        }

        private LineProcessor getProcessor() {
            return this.processor;
        }
    }
}

