/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.project.jsfloader;

import java.beans.PropertyVetoException;
import org.netbeans.modules.visualweb.project.jsf.api.JsfProjectUtils;
import org.netbeans.modules.visualweb.project.jsfloader.JsfJavaDataObject;
import org.netbeans.modules.visualweb.project.jsfloader.JsfJavaEditorSupport;
import org.netbeans.modules.visualweb.project.jsfloader.JsfJspDataObject;
import org.netbeans.modules.visualweb.project.jsfloader.JsfJspEditorSupport;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;

final class Utils {
    private Utils() {
    }

    public static FileObject findJavaForJsp(FileObject fileObject) {
        if (fileObject == null) {
            return null;
        }
        if (Utils.isTemplateFileObject(fileObject)) {
            FileObject fileObject2 = fileObject.getParent();
            return fileObject2.getFileObject(fileObject.getName(), "java");
        }
        return JsfProjectUtils.getJavaForJsp((FileObject)fileObject);
    }

    public static FileObject findJspForJava(FileObject fileObject) {
        if (fileObject == null) {
            return null;
        }
        if (Utils.isTemplateFileObject(fileObject)) {
            FileObject fileObject2 = fileObject.getParent();
            FileObject fileObject3 = fileObject2.getFileObject(fileObject.getName(), "jsp");
            if (fileObject3 != null) {
                return fileObject3;
            }
            return fileObject2.getFileObject(fileObject.getName(), "jspf");
        }
        return JsfProjectUtils.getJspForJava((FileObject)fileObject);
    }

    public static FileObject findJavaFolderForJsp(FileObject fileObject) {
        if (fileObject == null) {
            return null;
        }
        if (Utils.isTemplateFileObject(fileObject)) {
            return fileObject.getParent();
        }
        return JsfProjectUtils.getJavaFolderForJsp((FileObject)fileObject);
    }

    public static FileObject findJspFolderForJava(FileObject fileObject) {
        if (fileObject == null) {
            return null;
        }
        if (Utils.isTemplateFileObject(fileObject)) {
            return fileObject.getParent();
        }
        return JsfProjectUtils.getJspFolderForJava((FileObject)fileObject);
    }

    public static boolean isTemplateFileObject(FileObject fileObject) {
        Object object = fileObject.getAttribute("template");
        boolean bl = object instanceof Boolean ? (Boolean)object : false;
        if (bl) {
            return true;
        }
        FileObject fileObject2 = Repository.getDefault().getDefaultFileSystem().getRoot().getFileObject("Templates");
        if (fileObject2 != null) {
            return FileUtil.isParentOf((FileObject)fileObject2, (FileObject)fileObject);
        }
        return false;
    }

    public static JsfJspDataObject findCorrespondingJsfJspDataObject(FileObject fileObject, boolean bl) {
        FileObject fileObject2 = Utils.findJspForJava(fileObject);
        if (fileObject2 == null) {
            if (!bl) {
                ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("Can't find corresponding jsp file to " + fileObject));
            }
            return null;
        }
        try {
            DataObject dataObject = DataObject.find((FileObject)fileObject2);
            if (dataObject instanceof JsfJspDataObject) {
                return (JsfJspDataObject)dataObject;
            }
            try {
                dataObject.setValid(false);
                dataObject = DataObject.find((FileObject)fileObject2);
            }
            catch (PropertyVetoException propertyVetoException) {
                ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("Corresponding jsp data object is not jsf " + dataObject));
            }
            if (!bl) {
                ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("Corresponding jsp data object is not jsf " + dataObject));
            }
            return null;
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            if (!bl) {
                ErrorManager.getDefault().notify(1, (Throwable)dataObjectNotFoundException);
            }
            return null;
        }
    }

    public static JsfJspEditorSupport findCorrespondingJsfJspEditorSupport(FileObject fileObject, boolean bl) {
        JsfJspDataObject jsfJspDataObject = Utils.findCorrespondingJsfJspDataObject(fileObject, false);
        if (jsfJspDataObject == null) {
            ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("Can't find jsp data object to " + fileObject));
            return null;
        }
        return jsfJspDataObject.getCookie(JsfJspEditorSupport.class);
    }

    public static JsfJavaDataObject findCorrespondingJsfJavaDataObject(FileObject fileObject, boolean bl) {
        FileObject fileObject2 = Utils.findJavaForJsp(fileObject);
        if (fileObject2 == null) {
            if (!bl) {
                ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("Can't find corresponding java file to " + fileObject));
            }
            return null;
        }
        try {
            DataObject dataObject = DataObject.find((FileObject)fileObject2);
            if (dataObject instanceof JsfJavaDataObject) {
                return (JsfJavaDataObject)dataObject;
            }
            try {
                dataObject.setValid(false);
                dataObject = DataObject.find((FileObject)fileObject2);
            }
            catch (PropertyVetoException propertyVetoException) {
                ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("Corresponding java data object is not jsf " + dataObject));
            }
            return dataObject instanceof JsfJavaDataObject ? (JsfJavaDataObject)dataObject : null;
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            ErrorManager.getDefault().notify(1, (Throwable)dataObjectNotFoundException);
            return null;
        }
    }

    public static JsfJavaEditorSupport findCorrespondingJsfJavaEditorSupport(FileObject fileObject, boolean bl) {
        JsfJavaDataObject jsfJavaDataObject = Utils.findCorrespondingJsfJavaDataObject(fileObject, bl);
        if (jsfJavaDataObject == null) {
            if (!bl) {
                ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("Can't find java data object to " + fileObject));
            }
            return null;
        }
        return jsfJavaDataObject.getCookie(JsfJavaEditorSupport.class);
    }

    public static final String getBeanNameForJsp(FileObject fileObject) {
        String string = JsfProjectUtils.getBasePathForJsp((FileObject)fileObject);
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            return string;
        }
        if (string.charAt(0) == '/') {
            string = string.substring(1);
        }
        string = string.replace('/', '$');
        return string;
    }
}

