/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.project.jsfloader;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.WeakHashMap;
import javax.swing.Action;
import javax.swing.JComponent;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.core.spi.multiview.CloseOperationState;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.netbeans.core.spi.multiview.MultiViewElementCallback;
import org.netbeans.modules.visualweb.project.jsfloader.JsfJspDataObject;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.LookupProvider;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.openide.awt.UndoRedo;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class OpenEditOverride
implements LookupProvider {
    private static final String OPEN_FILES_NS = "http://www.netbeans.org/ns/projectui-open-files/1";
    private static final String OPEN_FILES_ELEMENT = "open-files";
    private static final String FILE_ELEMENT = "file";
    static final String MULTIVIEW_ATTRIBUTE = "selected-multiview";
    private static WeakHashMap<Project, HashMap<FileObject, String>> multiViewsByProject = new WeakHashMap();

    public Lookup createAdditionalLookup(Lookup lookup) {
        Project project = (Project)lookup.lookup(Project.class);
        return Lookups.singleton((Object)((Object)new ProjectOpenedHookImpl(project)));
    }

    private static void multiViewChanged(Project project, DataObject dataObject, String string) {
        HashMap<Object, String> hashMap = multiViewsByProject.get(project);
        if (hashMap == null) {
            hashMap = new HashMap();
            multiViewsByProject.put(project, hashMap);
        }
        hashMap.put(dataObject.getPrimaryFile(), string);
    }

    private static void unregisterProject(Project project) {
        multiViewsByProject.remove(project);
    }

    static final class MultiViewDelegate
    implements MultiViewElement {
        private final MultiViewElement originalElement;
        private final String mvIdentifier;
        private final DataObject dobj;
        private WeakReference<Project> associatedProject;

        public MultiViewDelegate(MultiViewElement multiViewElement, String string, DataObject dataObject) {
            this.originalElement = multiViewElement;
            this.mvIdentifier = string;
            this.dobj = dataObject;
            this.associatedProject = new WeakReference<Project>(FileOwnerQuery.getOwner((FileObject)dataObject.getPrimaryFile()));
        }

        public MultiViewElement getOriginal() {
            return this.originalElement;
        }

        public void componentShowing() {
            Project project = (Project)this.associatedProject.get();
            if (project != null) {
                OpenEditOverride.multiViewChanged(project, this.dobj, this.mvIdentifier);
            }
            this.originalElement.componentShowing();
        }

        public JComponent getVisualRepresentation() {
            return this.originalElement.getVisualRepresentation();
        }

        public JComponent getToolbarRepresentation() {
            return this.originalElement.getToolbarRepresentation();
        }

        public Action[] getActions() {
            return this.originalElement.getActions();
        }

        public Lookup getLookup() {
            return this.originalElement.getLookup();
        }

        public void componentOpened() {
            this.originalElement.componentOpened();
        }

        public void componentClosed() {
            this.originalElement.componentClosed();
        }

        public void componentHidden() {
            this.originalElement.componentHidden();
        }

        public void componentActivated() {
            this.originalElement.componentActivated();
        }

        public void componentDeactivated() {
            this.originalElement.componentDeactivated();
        }

        public UndoRedo getUndoRedo() {
            return this.originalElement.getUndoRedo();
        }

        public void setMultiViewCallback(MultiViewElementCallback multiViewElementCallback) {
            this.originalElement.setMultiViewCallback(multiViewElementCallback);
        }

        public CloseOperationState canCloseElement() {
            return this.originalElement.canCloseElement();
        }
    }

    private static final class ProjectOpenedHookImpl
    extends ProjectOpenedHook {
        private WeakReference<Project> projectRef;

        public ProjectOpenedHookImpl(Project project) {
            this.projectRef = new WeakReference<Project>(project);
        }

        protected void projectOpened() {
        }

        protected void projectClosed() {
            Project project = (Project)this.projectRef.get();
            if (project != null) {
                AuxiliaryConfiguration auxiliaryConfiguration = (AuxiliaryConfiguration)project.getLookup().lookup(AuxiliaryConfiguration.class);
                HashMap hashMap = (HashMap)multiViewsByProject.get(project);
                HashMap hashMap2 = hashMap = hashMap == null ? new HashMap(1) : hashMap;
                if (auxiliaryConfiguration != null) {
                    Element element = auxiliaryConfiguration.getConfigurationFragment(OpenEditOverride.OPEN_FILES_ELEMENT, OpenEditOverride.OPEN_FILES_NS, false);
                    if (element == null) {
                        return;
                    }
                    NodeList nodeList = element.getElementsByTagName(OpenEditOverride.FILE_ELEMENT);
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        FileObject fileObject;
                        String string = nodeList.item(i).getChildNodes().item(0).getNodeValue();
                        try {
                            fileObject = URLMapper.findFileObject((URL)new URL(string));
                        }
                        catch (MalformedURLException malformedURLException) {
                            assert (false) : "MalformedURLException in " + string;
                            continue;
                        }
                        if (fileObject == null || FileOwnerQuery.getOwner((FileObject)fileObject) != project) continue;
                        try {
                            DataObject dataObject = DataObject.find((FileObject)fileObject);
                            if (!(dataObject instanceof JsfJspDataObject)) continue;
                            FileObject fileObject2 = dataObject.getPrimaryFile();
                            String string2 = (String)hashMap.get(fileObject2);
                            fileObject2.setAttribute(OpenEditOverride.MULTIVIEW_ATTRIBUTE, (Object)string2);
                            continue;
                        }
                        catch (IOException iOException) {
                            assert (false) : "IOException for FileObject: " + fileObject.getPath();
                            continue;
                        }
                    }
                }
                OpenEditOverride.unregisterProject(project);
            }
        }
    }
}

