/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.xml.graph;

import com.tomsawyer.graph.TSEdge;
import com.tomsawyer.graph.TSGraph;
import com.tomsawyer.graph.TSGraphObject;
import com.tomsawyer.graph.TSNode;
import com.tomsawyer.xml.TSTopLevelXMLWriter;
import com.tomsawyer.xml.TSXMLUtilities;
import com.tomsawyer.xml.graph.TSEdgeXMLWriter;
import com.tomsawyer.xml.graph.TSGraphManagerXMLWriter;
import com.tomsawyer.xml.graph.TSNodeXMLWriter;
import com.tomsawyer.xml.graph.fe;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Element;

public class TSGraphXMLWriter
extends TSTopLevelXMLWriter {
    private TSNodeXMLWriter nodeWriter;
    private TSEdgeXMLWriter edgeWriter;
    private TSGraph graph;

    public TSGraphXMLWriter() {
        this.init();
    }

    public TSGraphXMLWriter(Writer writer) {
        super(writer);
        this.init();
    }

    public TSGraphXMLWriter(File file, boolean bl, boolean bl2) throws FileNotFoundException {
        super(file, bl, bl2);
        this.init();
    }

    public TSGraphXMLWriter(File file) throws FileNotFoundException {
        super(file);
        this.init();
    }

    public TSGraphXMLWriter(String string, boolean bl, boolean bl2) throws FileNotFoundException {
        super(string, bl, bl2);
        this.init();
    }

    public TSGraphXMLWriter(String string) throws FileNotFoundException {
        super(string);
        this.init();
    }

    private void init() {
        this.setNodeWriter(this.newNodeXMLWriter());
        this.setEdgeWriter(this.newEdgeXMLWriter());
        this.setTagName("graph");
        this.setUsingTemplates(false);
    }

    protected TSNodeXMLWriter newNodeXMLWriter() {
        return new TSNodeXMLWriter();
    }

    protected TSEdgeXMLWriter newEdgeXMLWriter() {
        return new TSEdgeXMLWriter();
    }

    protected void setObjectToWrite(Object object) {
        if (object instanceof TSGraph) {
            this.graph = (TSGraph)object;
        }
    }

    public TSNodeXMLWriter getNodeWriter() {
        return this.nodeWriter;
    }

    public void setNodeWriter(TSNodeXMLWriter tSNodeXMLWriter) {
        this.nodeWriter = tSNodeXMLWriter;
        this.nodeWriter.setParent(this);
    }

    public TSEdgeXMLWriter getEdgeWriter() {
        TSEdgeXMLWriter tSEdgeXMLWriter = this.edgeWriter;
        if (this.getParent() != null && this.getParent() instanceof TSGraphManagerXMLWriter) {
            tSEdgeXMLWriter = ((TSGraphManagerXMLWriter)this.getParent()).getEdgeWriter();
        }
        return tSEdgeXMLWriter;
    }

    public void setEdgeWriter(TSEdgeXMLWriter tSEdgeXMLWriter) {
        this.edgeWriter = tSEdgeXMLWriter;
        this.edgeWriter.setParent(this);
    }

    public TSGraph getGraph() {
        return this.graph;
    }

    public void setGraph(TSGraph tSGraph) {
        this.graph = tSGraph;
    }

    public void populateDOMElement(Element element) {
        if (!(this.getParent() instanceof TSGraphManagerXMLWriter)) {
            fe.a(this.getID(this.getGraph()), element);
        }
        fe.a((TSGraphObject)this.getGraph(), element, this);
        Element element2 = TSXMLUtilities.createElement("nodes", element);
        this.writeNodes(element2, this.getGraph());
        if (element2.getChildNodes().getLength() == 0) {
            element.removeChild(element2);
        }
        Element element3 = TSXMLUtilities.createElement("edges", element);
        this.writeEdges(element3, this.getGraph(), this.getGraph().edges());
        if (element3.getChildNodes().getLength() == 0) {
            element.removeChild(element3);
        }
    }

    protected void writeNodes(Element element, TSGraph tSGraph) {
        Iterator iterator = tSGraph.nodes().iterator();
        while (iterator.hasNext()) {
            TSNode tSNode = (TSNode)iterator.next();
            Element element2 = TSXMLUtilities.createElement(this.getNodeWriter().getTagName(), element);
            fe.a(this.getID(tSNode), element2);
            if (tSNode.getType() != 0) {
                TSXMLUtilities.writeIntAttribute("type", tSNode.getType(), element2);
            }
            this.getNodeWriter().setNode(tSNode);
            this.getNodeWriter().populateDOMElement(element2);
        }
    }

    protected void writeEdges(Element element, TSGraph tSGraph, List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            TSEdge tSEdge = (TSEdge)iterator.next();
            if (!tSEdge.getSourceNode().isOwned() || !tSEdge.getTargetNode().isOwned()) continue;
            Element element2 = TSXMLUtilities.createElement(this.getEdgeWriter().getTagName(), element);
            fe.a(this.getID(tSEdge), element2);
            TSXMLUtilities.writeStringAttribute("source", this.getID(tSEdge.getSourceNode()), element2);
            TSXMLUtilities.writeStringAttribute("target", this.getID(tSEdge.getTargetNode()), element2);
            if (tSEdge.getType() != 0) {
                TSXMLUtilities.writeIntAttribute("type", tSEdge.getType(), element2);
            }
            this.getEdgeWriter().setEdge(tSEdge);
            this.getEdgeWriter().populateDOMElement(element2);
        }
    }
}

