/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.xml.graph;

import com.tomsawyer.graph.TSEdge;
import com.tomsawyer.graph.TSGraph;
import com.tomsawyer.graph.TSGraphObject;
import com.tomsawyer.graph.TSNode;
import com.tomsawyer.xml.TSTopLevelXMLReader;
import com.tomsawyer.xml.TSXMLUtilities;
import com.tomsawyer.xml.graph.TSEdgeXMLReader;
import com.tomsawyer.xml.graph.TSGraphManagerXMLReader;
import com.tomsawyer.xml.graph.TSNodeXMLReader;
import com.tomsawyer.xml.graph.fe;
import com.tomsawyer.xml.util.TSObjectNotFoundException;
import java.io.File;
import java.io.Reader;
import java.net.URL;
import java.util.Iterator;
import org.w3c.dom.Element;

public class TSGraphXMLReader
extends TSTopLevelXMLReader {
    private TSGraph graph;
    private TSNodeXMLReader nodeReader;
    private TSEdgeXMLReader edgeReader;

    public TSGraphXMLReader() {
        this.init();
    }

    public TSGraphXMLReader(Reader reader) {
        super(reader);
        this.init();
    }

    public TSGraphXMLReader(File file) {
        super(file);
        this.init();
    }

    public TSGraphXMLReader(String string) {
        super(string);
        this.init();
    }

    public TSGraphXMLReader(URL uRL) {
        super(uRL);
        this.init();
    }

    private void init() {
        this.setTagName("graph");
        this.setNodeReader(this.newNodeXMLReader());
        this.setEdgeReader(this.newEdgeXMLReader());
    }

    protected TSEdgeXMLReader newEdgeXMLReader() {
        return new TSEdgeXMLReader();
    }

    protected TSNodeXMLReader newNodeXMLReader() {
        return new TSNodeXMLReader();
    }

    public TSGraph getGraph() {
        return this.graph;
    }

    public void setGraph(TSGraph tSGraph) {
        this.graph = tSGraph;
    }

    public TSNodeXMLReader getNodeReader() {
        return this.nodeReader;
    }

    public void setNodeReader(TSNodeXMLReader tSNodeXMLReader) {
        this.nodeReader = tSNodeXMLReader;
        this.nodeReader.setParent(this);
    }

    public TSEdgeXMLReader getEdgeReader() {
        TSEdgeXMLReader tSEdgeXMLReader = this.edgeReader;
        if (this.getParent() != null && this.getParent() instanceof TSGraphManagerXMLReader) {
            tSEdgeXMLReader = ((TSGraphManagerXMLReader)this.getParent()).getEdgeReader();
        }
        return tSEdgeXMLReader;
    }

    public void setEdgeReader(TSEdgeXMLReader tSEdgeXMLReader) {
        this.edgeReader = tSEdgeXMLReader;
        this.edgeReader.setParent(this);
    }

    protected void setObjectToRead(Object object) {
        if (object instanceof TSGraph) {
            this.setGraph((TSGraph)object);
        }
    }

    public void processDOMElement(Element element) throws TSObjectNotFoundException {
        if (!(this.getParent() instanceof TSGraphManagerXMLReader)) {
            this.setID(fe.c(element), this.getGraph());
        }
        fe.a((TSGraphObject)this.getGraph(), element, this);
        Element element2 = TSXMLUtilities.findElement(element, "nodes");
        this.processNodes(element2);
        Element element3 = TSXMLUtilities.findElement(element, "edges");
        this.processEdges(element3);
    }

    private void processEdges(Element element) {
        if (element != null) {
            Iterator iterator = TSXMLUtilities.getChildrenByName("edge", element).iterator();
            while (iterator.hasNext()) {
                Element element2 = (Element)iterator.next();
                this.processEdge(element2);
            }
        }
    }

    private void processEdge(Element element) {
        String string = fe.c(element);
        TSEdge tSEdge = (TSEdge)this.getObject(string);
        int n = fe.a(element, 0);
        String string2 = TSXMLUtilities.parseStringAttribute("source", element);
        TSNode tSNode = (TSNode)this.getObject(string2);
        if (tSNode == null) {
            throw new TSObjectNotFoundException(string2);
        }
        String string3 = TSXMLUtilities.parseStringAttribute("target", element);
        TSNode tSNode2 = (TSNode)this.getObject(string3);
        if (tSNode2 == null) {
            throw new TSObjectNotFoundException(string3);
        }
        if (tSEdge == null) {
            tSEdge = n == 0 ? this.getGraph().addEdge(tSNode, tSNode2) : this.getGraph().addEdge(n, tSNode, tSNode2);
            this.setID(string, tSEdge);
        }
        this.getEdgeReader().setEdge(tSEdge);
        this.getEdgeReader().processDOMElement(element);
    }

    private void processNodes(Element element) {
        if (element != null) {
            Iterator iterator = TSXMLUtilities.getChildrenByName("node", element).iterator();
            while (iterator.hasNext()) {
                Element element2 = (Element)iterator.next();
                this.processNode(element2);
            }
        }
    }

    private void processNode(Element element) {
        String string = fe.c(element);
        int n = fe.a(element, 0);
        TSNode tSNode = (TSNode)this.getObject(string);
        if (tSNode == null) {
            tSNode = n == 0 ? this.getGraph().addNode() : this.getGraph().addNode(n);
            this.setID(string, tSNode);
        }
        this.getNodeReader().setNode(tSNode);
        this.getNodeReader().processDOMElement(element);
    }
}

