/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.xml.drawing;

import com.tomsawyer.complexity.TSDChildGraphForestEdge;
import com.tomsawyer.complexity.TSHidingManager;
import com.tomsawyer.complexity.TSNestingManager;
import com.tomsawyer.drawing.TSDEdge;
import com.tomsawyer.drawing.TSDGraph;
import com.tomsawyer.drawing.TSDGraphManager;
import com.tomsawyer.drawing.TSDNode;
import com.tomsawyer.drawing.TSEdgeLabel;
import com.tomsawyer.drawing.TSGraphTailor;
import com.tomsawyer.graph.TSGraph;
import com.tomsawyer.graph.TSNode;
import com.tomsawyer.util.TSLicenseRuntimeException;
import com.tomsawyer.util.f2;
import com.tomsawyer.xml.TSXMLUtilities;
import com.tomsawyer.xml.drawing.TSDEdgeXMLReader;
import com.tomsawyer.xml.drawing.TSDGraphXMLReader;
import com.tomsawyer.xml.drawing.fd;
import com.tomsawyer.xml.graph.TSEdgeXMLReader;
import com.tomsawyer.xml.graph.TSGraphManagerXMLReader;
import com.tomsawyer.xml.graph.TSGraphXMLReader;
import com.tomsawyer.xml.graph.fe;
import com.tomsawyer.xml.util.TSObjectNotFoundException;
import java.io.File;
import java.io.Reader;
import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TSDGraphManagerXMLReader
extends TSGraphManagerXMLReader {
    public TSDGraphManagerXMLReader() {
    }

    public TSDGraphManagerXMLReader(Reader reader) {
        super(reader);
    }

    public TSDGraphManagerXMLReader(File file) {
        super(file);
    }

    public TSDGraphManagerXMLReader(String string) {
        super(string);
    }

    public TSDGraphManagerXMLReader(URL uRL) {
        super(uRL);
    }

    protected TSGraphXMLReader newGraphXMLReader() {
        return new TSDGraphXMLReader();
    }

    protected TSEdgeXMLReader newEdgeXMLReader() {
        return new TSDEdgeXMLReader();
    }

    public void processDOMElement(Element element) throws TSObjectNotFoundException {
        if (this.getGraphManager() instanceof TSDGraphManager) {
            Element element2 = TSXMLUtilities.findElement(element, "resources");
            this.processResources(element2);
            super.processDOMElement(element);
            Element element3 = TSXMLUtilities.findElement(element, "instances");
            if (element3 != null) {
                TSDGraph tSDGraph;
                Object object;
                Element element4 = TSXMLUtilities.findElement(element3, "complexity");
                this.processComplexity(element4);
                Element element5 = this.findElement(element3, "rootGraph");
                if (element5 != null) {
                    object = fe.d(element5);
                    tSDGraph = (TSDGraph)this.getObject((String)object);
                    if (tSDGraph == null) {
                        throw new TSObjectNotFoundException((String)object);
                    }
                    ((TSDGraphManager)this.getGraphManager()).setMainDisplayGraph(tSDGraph);
                }
                object = this.getGraphManager().graphs(false).iterator();
                while (object.hasNext()) {
                    tSDGraph = (TSDGraph)object.next();
                    tSDGraph.updateBounds();
                }
            }
        } else {
            super.processDOMElement(element);
        }
    }

    protected void processResources(Element element) {
        if (element != null) {
            Element element2 = TSXMLUtilities.findElement(element, "shapes");
            this.processShapes(element2);
        }
    }

    private void processShapes(Element element) {
        if (element != null) {
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1 || !node.getNodeName().equals("polygonShape") && !node.getNodeName().equals("ovalShape")) continue;
                Element element2 = (Element)node;
                fd.a(element2, this);
            }
        }
    }

    private void processComplexity(Element element) {
        if (element != null) {
            this.processHiddenObjects(element);
            this.processNestingRelations(element);
            this.processMetaEdges(element);
            this.processFolderNodes(element);
            this.processIntergraphEdgeLabels();
        }
    }

    private void processIntergraphEdgeLabels() {
        Iterator iterator = this.getGraphManager().intergraphEdges().iterator();
        while (iterator.hasNext()) {
            TSDEdge tSDEdge = (TSDEdge)iterator.next();
            if (tSDEdge.numberOfLabels() <= 0) continue;
            Iterator iterator2 = tSDEdge.labels().iterator();
            while (iterator2.hasNext()) {
                TSEdgeLabel tSEdgeLabel = (TSEdgeLabel)iterator2.next();
                tSEdgeLabel.setLocalOffset(tSEdgeLabel.getLocalOffset());
            }
        }
    }

    private void processFolderNodes(Element element) {
        Element element2;
        if (this.getGraphManager() instanceof TSDGraphManager && (element2 = TSXMLUtilities.findElement(element, "folders")) != null) {
            Iterator iterator = TSXMLUtilities.getChildrenByName("folder", element2).iterator();
            while (iterator.hasNext()) {
                Element element3 = (Element)iterator.next();
                String string = fe.c(element3);
                TSDNode tSDNode = (TSDNode)this.getObject(string);
                if (tSDNode == null) {
                    throw new TSObjectNotFoundException(string);
                }
                boolean bl = false;
                try {
                    f2.a(f2.bg);
                    bl = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!bl) continue;
                tSDNode.setFolderNode(true);
            }
        }
    }

    private void processHiddenObjects(Element element) {
        Hashtable<TSGraph, LinkedList<Object>> hashtable = new Hashtable<TSGraph, LinkedList<Object>>();
        Hashtable hashtable2 = new Hashtable();
        if (this.getGraphManager() instanceof TSDGraphManager) {
            Object object;
            Object object2;
            Object object3;
            Iterator<Object> iterator;
            Element element2 = TSXMLUtilities.findElement(element, "hiddenObjects");
            if (element2 != null) {
                iterator = TSXMLUtilities.getChildrenByName("hidden", element2).iterator();
                while (iterator.hasNext()) {
                    object3 = (Element)iterator.next();
                    object2 = fe.c((Element)object3);
                    object = this.getObject((String)object2);
                    if (object == null) {
                        throw new TSObjectNotFoundException((String)object2);
                    }
                    TSGraph tSGraph = null;
                    Hashtable<TSGraph, LinkedList<Object>> hashtable3 = null;
                    if (object instanceof TSDNode) {
                        tSGraph = ((TSDNode)object).getOwnerGraph();
                        hashtable3 = hashtable;
                    } else if (object instanceof TSDEdge) {
                        tSGraph = ((TSDEdge)object).getOwnerGraph();
                        hashtable3 = hashtable2;
                    }
                    if (hashtable3 == null || tSGraph == null) continue;
                    LinkedList<Object> linkedList = (LinkedList<Object>)hashtable3.get(tSGraph);
                    if (linkedList == null) {
                        linkedList = new LinkedList<Object>();
                        hashtable3.put(tSGraph, linkedList);
                    }
                    linkedList.add(object);
                }
            }
            iterator = hashtable.keySet().iterator();
            while (iterator.hasNext()) {
                object3 = (TSDGraph)iterator.next();
                object2 = (List)hashtable.get(object3);
                object = (List)hashtable2.get(object3);
                this.hide((TSDGraph)object3, (List)object2, (List)object);
                hashtable2.remove(object3);
            }
            iterator = hashtable2.keySet().iterator();
            while (iterator.hasNext()) {
                object3 = (TSDGraph)iterator.next();
                object2 = (List)hashtable2.get(object3);
                this.hide((TSDGraph)object3, null, (List)object2);
            }
        }
    }

    protected void hide(TSDGraph tSDGraph, List list, List list2) {
        try {
            TSHidingManager.getManager((TSDGraphManager)this.getGraphManager()).hide(tSDGraph, list, list2);
        }
        catch (TSLicenseRuntimeException tSLicenseRuntimeException) {
            // empty catch block
        }
    }

    private void processMetaEdges(Element element) {
        Element element2;
        if (this.getGraphManager() instanceof TSDGraphManager && (element2 = TSXMLUtilities.findElement(element, "metaEdges")) != null) {
            Iterator iterator = TSXMLUtilities.getChildrenByName("metaEdge", element2).iterator();
            while (iterator.hasNext()) {
                Element element3 = (Element)iterator.next();
                String string = fe.c(element3);
                TSDEdge tSDEdge = (TSDEdge)this.getObject(string);
                if (tSDEdge == null) {
                    throw new TSObjectNotFoundException(string);
                }
                tSDEdge.setMetaEdge(true);
            }
        }
    }

    private void processNestingRelations(Element element) {
        Element element2;
        if (this.getGraphManager() instanceof TSDGraphManager && (element2 = TSXMLUtilities.findElement(element, "nestingRelations")) != null) {
            Iterator iterator = TSXMLUtilities.getChildrenByName("nestingRelation", element2).iterator();
            LinkedList<TSDChildGraphForestEdge> linkedList = new LinkedList<TSDChildGraphForestEdge>();
            Hashtable<TSDChildGraphForestEdge, Element> hashtable = new Hashtable<TSDChildGraphForestEdge, Element>();
            while (iterator.hasNext()) {
                Element element3 = (Element)iterator.next();
                String string = TSXMLUtilities.parseStringAttribute("childGraphRelation", element3);
                TSDChildGraphForestEdge tSDChildGraphForestEdge = (TSDChildGraphForestEdge)this.getObject(string);
                if (tSDChildGraphForestEdge == null || !(tSDChildGraphForestEdge.getGraphMember() instanceof TSDNode)) continue;
                linkedList.add(tSDChildGraphForestEdge);
                hashtable.put(tSDChildGraphForestEdge, element3);
            }
            while (linkedList.size() > 0) {
                this.expandNodes(linkedList, hashtable);
            }
        }
    }

    private void expandNodes(List list, Hashtable hashtable) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            TSDChildGraphForestEdge tSDChildGraphForestEdge = (TSDChildGraphForestEdge)iterator.next();
            TSDNode tSDNode = (TSDNode)tSDChildGraphForestEdge.getGraphMember();
            if (tSDNode.getChildGraph() == null || this.hasNodesYetToBeExpanded(tSDNode.getChildGraph(), list)) continue;
            iterator.remove();
            Element element = (Element)hashtable.get(tSDChildGraphForestEdge);
            hashtable.remove(tSDChildGraphForestEdge);
            ((TSDGraph)tSDNode.getChildGraph()).updateBounds();
            Element element2 = this.findElement(element, "expanded");
            boolean bl = element2 != null && fe.f(element2);
            this.processNestingRelation(element, tSDNode);
            this.processNestingMargins(element, tSDNode);
            if (bl) continue;
            this.collapse(tSDNode);
        }
    }

    protected void collapse(TSDNode tSDNode) {
        TSNestingManager.collapse(tSDNode);
    }

    private boolean hasNodesYetToBeExpanded(TSGraph tSGraph, List list) {
        boolean bl = false;
        Iterator iterator = tSGraph.nodes().iterator();
        while (iterator.hasNext()) {
            TSNode tSNode = (TSNode)iterator.next();
            if (!list.contains(tSNode.getChildGraphForestEdge())) continue;
            bl = true;
            break;
        }
        return bl;
    }

    protected void processNestingMargins(Element element, TSDNode tSDNode) {
        Element element2;
        TSDGraph tSDGraph = (TSDGraph)tSDNode.getChildGraph();
        TSGraphTailor tSGraphTailor = tSDGraph.getTailor();
        Element element3 = this.findElement(element, "calculatedMargins");
        if (element3 != null) {
            double d = tSGraphTailor.getOriginalLeftConstantMargin();
            double d2 = tSGraphTailor.getOriginalRightConstantMargin();
            double d3 = tSGraphTailor.getOriginalTopConstantMargin();
            double d4 = tSGraphTailor.getOriginalBottomConstantMargin();
            tSGraphTailor.setLeftConstantMargin(TSXMLUtilities.parseDoubleAttribute("left", element3));
            tSGraphTailor.setRightConstantMargin(TSXMLUtilities.parseDoubleAttribute("right", element3));
            tSGraphTailor.setTopConstantMargin(TSXMLUtilities.parseDoubleAttribute("top", element3));
            tSGraphTailor.setBottomConstantMargin(TSXMLUtilities.parseDoubleAttribute("bottom", element3));
            tSGraphTailor.setOriginalLeftConstantMargin(d);
            tSGraphTailor.setOriginalRightConstantMargin(d2);
            tSGraphTailor.setOriginalTopConstantMargin(d3);
            tSGraphTailor.setOriginalBottomConstantMargin(d4);
        }
        if ((element2 = this.findElement(element, "nestedMargins")) != null) {
            Element element4;
            Element element5 = this.findElement(element2, "proportional");
            if (element5 != null) {
                tSGraphTailor.setLeftNestedViewProportional(TSXMLUtilities.parseDoubleAttribute("left", element5));
                tSGraphTailor.setRightNestedViewProportional(TSXMLUtilities.parseDoubleAttribute("right", element5));
                tSGraphTailor.setTopNestedViewProportional(TSXMLUtilities.parseDoubleAttribute("top", element5));
                tSGraphTailor.setBottomNestedViewProportional(TSXMLUtilities.parseDoubleAttribute("bottom", element5));
            }
            if ((element4 = this.findElement(element2, "constant")) != null) {
                tSGraphTailor.setLeftNestedViewConstant(TSXMLUtilities.parseDoubleAttribute("left", element4));
                tSGraphTailor.setRightNestedViewConstant(TSXMLUtilities.parseDoubleAttribute("right", element4));
                tSGraphTailor.setTopNestedViewConstant(TSXMLUtilities.parseDoubleAttribute("top", element4));
                tSGraphTailor.setBottomNestedViewConstant(TSXMLUtilities.parseDoubleAttribute("bottom", element4));
            }
        }
    }

    protected void processNestingRelation(Element element, TSDNode tSDNode) {
        try {
            TSNestingManager.expand(tSDNode);
        }
        catch (TSLicenseRuntimeException tSLicenseRuntimeException) {
            // empty catch block
        }
    }
}

