/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.xml;

import com.tomsawyer.util.TSSystem;
import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TSXMLUtilities {
    public static boolean verbose = true;
    public static boolean verboseSchema = true;

    public static Element createElement(String string, Element element) {
        TSSystem.tsAssert(element != null);
        TSSystem.tsAssert(string != null, "Creating a tag with null name for element " + element.getTagName());
        Element element2 = element.getOwnerDocument().createElement(string);
        element.appendChild(element2);
        return element2;
    }

    public static CDATASection createCDATASection(String string, Element element) {
        CDATASection cDATASection = element.getOwnerDocument().createCDATASection(string);
        element.appendChild(cDATASection);
        return cDATASection;
    }

    public static void writeLongAttribute(String string, long l, Element element) {
        TSXMLUtilities.writeStringAttribute(string, String.valueOf(l), element);
    }

    public static void writeIntAttribute(String string, int n, Element element) {
        TSXMLUtilities.writeStringAttribute(string, String.valueOf(n), element);
    }

    public static void writeDoubleAttribute(String string, double d, Element element) {
        TSXMLUtilities.writeStringAttribute(string, String.valueOf(d), element);
    }

    public static void writeStringAttribute(String string, String string2, Element element) {
        TSSystem.tsAssert(string != null, "Creating an attribute with null name for element " + element.getTagName());
        TSSystem.tsAssert(string2 != null, "Creating an attribute with null value for element " + element.getTagName());
        element.setAttribute(string, string2);
    }

    public static void writeBooleanAttribute(String string, boolean bl, Element element) {
        TSXMLUtilities.writeStringAttribute(string, String.valueOf(bl), element);
    }

    public static double parseDoubleAttribute(String string, Element element) {
        double d;
        block2: {
            d = 0.0;
            try {
                d = Double.parseDouble(element.getAttribute(string));
            }
            catch (Exception exception) {
                if (!TSXMLUtilities.isVerbose()) break block2;
                System.err.println("Warning: the value of " + string + " attribute in the " + element.getTagName() + " element is invalid, reading as 0.0");
            }
        }
        return d;
    }

    public static int parseIntAttribute(String string, Element element) {
        int n;
        block2: {
            n = 0;
            try {
                n = Integer.parseInt(element.getAttribute(string));
            }
            catch (Exception exception) {
                if (!TSXMLUtilities.isVerbose()) break block2;
                System.err.println("Warning: the value of " + string + " attribute in the " + element.getTagName() + " element is invalid, reading as 0");
            }
        }
        return n;
    }

    public static long parseLongAttribute(String string, Element element) {
        long l;
        block2: {
            l = 0L;
            try {
                l = Long.parseLong(element.getAttribute(string));
            }
            catch (Exception exception) {
                if (!TSXMLUtilities.isVerbose()) break block2;
                System.err.println("Warning: the value of " + string + " attribute in the " + element.getTagName() + " element is invalid, reading as 0");
            }
        }
        return l;
    }

    public static boolean parseBooleanAttribute(String string, Element element) {
        boolean bl;
        block2: {
            bl = false;
            try {
                bl = Boolean.valueOf(element.getAttribute(string));
            }
            catch (Exception exception) {
                if (!TSXMLUtilities.isVerbose()) break block2;
                System.err.println("Warning: the value of " + string + " attribute in the " + element.getTagName() + " element is invalid, reading as false");
            }
        }
        return bl;
    }

    public static String parseStringAttribute(String string, Element element) {
        String string2 = element.getAttribute(string);
        if (string2.equals("")) {
            string2 = null;
        }
        return string2;
    }

    public static Element findElement(Element element, String string) {
        Element element2 = null;
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !node.getNodeName().equals(string)) continue;
            element2 = (Element)node;
            break;
        }
        return element2;
    }

    public static CDATASection findCDATASection(Element element) {
        CDATASection cDATASection = null;
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof CDATASection)) continue;
            cDATASection = (CDATASection)node;
            break;
        }
        return cDATASection;
    }

    public static List getChildrenByName(String string, Element element) {
        LinkedList<Node> linkedList = new LinkedList<Node>();
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element) || !node.getNodeName().equals(string)) continue;
            linkedList.add(node);
        }
        return linkedList;
    }

    public static boolean isVerbose() {
        return verbose;
    }

    public static void setVerbose(boolean bl) {
        verbose = bl;
    }

    public static boolean isVerboseSchemaValidation() {
        return verboseSchema;
    }

    public static void setVerboseSchemaValidation(boolean bl) {
        verboseSchema = bl;
    }
}

