/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.xml;

import com.tomsawyer.xml.TSXMLReader;
import com.tomsawyer.xml.TSXMLUtilities;
import com.tomsawyer.xml.util.TSObjectNotFoundException;
import com.tomsawyer.xml.util.TSObjectTable;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.CharConversionException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.zip.GZIPInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class TSTopLevelXMLReader
extends TSXMLReader
implements ErrorHandler {
    private Reader reader = null;
    File file;
    private URL url;
    private TSObjectTable objectTable;
    private boolean validating;
    private boolean validatingFully = true;
    String schemaLocation;
    boolean strict;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$org$xml$sax$ErrorHandler;
    static /* synthetic */ Class class$org$xml$sax$InputSource;

    public TSTopLevelXMLReader() {
    }

    public TSTopLevelXMLReader(Reader reader) {
        this.reader = reader;
    }

    public TSTopLevelXMLReader(File file) {
        this.file = file;
    }

    public TSTopLevelXMLReader(String string) {
        this.file = new File(string);
    }

    public TSTopLevelXMLReader(URL uRL) {
        this.url = uRL;
    }

    public Reader getReader() {
        return this.reader;
    }

    public void setReader(Reader reader) {
        this.reader = reader;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    public void setFileName(String string) throws FileNotFoundException {
        this.setFile(new File(string));
    }

    public URL getURL() {
        return this.url;
    }

    public void setURL(URL uRL) {
        this.url = uRL;
    }

    public boolean read() throws FileNotFoundException, TSObjectNotFoundException, IOException {
        boolean bl;
        block48: {
            bl = false;
            if (this.getParent() == null) {
                try {
                    DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                    documentBuilderFactory.setIgnoringComments(true);
                    documentBuilderFactory.setIgnoringElementContentWhitespace(true);
                    documentBuilderFactory.setNamespaceAware(true);
                    documentBuilderFactory.setValidating(this.isValidating());
                    DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                    Document document = null;
                    Reader reader = this.getReader();
                    if (reader != null) {
                        try {
                            document = this.parse(documentBuilder, reader);
                        }
                        catch (SAXParseException sAXParseException) {
                        }
                        catch (InvocationTargetException invocationTargetException) {
                        }
                        catch (CharConversionException charConversionException) {
                            // empty catch block
                        }
                    }
                    if (document == null) {
                        if (this.getFile() != null && this.getInputStream().available() == 0) {
                            throw new IOException("Invalid file name");
                        }
                        try {
                            reader = new BufferedReader(new InputStreamReader(this.getInputStream(), "UTF-8"));
                            document = this.parse(documentBuilder, reader);
                        }
                        catch (SAXParseException sAXParseException) {
                        }
                        catch (InvocationTargetException invocationTargetException) {
                        }
                        catch (CharConversionException charConversionException) {
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (document == null) {
                        try {
                            reader = new BufferedReader(new InputStreamReader(this.getInputStream(), "UTF-16"));
                            document = this.parse(documentBuilder, reader);
                        }
                        catch (SAXParseException sAXParseException) {
                        }
                        catch (InvocationTargetException invocationTargetException) {
                        }
                        catch (CharConversionException charConversionException) {
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (document == null) {
                        try {
                            reader = new BufferedReader(new InputStreamReader((InputStream)new BufferedInputStream(new GZIPInputStream(this.getInputStream())), "UTF-8"));
                            document = this.parse(documentBuilder, reader);
                        }
                        catch (SAXParseException sAXParseException) {
                        }
                        catch (InvocationTargetException invocationTargetException) {
                        }
                        catch (CharConversionException charConversionException) {
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (document == null) {
                        try {
                            reader = new BufferedReader(new InputStreamReader((InputStream)new BufferedInputStream(new GZIPInputStream(this.getInputStream())), "UTF-16"));
                            document = this.parse(documentBuilder, reader);
                        }
                        catch (SAXParseException sAXParseException) {
                        }
                        catch (InvocationTargetException invocationTargetException) {
                        }
                        catch (CharConversionException charConversionException) {
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (document != null) {
                        String string;
                        String string2;
                        Element element = document.getDocumentElement();
                        if (this.getTagName() != null) {
                            element = TSXMLUtilities.findElement(element, this.getTagName());
                        }
                        boolean bl2 = false;
                        String string3 = TSXMLUtilities.parseStringAttribute("product", element);
                        if (string3 != null && this.getProductName() != null && string3.compareTo(this.getProductName()) > 0 && TSXMLUtilities.isVerbose()) {
                            System.err.println("Warning: this XML file was saved with different software, some data may be lost");
                            bl2 = true;
                        }
                        if ((string2 = TSXMLUtilities.parseStringAttribute("edition", element)) != null && this.getProductEdition() != null && string2.compareTo(this.getProductEdition()) > 0 && TSXMLUtilities.isVerbose() && !bl2) {
                            System.err.println("Warning: this XML file was saved with different software edition, some data may be lost");
                            bl2 = true;
                        }
                        if ((string = TSXMLUtilities.parseStringAttribute("version", element)) != null && this.getVersion() != null && string.compareTo(this.getVersion()) > 0 && TSXMLUtilities.isVerbose() && !bl2) {
                            System.err.println("Warning: this XML file was saved with newer software, problems are possible during loading");
                            bl2 = true;
                        }
                        if (!this.isStrict() || !bl2) {
                            this.processDOMElement(element);
                            bl = true;
                        }
                    }
                }
                catch (TSObjectNotFoundException tSObjectNotFoundException) {
                    if (TSXMLUtilities.isVerbose()) {
                        tSObjectNotFoundException.printStackTrace();
                    }
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
                catch (ParserConfigurationException parserConfigurationException) {
                }
                catch (SAXException sAXException) {
                }
                catch (FactoryConfigurationError factoryConfigurationError) {
                    if (!TSXMLUtilities.isVerbose()) break block48;
                    System.err.println("Could not locate a factory class");
                }
            }
        }
        return bl;
    }

    private InputStream getInputStream() throws IOException {
        InputStream inputStream = null;
        if (this.getFile() != null) {
            inputStream = new FileInputStream(this.getFile());
        } else if (this.getURL() != null) {
            inputStream = this.getURL().openStream();
        }
        return inputStream;
    }

    private Document parse(DocumentBuilder documentBuilder, Reader reader) throws ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException, SAXException, IOException {
        Document document;
        InputSource inputSource = new InputSource(reader);
        if (this.isValidating() && documentBuilder.getClass().getPackage().getName().indexOf("xerces") != -1) {
            Method method;
            Class<?> clazz = Class.forName("org.apache.xerces.parsers.DOMParser");
            Object obj = clazz.newInstance();
            Method method2 = clazz.getMethod("setFeature", class$java$lang$String == null ? (class$java$lang$String = TSTopLevelXMLReader.class$("java.lang.String")) : class$java$lang$String, Boolean.TYPE);
            method2.invoke(obj, "http://xml.org/sax/features/validation", Boolean.TRUE);
            method2.invoke(obj, "http://apache.org/xml/features/validation/schema", Boolean.TRUE);
            if (this.isValidatingFully()) {
                method2.invoke(obj, "http://apache.org/xml/features/validation/schema-full-checking", Boolean.TRUE);
            }
            if (this.getSchemaLocation() != null) {
                method = clazz.getMethod("setProperty", class$java$lang$String == null ? (class$java$lang$String = TSTopLevelXMLReader.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Object == null ? (class$java$lang$Object = TSTopLevelXMLReader.class$("java.lang.Object")) : class$java$lang$Object);
                method.invoke(obj, "http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation", this.getSchemaLocation());
            }
            method = clazz.getMethod("setErrorHandler", class$org$xml$sax$ErrorHandler == null ? (class$org$xml$sax$ErrorHandler = TSTopLevelXMLReader.class$("org.xml.sax.ErrorHandler")) : class$org$xml$sax$ErrorHandler);
            method.invoke(obj, this);
            Method method3 = clazz.getMethod("parse", class$org$xml$sax$InputSource == null ? (class$org$xml$sax$InputSource = TSTopLevelXMLReader.class$("org.xml.sax.InputSource")) : class$org$xml$sax$InputSource);
            method3.invoke(obj, inputSource);
            Method method4 = clazz.getMethod("getDocument", null);
            document = (Document)method4.invoke(obj, null);
        } else {
            document = documentBuilder.parse(inputSource);
        }
        return document;
    }

    public TSObjectTable getObjectTable() {
        if (this.objectTable == null) {
            this.objectTable = new TSObjectTable();
        }
        return this.objectTable;
    }

    public void setObjectTable(TSObjectTable tSObjectTable) {
        this.objectTable = tSObjectTable;
    }

    public void setID(String string, Object object) {
        if (this.getParent() != null) {
            this.getParent().setID(string, object);
        } else if (string != null && object != null) {
            this.getObjectTable().setID(string, object);
        }
    }

    public Object getObject(String string) {
        Object object = null;
        if (this.getParent() != null) {
            object = this.getParent().getObject(string);
        } else if (string != null) {
            object = this.getObjectTable().getObject(string);
        }
        return object;
    }

    public boolean isValidating() {
        return this.validating;
    }

    public void setValidating(boolean bl) {
        this.validating = bl;
    }

    public boolean isValidatingFully() {
        return this.validatingFully;
    }

    public void setValidatingFully(boolean bl) {
        this.validatingFully = bl;
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        if (TSXMLUtilities.isVerboseSchemaValidation()) {
            System.err.println("Error encountered during validation at line #" + sAXParseException.getLineNumber() + ", column #" + sAXParseException.getColumnNumber() + ": " + sAXParseException.getMessage());
        }
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        if (TSXMLUtilities.isVerboseSchemaValidation()) {
            System.err.println("Fatal error encountered during validation at line #" + sAXParseException.getLineNumber() + ", column #" + sAXParseException.getColumnNumber() + ": " + sAXParseException.getMessage());
        }
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        if (TSXMLUtilities.isVerboseSchemaValidation()) {
            System.err.println("Warning encountered during validationat line #" + sAXParseException.getLineNumber() + ", column #" + sAXParseException.getColumnNumber() + ": " + sAXParseException.getMessage());
        }
    }

    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void setSchemaLocation(String string) {
        this.schemaLocation = string;
    }

    protected abstract void setObjectToRead(Object var1);

    public String getIdentifier() {
        return null;
    }

    protected String getVersion() {
        return null;
    }

    protected String getProductName() {
        return null;
    }

    protected String getProductEdition() {
        return null;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public void setStrict(boolean bl) {
        this.strict = bl;
    }

    public TSObjectTable getTopLevelObjectTable() {
        TSObjectTable tSObjectTable = this.getParent() != null ? ((TSTopLevelXMLReader)this.getParent()).getTopLevelObjectTable() : this.getObjectTable();
        return tSObjectTable;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

