/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.util.command;

import com.tomsawyer.util.command.TSCommand;
import java.util.Vector;

public class TSUndoStack {
    Vector stack = new Vector();
    int undoIndex = -1;
    int undoLimit = 50;
    int defaultUndoLimit = 50;

    public boolean canUndo() {
        return this.undoIndex != 0 && this.stack.size() != 0;
    }

    public boolean canRedo() {
        return this.undoIndex != -1 && this.undoIndex < this.stack.size();
    }

    public void add(TSCommand tSCommand) {
        if (this.undoIndex >= 0) {
            while (this.stack.size() > this.undoIndex) {
                this.removeCommand(this.undoIndex);
            }
        }
        this.stack.addElement(tSCommand);
        while (this.stack.size() > this.undoLimit && this.undoLimit > 0) {
            this.removeCommand(0);
        }
        this.undoIndex = -1;
    }

    public TSCommand undo() {
        if (this.undoIndex == 0 || this.stack.size() == 0) {
            return null;
        }
        this.undoIndex = this.undoIndex == -1 ? this.stack.size() - 1 : --this.undoIndex;
        return (TSCommand)this.stack.elementAt(this.undoIndex);
    }

    public void undoFailed() {
        for (int i = 0; i <= this.undoIndex; ++i) {
            this.removeCommand(0);
        }
        this.undoIndex = 0;
    }

    public TSCommand redo() {
        if (this.undoIndex == -1 || this.undoIndex > this.stack.size() - 1) {
            return null;
        }
        TSCommand tSCommand = (TSCommand)this.stack.elementAt(this.undoIndex);
        ++this.undoIndex;
        return tSCommand;
    }

    public void redoFailed() {
        --this.undoIndex;
        while (this.undoIndex < this.stack.size()) {
            this.removeCommand(this.undoIndex);
        }
        this.undoIndex = -1;
    }

    public void clear() {
        this.undoIndex = -1;
        int n = this.stack.size();
        for (int i = 0; i < n; ++i) {
            this.removeCommand(0);
        }
        System.gc();
    }

    public TSCommand pop() {
        if (this.undoIndex == 0 || this.stack.size() == 0) {
            return null;
        }
        this.undoIndex = this.undoIndex == -1 ? this.stack.size() - 1 : --this.undoIndex;
        TSCommand tSCommand = (TSCommand)this.stack.elementAt(this.undoIndex);
        this.removeCommand(this.undoIndex);
        return tSCommand;
    }

    public void setUndoLimit(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("limit < 0");
        }
        if (n == 0) {
            this.clear();
        } else if (n < this.undoLimit) {
            Vector<TSCommand> vector = new Vector<TSCommand>();
            int n2 = n;
            if (this.undoIndex == -1) {
                if (this.stack.size() < n) {
                    n2 = this.stack.size();
                }
            } else if (this.undoIndex < n) {
                n2 = this.undoIndex;
            }
            for (int i = 0; i < n2; ++i) {
                vector.add(0, this.pop());
            }
            this.undoIndex = -1;
            this.stack = vector;
        }
        this.undoLimit = n;
    }

    public void removeCommand(int n) {
        TSCommand tSCommand = (TSCommand)this.stack.get(n);
        this.stack.removeElementAt(n);
        if (tSCommand.getState() == TSCommand.UNDONE) {
            tSCommand.undoCleanup();
        } else if (tSCommand.getState() == TSCommand.DONE) {
            tSCommand.doCleanup();
        }
        tSCommand.setState(TSCommand.FINALIZED);
    }

    public int getUndoLimit() {
        return this.undoLimit;
    }

    public int getDefaultUndoLimit() {
        return this.defaultUndoLimit;
    }

    public void setDefaultUndoLimit(int n) {
        this.defaultUndoLimit = n;
    }
}

