/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.util;

import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;

public class TSParser {
    private Reader reader;
    private StreamTokenizer tokenizer;
    private int lineNumberOffset = 0;

    protected TSParser() {
    }

    public TSParser(Reader reader) {
        if (reader == null) {
            throw new IllegalArgumentException("null reader");
        }
        this.reader = reader;
        this.createTokenizer();
    }

    protected void createTokenizer() {
        this.tokenizer = new StreamTokenizer(this.reader);
        this.tokenizer.wordChars(33, 126);
        this.tokenizer.whitespaceChars(32, 32);
        this.tokenizer.whitespaceChars(58, 58);
        this.tokenizer.quoteChar(34);
        this.tokenizer.parseNumbers();
        this.tokenizer.slashSlashComments(true);
        this.tokenizer.slashStarComments(true);
    }

    protected IOException newIOException(String string) {
        if (this.tokenizer != null) {
            String string2 = this.tokenizer.ttype == -3 || this.tokenizer.ttype == 34 ? this.tokenizer.sval : String.valueOf(this.tokenizer.nval);
            return new IOException("\"" + string + ", Got " + string2 + " \" at line " + this.getLineNumber());
        }
        return new IOException(string);
    }

    public void parseOpenBracket() throws IOException {
        this.parseInputString("{");
    }

    public void parseComma() throws IOException {
        this.parseInputString(",");
    }

    public void parseCloseBracket() throws IOException {
        this.parseInputString("}");
    }

    public String getString() throws IOException {
        String string = null;
        this.tokenizer.nextToken();
        if (this.tokenizer.ttype != -3 && this.tokenizer.ttype != 34) {
            throw this.newIOException("String Expected");
        }
        string = this.tokenizer.sval;
        return string;
    }

    public int getInt() throws IOException {
        int n = 0;
        this.tokenizer.nextToken();
        if (this.tokenizer.ttype != -2) {
            throw this.newIOException("int Expected");
        }
        n = (int)this.tokenizer.nval;
        return n;
    }

    public boolean getBoolean() throws IOException {
        boolean bl = false;
        this.tokenizer.nextToken();
        if (this.tokenizer.ttype != -3) {
            throw this.newIOException("'true' or 'false' Expected");
        }
        if (this.tokenizer.sval.equals("true")) {
            bl = true;
        } else if (this.tokenizer.sval.equals("false")) {
            bl = false;
        } else {
            throw this.newIOException("'true' or 'false' Expected");
        }
        return bl;
    }

    public double getDouble() throws IOException {
        double d = 0.0;
        this.tokenizer.nextToken();
        if (this.tokenizer.ttype != -2) {
            throw this.newIOException("double Expected");
        }
        d = this.tokenizer.nval;
        int n = this.getExponent();
        if (n != 1) {
            d *= Math.pow(10.0, n);
        }
        return d;
    }

    public int getExponent() throws IOException {
        int n = 1;
        this.tokenizer.nextToken();
        if (this.tokenizer.ttype != -3) {
            this.tokenizer.pushBack();
        } else {
            String string = this.tokenizer.sval;
            if (string.charAt(0) != 'E' && string.charAt(0) != 'e') {
                this.tokenizer.pushBack();
            } else {
                try {
                    n = Integer.parseInt(string.substring(1, string.length()));
                }
                catch (Exception exception) {
                    n = 1;
                    this.tokenizer.pushBack();
                }
            }
        }
        return n;
    }

    public static String toSafeString(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        block5: for (int i = 0; i < string.length(); ++i) {
            switch (string.charAt(i)) {
                case '\n': {
                    stringBuffer.append('\\');
                    stringBuffer.append('n');
                    continue block5;
                }
                case '\r': {
                    stringBuffer.append('\\');
                    stringBuffer.append('r');
                    continue block5;
                }
                case '\\': {
                    stringBuffer.append('\\');
                    stringBuffer.append('\\');
                    continue block5;
                }
                default: {
                    stringBuffer.append(string.charAt(i));
                }
            }
        }
        return stringBuffer.toString();
    }

    public String getText() throws IOException {
        StringBuffer stringBuffer = new StringBuffer(80);
        while (true) {
            char c;
            if ((c = (char)this.reader.read()) == '\n' || c == '\r') {
                ++this.lineNumberOffset;
                break;
            }
            if (c == '\\') {
                c = (char)this.reader.read();
                if (c == 'n') {
                    stringBuffer.append('\n');
                    continue;
                }
                if (c == 'r') {
                    stringBuffer.append('\r');
                    continue;
                }
                if (c == '\\') {
                    stringBuffer.append('\\');
                    continue;
                }
                stringBuffer.append('\\');
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public String getLine() throws IOException {
        StringBuffer stringBuffer = new StringBuffer(80);
        char c = (char)this.reader.read();
        while (c != '\n' && c != '\r') {
            stringBuffer.append(c);
            c = (char)this.reader.read();
        }
        ++this.lineNumberOffset;
        return stringBuffer.toString();
    }

    public void parseInputString(String string) throws IOException {
        if (!this.getString().equals(string)) {
            throw this.newIOException("'" + string + "' Expected");
        }
    }

    public void parseAwayBlock() throws IOException {
        this.parseOpenBracket();
        this.parseAwayOpenBlock();
    }

    public void parseAwayOpenBlock() throws IOException {
        int n = 1;
        this.tokenizer.nextToken();
        while (true) {
            if (this.tokenizer.ttype == -3) {
                if (this.tokenizer.sval.equals("}")) {
                    if (--n == 0) {
                        return;
                    }
                } else if (this.tokenizer.sval.equals("{")) {
                    ++n;
                }
            }
            this.tokenizer.nextToken();
        }
    }

    public void parseAwayChar() throws IOException {
        this.reader.read();
    }

    public void pushBack() throws IOException {
        this.tokenizer.pushBack();
    }

    public Object getInstance() throws IOException {
        Object var1_1 = null;
        String string = this.getString();
        try {
            var1_1 = Class.forName(string).newInstance();
        }
        catch (Exception exception) {
            throw this.newIOException("Unable to Instantiate " + string);
        }
        return var1_1;
    }

    public final Reader getReader() {
        return this.reader;
    }

    public final StreamTokenizer getTokenizer() {
        return this.tokenizer;
    }

    public int getLineNumber() {
        return this.tokenizer.lineno() + this.lineNumberOffset;
    }
}

