/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.graph;

import com.tomsawyer.event.TSChildEventSource;
import com.tomsawyer.graph.TSGraph;
import com.tomsawyer.graph.TSGraphManager;
import com.tomsawyer.graph.TSGraphObjectTable;
import com.tomsawyer.util.TSAttributedObject;
import com.tomsawyer.util.TSObject;
import com.tomsawyer.util.TSParser;
import com.tomsawyer.util.TSSystem;
import java.io.IOException;

public abstract class TSGraphObject
extends TSAttributedObject
implements TSChildEventSource {
    static final int MODIFIED = 1;
    static final int OWNED = 2;
    static final int VISIBLE = 4;
    static final int DISCARDED = 8;
    private static long idSeed = 1L;
    private boolean marked;
    private static boolean storeCloneInUtilityObject;
    private long id = idSeed++;
    Object utilityObject;
    Object userObject;
    Object tag;
    TSGraphObject owner;
    protected int flags;

    protected TSGraphObject() {
        this.initGraphObject();
    }

    protected void initGraphObject() {
        this.tag = null;
        this.userObject = null;
        this.owner = null;
        this.utilityObject = null;
        this.flags = 4;
    }

    public Object getParentEventSource() {
        return this.getOwner();
    }

    public Object clone() {
        return this.clone(false);
    }

    public Object clone(boolean bl) {
        TSGraphObject tSGraphObject = (TSGraphObject)super.clone();
        tSGraphObject.id = idSeed++;
        tSGraphObject.initGraphObject();
        if (!(bl || this instanceof TSGraph || this instanceof TSGraphManager)) {
            tSGraphObject.copy(this, true);
        }
        if (TSGraphObject.isStoreCloneInUtilityObject()) {
            this.setUtilityObject(tSGraphObject);
        }
        return tSGraphObject;
    }

    public void copy(Object object, boolean bl) {
        if (object == null) {
            throw new IllegalArgumentException("null sourceObject");
        }
        if (!object.getClass().isInstance(this) && bl) {
            throw new IllegalArgumentException("copy source & destination must be of same type");
        }
        super.copy(object, bl);
        TSGraphObject tSGraphObject = (TSGraphObject)object;
        TSSystem.tsAssert(!tSGraphObject.isDiscarded());
        this.tag = tSGraphObject.getTag() instanceof TSObject ? ((TSObject)tSGraphObject.getTag()).clone() : tSGraphObject.tag;
        this.setVisible(tSGraphObject.isVisible());
        this.userObject = tSGraphObject.userObject;
    }

    public void emptyTopology() {
    }

    public long getID() {
        return this.id;
    }

    public TSGraphObject getOwner() {
        return this.owner;
    }

    public Object getTag() {
        return this.tag;
    }

    public String getTagString() {
        Object object = this.getTag();
        String string = "";
        if (object != null && object instanceof String) {
            string = object.toString();
        }
        return string;
    }

    public String getText() {
        String string = this.getTag() == null ? null : this.getTag().toString();
        return string;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public boolean isDiscarded() {
        return (this.flags & 8) != 0;
    }

    boolean isModified() {
        return (this.flags & 1) != 0;
    }

    public boolean isOwned() {
        return (this.flags & 2) != 0;
    }

    public boolean isMarked() {
        return this.marked;
    }

    public boolean isVisible() {
        return (this.flags & 4) != 0;
    }

    public boolean isViewable() {
        return false;
    }

    public void setTag(Object object) {
        if (this.tag == null) {
            if (object != null) {
                this.tag = object;
            }
        } else if (!this.tag.equals(object)) {
            this.tag = object;
        }
    }

    public void setUserObject(Object object) {
        this.userObject = object;
    }

    void setDiscarded(boolean bl) {
        this.flags = bl ? (this.flags |= 8) : (this.flags &= 0xFFFFFFF7);
    }

    void setModified(boolean bl) {
        this.flags = bl ? (this.flags |= 1) : (this.flags &= 0xFFFFFFFE);
    }

    public void setOwned(boolean bl) {
        this.flags = bl ? (this.flags |= 2) : (this.flags &= 0xFFFFFFFD);
    }

    public void setMarked(boolean bl) {
        this.marked = bl;
    }

    public void setVisible(boolean bl) {
        this.flags = bl ? (this.flags |= 4) : (this.flags &= 0xFFFFFFFB);
    }

    protected void onInsert(TSGraphObject tSGraphObject) {
        this.setOwner(tSGraphObject);
        this.setOwned(true);
    }

    protected void onRemove(TSGraphObject tSGraphObject) {
        this.setOwned(false);
    }

    protected void onDiscard(TSGraphObject tSGraphObject) {
        this.emptyTopology();
        this.setDiscarded(true);
    }

    public static final boolean isStoreCloneInUtilityObject() {
        return storeCloneInUtilityObject;
    }

    public static final void setStoreCloneInUtilityObject(boolean bl) {
        storeCloneInUtilityObject = bl;
    }

    public Object getUtilityObject() {
        return this.utilityObject;
    }

    public void setUtilityObject(Object object) {
        this.utilityObject = object;
    }

    public void nullifyUtilityObject() {
        this.setUtilityObject(null);
    }

    public void setAllMarked(boolean bl) {
        this.setMarked(bl);
    }

    public void setOwner(TSGraphObject tSGraphObject) throws IllegalStateException {
        if (this.isOwned() && tSGraphObject != this.owner) {
            throw new IllegalStateException();
        }
        this.owner = tSGraphObject;
    }

    protected String getAttributeString() {
        return "\towned = " + this.isOwned() + TSSystem.eol + "\tdiscarded = " + this.isDiscarded() + TSSystem.eol + "\ttag = " + this.getTag() + TSSystem.eol + "\tid = " + this.getID() + TSSystem.eol;
    }

    protected void finalize() {
        this.setDiscarded(true);
    }

    public void nullifyUserObject() {
        this.setUserObject(null);
    }

    public boolean userObjectInUse() {
        return this.getUserObject() != null;
    }

    public boolean utilityObjectInUse() {
        return this.getUtilityObject() != null;
    }

    public int levelNumber() {
        return 0;
    }

    public TSGraph getOwnerGraph() {
        return (TSGraph)this.owner;
    }

    public TSGraphManager getOwnerGraphManager() {
        if (this.getOwnerGraph() != null) {
            return this.getOwnerGraph().getOwnerGraphManager();
        }
        return null;
    }

    public void checkInvariants() {
    }

    public void internalRead(TSGraphObjectTable tSGraphObjectTable, TSParser tSParser) throws IOException {
        this.read(tSGraphObjectTable, tSParser);
    }

    protected void read(TSGraphObjectTable tSGraphObjectTable, TSParser tSParser) throws IOException {
    }
}

