/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.graph;

import com.tomsawyer.graph.TSGraph;
import com.tomsawyer.graph.TSGraphManager;
import com.tomsawyer.graph.TSGraphMember;
import com.tomsawyer.graph.TSGraphObject;
import com.tomsawyer.graph.TSGraphObjectTable;
import com.tomsawyer.graph.TSNode;
import com.tomsawyer.graph.event.TSGraphChangeEvent;
import com.tomsawyer.graph.event.TSGraphChangeEventData;
import com.tomsawyer.util.TSSystem;
import com.tomsawyer.util.f0;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class TSEdge
extends TSGraphMember {
    static final int INTERGRAPH_EDGE = 16;
    TSNode sourceNode;
    TSNode targetNode;
    boolean traversed;
    boolean connected;
    f0 listLocation;
    public static final int TYPE = 0;

    protected TSEdge() {
    }

    protected void initGraphObject() {
        super.initGraphObject();
        this.sourceNode = null;
        this.targetNode = null;
        this.connected = false;
        this.traversed = false;
        this.listLocation = null;
    }

    public void copy(Object object, boolean bl) {
        super.copy(object, bl);
        TSEdge tSEdge = (TSEdge)object;
        TSNode tSNode = tSEdge.getSourceNode();
        TSNode tSNode2 = tSEdge.getTargetNode();
        TSNode tSNode3 = (TSNode)tSNode.getUtilityObject();
        TSNode tSNode4 = (TSNode)tSNode2.getUtilityObject();
        if (tSNode3 == null) {
            this.setSourceNode(tSNode);
        } else {
            this.setSourceNode(tSNode3);
        }
        if (tSNode4 == null) {
            this.setTargetNode(tSNode2);
        } else {
            this.setTargetNode(tSNode4);
        }
        this.traversed = ((TSEdge)object).traversed;
    }

    protected void createMapping(Map map, Map map2) {
        if (this.getUtilityObject() instanceof TSEdge) {
            TSEdge tSEdge = (TSEdge)this.getUtilityObject();
            TSGraph.map(this, tSEdge, map, map2);
        }
    }

    public boolean isMetaEdge() {
        return false;
    }

    protected void connect() {
        if (!this.isConnected()) {
            if (((TSGraph)this.owner).isIntergraph()) {
                this.setIntergraphEdge(true);
            } else {
                this.setIntergraphEdge(false);
            }
            if (this.isAttachableTo(this.owner)) {
                if (this.isOwned()) {
                    TSGraph tSGraph = (TSGraph)this.getOwner();
                    tSGraph.onEdgeBecomesConnected(this);
                }
                if (this.sourceNode != null) {
                    this.sourceNode.onEdgeBecomesConnected(this);
                }
                if (this.targetNode != null && this.sourceNode != this.targetNode) {
                    this.targetNode.onEdgeBecomesConnected(this);
                }
                this.setConnected(true);
            }
            if (this.isOwned()) {
                this.getOwnerGraph().fireEvent(new TSGraphChangeEvent(4L, new TSGraphChangeEventData(this, null, this.getOwnerGraph())));
            }
        }
    }

    public void disconnect() {
        if (this.isConnected()) {
            TSGraph tSGraph = null;
            if (this.isOwned()) {
                tSGraph = (TSGraph)this.getOwner();
                tSGraph.onEdgeBecomesDisconnected(this);
            }
            if (this.sourceNode != null) {
                this.sourceNode.onEdgeBecomesDisconnected(this);
            }
            if (this.targetNode != null && this.sourceNode != this.targetNode) {
                this.targetNode.onEdgeBecomesDisconnected(this);
            }
            this.setConnected(false);
            if (tSGraph != null) {
                tSGraph.fireEvent(new TSGraphChangeEvent(32L, new TSGraphChangeEventData(this, tSGraph, null)));
            }
        } else if (this.isIntergraphEdge()) {
            TSGraph tSGraph = this.getOwnerGraph();
            tSGraph.fireEvent(new TSGraphChangeEvent(32L, new TSGraphChangeEventData(this, tSGraph, null)));
        }
    }

    public TSNode getSourceNode() {
        return this.sourceNode;
    }

    public TSNode getTargetNode() {
        return this.targetNode;
    }

    public boolean isValid() {
        TSNode tSNode = this.getSourceNode();
        TSNode tSNode2 = this.getTargetNode();
        return tSNode != null && tSNode2 != null && tSNode.isOwned() && tSNode2.isOwned();
    }

    protected boolean isAttachableTo(TSGraphObject tSGraphObject) {
        return tSGraphObject != null && this.sourceNode != null && this.targetNode != null && this.sourceNode.isOwned() && this.targetNode.isOwned() && this.sourceNode.owner == tSGraphObject && this.targetNode.owner == tSGraphObject && this.isOwned() && this.owner == tSGraphObject;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void setConnected(boolean bl) {
        this.connected = bl;
    }

    public boolean isTraversed() {
        return this.traversed;
    }

    public void setTraversed(boolean bl) {
        this.traversed = bl;
    }

    public void onInsert(TSGraphObject tSGraphObject) {
        TSGraph tSGraph;
        TSGraphManager tSGraphManager;
        TSSystem.tsAssert(tSGraphObject != null);
        TSSystem.tsAssert(!this.isConnected());
        super.onInsert(tSGraphObject);
        if (tSGraphObject instanceof TSGraph && (tSGraphManager = (tSGraph = (TSGraph)tSGraphObject).getOwnerGraphManager()) != null) {
            Vector<TSGraph> vector = new Vector<TSGraph>();
            TSGraph tSGraph2 = this.getChildGraph();
            if (tSGraph2 != null) {
                tSGraph2.buildAllChildGraphList(vector);
                vector.add(tSGraph2);
            }
            Iterator iterator = vector.iterator();
            List list = tSGraphManager.graphs(true);
            while (iterator.hasNext()) {
                TSGraph tSGraph3 = (TSGraph)iterator.next();
                if (list.contains(tSGraph3)) continue;
                if (tSGraph3.getOwner() != null) {
                    TSGraphManager tSGraphManager2 = (TSGraphManager)tSGraph3.getOwner();
                    tSGraphManager2.remove(tSGraph3);
                }
                tSGraphManager.insert(tSGraph3);
            }
        }
        this.connect();
    }

    public void onRemove(TSGraphObject tSGraphObject) {
        TSSystem.tsAssert(tSGraphObject != null);
        TSSystem.tsAssert(tSGraphObject == this.getOwner());
        this.disconnect();
        super.onRemove(tSGraphObject);
    }

    public void onDiscard(TSGraphObject tSGraphObject) {
        TSSystem.tsAssert(tSGraphObject != null);
        TSSystem.tsAssert(tSGraphObject == this.getOwner());
        if (tSGraphObject instanceof TSGraph) {
            TSGraphManager tSGraphManager = tSGraphObject.getOwnerGraphManager();
            if (tSGraphManager != null) {
                boolean bl = tSGraphManager.getEventManager().isFiringEvents();
                tSGraphManager.getEventManager().setFireEvents(false);
                this.setSourceNode(null);
                this.setTargetNode(null);
                tSGraphManager.getEventManager().setFireEvents(bl);
                ((TSGraph)tSGraphObject).fireEvent(new TSGraphChangeEvent(256L, new TSGraphChangeEventData(this, tSGraphObject, null)));
            }
        } else {
            this.setSourceNode(null);
            this.setTargetNode(null);
        }
        super.onDiscard(tSGraphObject);
    }

    public void setSourceNode(TSNode tSNode) {
        if (this.sourceNode != tSNode) {
            TSNode tSNode2 = this.sourceNode;
            if (this.sourceNode != null) {
                this.sourceNode.onDetachOutgoingEdge(this);
            }
            this.sourceNode = tSNode;
            if (this.sourceNode != null) {
                this.sourceNode.onAttachOutgoingEdge(this);
            }
            if (this.isConnected()) {
                if (this.isOwned() && this.isAttachableTo(this.getOwner())) {
                    this.connect();
                } else {
                    this.disconnect();
                }
            }
            this.fireEndNodeChangedEvent(tSNode2, this.sourceNode);
        }
    }

    public void setTargetNode(TSNode tSNode) {
        if (this.targetNode != tSNode) {
            TSNode tSNode2 = this.targetNode;
            if (this.targetNode != null) {
                this.targetNode.onDetachIncomingEdge(this);
            }
            this.targetNode = tSNode;
            if (this.targetNode != null) {
                this.targetNode.onAttachIncomingEdge(this);
            }
            if (this.isConnected()) {
                if (this.isOwned() && this.isAttachableTo(this.getOwner())) {
                    this.connect();
                } else {
                    this.disconnect();
                }
            }
            this.fireEndNodeChangedEvent(tSNode2, this.targetNode);
        }
    }

    public void fireEndNodeChangedEvent(Object object, Object object2) {
        if (this.getOwnerGraphManager() == null) {
            return;
        }
        TSGraphMember tSGraphMember = this.sourceNode;
        if (tSGraphMember == null) {
            tSGraphMember = this.targetNode;
        }
        if (tSGraphMember == null) {
            tSGraphMember = this;
        }
        if (tSGraphMember != null && tSGraphMember.getOwner() instanceof TSGraph) {
            ((TSGraph)tSGraphMember.getOwner()).fireEvent(new TSGraphChangeEvent(4096L, new TSGraphChangeEventData(this, object, object2)));
        }
    }

    public boolean isPathEdge() {
        return false;
    }

    protected void finalize() {
        if (!this.isOwned()) {
            this.setSourceNode(null);
            this.setTargetNode(null);
        }
        super.finalize();
    }

    public void dispose() {
        if (this.isOwned()) {
            ((TSGraph)this.getOwner()).discard(this);
        } else if (!this.isDiscarded()) {
            this.onDiscard(this.getOwner());
        }
    }

    protected String getAttributeString() {
        return super.getAttributeString() + "\tsource = " + this.sourceNode.getID() + TSSystem.eol + "\ttarget = " + this.targetNode.getID();
    }

    void setEdgeListLocation(f0 f02) {
        this.listLocation = f02;
    }

    f0 getEdgeListLocation() {
        return this.listLocation;
    }

    public long assignIDs(TSGraphObjectTable tSGraphObjectTable, long l) {
        if (l >= 0L) {
            tSGraphObjectTable.put(l++, this);
        } else {
            tSGraphObjectTable.put(this.getID(), this);
        }
        return l;
    }

    public int getType() {
        return 0;
    }

    protected boolean canConnect(TSNode tSNode) {
        return true;
    }

    protected boolean canEnd(TSNode tSNode) {
        return false;
    }

    public boolean isIntergraphEdge() {
        return (this.flags & 0x10) != 0;
    }

    public void setIntergraphEdge(boolean bl) {
        this.flags = bl ? (this.flags |= 0x10) : (this.flags &= 0xFFFFFFEF);
    }

    void duplicateTopology(TSEdge tSEdge) {
    }

    public TSGraph getOwnerGraph() {
        if (this.owner == null) {
            return null;
        }
        if (this.owner instanceof TSEdge) {
            return (TSGraph)this.owner.getOwner();
        }
        return (TSGraph)this.owner;
    }

    public void setTag(Object object) {
        Object object2 = this.getTag();
        super.setTag(object);
        if (!TSSystem.equals(object2, object) && this.getOwnerGraph() != null) {
            this.getOwnerGraph().fireEvent(new TSGraphChangeEvent(2048L, new TSGraphChangeEventData(this, object2, this.getTag())));
        }
    }

    public void setChildGraph(TSGraph tSGraph) {
        TSGraph tSGraph2 = this.getChildGraph();
        super.setChildGraph(tSGraph);
        if (this.getOwner() instanceof TSGraph) {
            long l = 16384L;
            if (this.getChildGraph() == null) {
                l = 65536L;
            }
            if (this.getOwnerGraph() != null && tSGraph2 != this.getChildGraph()) {
                this.getOwnerGraph().fireEvent(new TSGraphChangeEvent(l, new TSGraphChangeEventData(this, tSGraph2, this.getChildGraph())));
            }
        }
    }
}

