/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editorx.ui;

import com.tomsawyer.editor.TSEColor;
import com.tomsawyer.editor.TSEFont;
import com.tomsawyer.editor.TSENode;
import com.tomsawyer.editor.TSEObjectUI;
import com.tomsawyer.editor.TSEResourceBundleWrapper;
import com.tomsawyer.editor.TSESolidObject;
import com.tomsawyer.editor.graphics.TSEGraphics;
import com.tomsawyer.editor.inspector.TSEInspectorProperty;
import com.tomsawyer.editor.inspector.TSEInspectorPropertyID;
import com.tomsawyer.editor.inspector.TSENumericInspectorProperty;
import com.tomsawyer.editor.ui.TSENodeUI;
import com.tomsawyer.util.TSProperty;
import java.util.List;

public class TSETextNodeUI
extends TSENodeUI {
    public static TSEInspectorPropertyID MARGIN_WIDTH_ID = new TSEInspectorPropertyID(TSEResourceBundleWrapper.getSystemLabelBundle().getStringSafely("Margin_Width"), class$java$lang$Double == null ? (class$java$lang$Double = TSETextNodeUI.class$("java.lang.Double")) : class$java$lang$Double);
    public static TSEInspectorPropertyID MARGIN_HEIGHT_ID = new TSEInspectorPropertyID(TSEResourceBundleWrapper.getSystemLabelBundle().getStringSafely("Margin_Height"), class$java$lang$Double == null ? (class$java$lang$Double = TSETextNodeUI.class$("java.lang.Double")) : class$java$lang$Double);
    public static final String MARGIN_WIDTH = "marginWidth";
    public static final String MARGIN_HEIGHT = "marginHeight";
    double marginWidth;
    double marginHeight;
    static /* synthetic */ Class class$java$lang$Double;

    public void reset() {
        super.reset();
        this.setMarginWidth(this.getDefaultMarginWidth());
        this.setMarginHeight(this.getDefaultMarginHeight());
    }

    public void copy(TSEObjectUI tSEObjectUI) {
        super.copy(tSEObjectUI);
        TSETextNodeUI tSETextNodeUI = (TSETextNodeUI)tSEObjectUI;
        this.setMarginWidth(tSETextNodeUI.getMarginWidth());
        this.setMarginHeight(tSETextNodeUI.getMarginHeight());
    }

    public void draw(TSEGraphics tSEGraphics) {
        TSENode tSENode = this.getOwnerNode();
        if (!this.isTransparent()) {
            tSEGraphics.setColor(this.getFillColor());
            tSEGraphics.fillRect(tSENode.getLocalBounds());
        }
        if (this.isBorderDrawn()) {
            tSEGraphics.setColor(this.getBorderColor().getColor());
            tSEGraphics.drawRect(tSENode.getLocalBounds());
        }
        this.drawText(tSEGraphics);
        if (this.getOwnerNode().hasChildGraph()) {
            this.drawChildGraphMark(tSEGraphics);
        }
        if (this.hasHideMark()) {
            this.drawHideMark(tSEGraphics);
        }
        this.drawConstraintBadge(tSEGraphics);
    }

    public double getMarginWidth() {
        return this.marginWidth;
    }

    public void setMarginWidth(double d) {
        Double d2 = new Double(this.marginWidth);
        this.marginWidth = d;
        if (this.getOwner() instanceof TSESolidObject) {
            ((TSESolidObject)this.getOwner()).resize();
        }
        this.firePropertyChangedEvent(MARGIN_WIDTH, d2, new Double(d));
    }

    public double getMarginHeight() {
        return this.marginHeight;
    }

    public void setMarginHeight(double d) {
        Double d2 = new Double(this.marginHeight);
        this.marginHeight = d;
        if (this.getOwner() instanceof TSESolidObject) {
            ((TSESolidObject)this.getOwner()).resize();
        }
        this.firePropertyChangedEvent(MARGIN_HEIGHT, d2, new Double(d));
    }

    public List getProperties() {
        List list = super.getProperties();
        list.add(new TSProperty(MARGIN_WIDTH, new Double(this.getMarginWidth())));
        list.add(new TSProperty(MARGIN_HEIGHT, new Double(this.getMarginHeight())));
        return list;
    }

    public List getChangedProperties() {
        List list = super.getChangedProperties();
        if (this.getDefaultMarginWidth() != this.getMarginWidth()) {
            list.add(new TSProperty(MARGIN_WIDTH, new Double(this.getMarginWidth())));
        }
        if (this.getDefaultMarginHeight() != this.getMarginHeight()) {
            list.add(new TSProperty(MARGIN_HEIGHT, new Double(this.getMarginHeight())));
        }
        return list;
    }

    public void setProperty(TSProperty tSProperty) {
        if (MARGIN_WIDTH.equals(tSProperty.getName())) {
            this.setMarginWidth(Double.valueOf(tSProperty.getValue().toString()));
        } else if (MARGIN_HEIGHT.equals(tSProperty.getName())) {
            this.setMarginHeight(Double.valueOf(tSProperty.getValue().toString()));
        } else {
            super.setProperty(tSProperty);
        }
    }

    public void setOwner(TSENode tSENode) {
        super.setOwner(tSENode);
        if (tSENode != null && (tSENode.getResizability() & 0x1000000) == 0) {
            tSENode.setResizability(this.getDefaultResizability());
        }
    }

    public TSEColor getDefaultFillColor() {
        return TSEColor.white;
    }

    public double getDefaultMarginWidth() {
        return super.getMarginWidth();
    }

    public double getDefaultMarginHeight() {
        return super.getMarginHeight();
    }

    public String getDefaultText() {
        return TSEResourceBundleWrapper.getSystemLabelBundle().getStringSafely("Untitled");
    }

    public TSEFont getDefaultFont() {
        return TSEFont.SANS_SERIF_12;
    }

    public void getInspectorPropertyIDs(List list) {
        list.add(MARGIN_WIDTH_ID);
        list.add(MARGIN_HEIGHT_ID);
        super.getInspectorPropertyIDs(list);
    }

    public TSEInspectorProperty getInspectorProperty(TSEInspectorPropertyID tSEInspectorPropertyID) {
        if (tSEInspectorPropertyID.equals(MARGIN_WIDTH_ID)) {
            return new TSENumericInspectorProperty((Number)new Double(this.getMarginWidth()), new Double(0.0), new Double(999.0));
        }
        if (tSEInspectorPropertyID.equals(MARGIN_HEIGHT_ID)) {
            return new TSENumericInspectorProperty((Number)new Double(this.getMarginHeight()), new Double(0.0), new Double(999.0));
        }
        return super.getInspectorProperty(tSEInspectorPropertyID);
    }

    public int setInspectorProperty(TSEInspectorPropertyID tSEInspectorPropertyID, TSEInspectorProperty tSEInspectorProperty) {
        if (tSEInspectorPropertyID.equals(MARGIN_WIDTH_ID)) {
            this.setMarginWidth(((Double)tSEInspectorProperty.getValue()).intValue());
            return 1;
        }
        if (tSEInspectorPropertyID.equals(MARGIN_HEIGHT_ID)) {
            this.setMarginHeight(((Double)tSEInspectorProperty.getValue()).intValue());
            return 1;
        }
        return super.setInspectorProperty(tSEInspectorPropertyID, tSEInspectorProperty);
    }

    public int getDefaultResizability() {
        return 3;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

