/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editorx.ui;

import com.tomsawyer.editor.TSEObjectUI;
import com.tomsawyer.editor.TSEResourceBundleWrapper;
import com.tomsawyer.editor.TSTransform;
import com.tomsawyer.editor.graphics.TSEGraphics;
import com.tomsawyer.editor.inspector.TSEInspectorProperty;
import com.tomsawyer.editor.inspector.TSEInspectorPropertyID;
import com.tomsawyer.editor.inspector.TSEKeyValueInspectorProperty;
import com.tomsawyer.editor.inspector.TSEKeyValueInspectorPropertyEditor;
import com.tomsawyer.editor.inspector.TSEKeyValueInspectorPropertyRenderer;
import com.tomsawyer.editor.ui.TSEDefaultEdgeUI;
import com.tomsawyer.editorx.ui.h5;
import com.tomsawyer.editorx.ui.h6;
import com.tomsawyer.util.TSProperty;
import java.awt.BasicStroke;
import java.awt.Polygon;
import java.awt.Stroke;
import java.util.List;

public class TSEDashedEdgeUI
extends TSEDefaultEdgeUI {
    public static TSEInspectorPropertyID WIDTH_ID = new TSEInspectorPropertyID(TSEResourceBundleWrapper.getSystemLabelBundle().getStringSafely("Width"), class$java$lang$Integer == null ? (class$java$lang$Integer = TSEDashedEdgeUI.class$("java.lang.Integer")) : class$java$lang$Integer);
    public static TSEInspectorPropertyID STYLE_ID = new TSEInspectorPropertyID(TSEResourceBundleWrapper.getSystemLabelBundle().getStringSafely("Style"), class$java$lang$Integer == null ? (class$java$lang$Integer = TSEDashedEdgeUI.class$("java.lang.Integer")) : class$java$lang$Integer);
    static TSEKeyValueInspectorPropertyEditor widthEditor = null;
    static TSEKeyValueInspectorPropertyRenderer widthRenderer = null;
    static TSEKeyValueInspectorPropertyEditor styleEditor = null;
    static TSEKeyValueInspectorPropertyRenderer styleRenderer = null;
    public static final String LINE_STYLE = "style";
    public static final String LINE_WIDTH = "width";
    public static final int[] LINE_WIDTHS = new int[]{1, 2, 3, 4, 5};
    public static final float[][] LINE_STYLES = new float[][]{null, {18.0f, 6.0f}, {6.0f, 6.0f}, {3.0f, 3.0f}, {9.0f, 6.0f, 3.0f, 6.0f}, {9.0f, 3.0f, 3.0f, 3.0f, 3.0f, 3.0f}};
    public static final int LINE_STYLE_SOLID = 0;
    public static final int LINE_STYLE_LONG_DASH = 1;
    public static final int LINE_STYLE_SHORT_DASH = 2;
    public static final int LINE_STYLE_DOT = 3;
    public static final int LINE_STYLE_DASH_DOT = 4;
    public static final int LINE_STYLE_DASH_DOT_DOT = 5;
    int lineWidth;
    float dashPhase;
    int lineStyle;
    float[] zoomedArray;
    static /* synthetic */ Class class$java$lang$Integer;

    public void reset() {
        super.reset();
        this.setLineWidth(this.getDefaultLineWidth());
        this.setLineStyle(this.getDefaultLineStyle());
    }

    public void copy(TSEObjectUI tSEObjectUI) {
        super.copy(tSEObjectUI);
        TSEDashedEdgeUI tSEDashedEdgeUI = (TSEDashedEdgeUI)tSEObjectUI;
        this.setLineWidth(tSEDashedEdgeUI.getLineWidth());
        this.setLineStyle(tSEDashedEdgeUI.getLineStyle());
    }

    public TSEGraphics convertGraphics(TSEGraphics tSEGraphics) {
        TSTransform tSTransform = tSEGraphics.getTSTransform();
        int n = Math.max(1, tSTransform.widthToDevice(this.getLineWidth()));
        BasicStroke basicStroke = null;
        int n2 = this.getLineStyle();
        if (n2 < 0 || n2 >= LINE_STYLES.length || LINE_STYLES[n2] == null) {
            basicStroke = new BasicStroke(n, 1, 1);
        } else {
            if (this.zoomedArray == null || this.zoomedArray.length != LINE_STYLES[n2].length) {
                this.zoomedArray = new float[LINE_STYLES[n2].length];
            }
            float f = 0.0f;
            for (int i = 0; i < LINE_STYLES[n2].length; ++i) {
                this.zoomedArray[i] = (float)Math.max(0.1, (double)tSTransform.widthToDevice(LINE_STYLES[n2][i]));
                f += this.zoomedArray[i];
            }
            basicStroke = new BasicStroke(n, 1, 1, 0.0f, this.zoomedArray, f * this.getDashPhase());
        }
        tSEGraphics.setStroke(basicStroke);
        return tSEGraphics;
    }

    public void drawPath(TSEGraphics tSEGraphics) {
        Stroke stroke = tSEGraphics.getStroke();
        super.drawPath(this.convertGraphics(tSEGraphics));
        tSEGraphics.setStroke(stroke);
    }

    public void drawLineWithArrow(TSEGraphics tSEGraphics, double d, double d2, double d3, double d4, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        float f;
        TSTransform tSTransform = tSEGraphics.getTSTransform();
        float f10 = tSTransform.widthToDevice(d3 - d);
        float f11 = (float)Math.sqrt(f10 * f10 + (f = (float)tSTransform.heightToDevice(d4 - d2)) * f);
        if (f11 == 0.0f) {
            return;
        }
        int n = tSTransform.xToDevice(d);
        int n2 = tSTransform.yToDevice(d2);
        int n3 = tSTransform.xToDevice(d3);
        int n4 = tSTransform.yToDevice(d4);
        float f12 = tSTransform.widthToDevice(this.getArrowWidth() + (double)this.getLineWidth()) / 2;
        if (f12 < 0.5f) {
            tSEGraphics.drawLine(n, n2, n3, n4);
            return;
        }
        float f13 = tSTransform.heightToDevice(this.getArrowHeight() + (double)this.getLineWidth());
        float f14 = f13 * (f10 /= f11);
        float f15 = f13 * (f /= f11);
        float f16 = f12 * f;
        float f17 = f12 * f10;
        Polygon polygon = null;
        Polygon polygon2 = null;
        if (bl) {
            polygon = new Polygon();
            polygon.addPoint(n, n2);
            polygon.addPoint(n + (int)(f14 - f16), n2 - (int)(f15 + f17));
            polygon.addPoint(n + (int)(f14 + f16), n2 - (int)(f15 - f17));
            n += (int)f14;
            n2 -= (int)f15;
        }
        if (bl2) {
            polygon2 = new Polygon();
            polygon2.addPoint(n3, n4);
            polygon2.addPoint(n3 - (int)(f14 - f16), n4 + (int)(f15 + f17));
            polygon2.addPoint(n3 - (int)(f14 + f16), n4 + (int)(f15 - f17));
            n3 -= (int)f14;
            n4 += (int)f15;
        }
        if (bl3 && f12 > 1.5f) {
            if (polygon != null) {
                tSEGraphics.fillPolygon(polygon);
            }
            if (polygon2 != null) {
                tSEGraphics.fillPolygon(polygon2);
            }
        }
        if (bl4) {
            Stroke stroke = tSEGraphics.getStroke();
            tSEGraphics.setStroke(new BasicStroke(1.0f));
            if (polygon != null) {
                tSEGraphics.drawPolygon(polygon);
            }
            if (polygon2 != null) {
                tSEGraphics.drawPolygon(polygon2);
            }
            tSEGraphics.setStroke(stroke);
        }
        tSEGraphics.drawLine(n, n2, n3, n4);
    }

    public void setLineWidth(int n) {
        Integer n2 = new Integer(this.lineWidth);
        this.lineWidth = n;
        this.firePropertyChangedEvent(LINE_WIDTH, n2, new Integer(n));
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    public void setDashPhase(float f) {
        if (f < 0.0f) {
            f = 0.0f;
        }
        if (f > 1.0f) {
            f = 1.0f;
        }
        this.dashPhase = f;
    }

    public float getDashPhase() {
        return this.dashPhase;
    }

    public void setLineStyle(int n) {
        if (n < 0 || n >= LINE_STYLES.length) {
            n = 0;
        }
        Integer n2 = new Integer(this.lineStyle);
        this.lineStyle = n;
        this.firePropertyChangedEvent(LINE_STYLE, n2, new Integer(n));
    }

    public int getLineStyle() {
        return this.lineStyle;
    }

    public List getProperties() {
        List list = super.getProperties();
        list.add(new TSProperty(LINE_WIDTH, new Integer(this.getLineWidth())));
        list.add(new TSProperty(LINE_STYLE, new Integer(this.getLineStyle())));
        return list;
    }

    public List getChangedProperties() {
        List list = super.getChangedProperties();
        if (this.getDefaultLineWidth() != this.getLineWidth()) {
            list.add(new TSProperty(LINE_WIDTH, new Integer(this.getLineWidth())));
        }
        if (this.getDefaultLineStyle() != this.getLineStyle()) {
            list.add(new TSProperty(LINE_STYLE, new Integer(this.getLineStyle())));
        }
        return list;
    }

    public void setProperty(TSProperty tSProperty) {
        if (LINE_WIDTH.equals(tSProperty.getName())) {
            this.setLineWidth(Integer.parseInt(tSProperty.getValue().toString()));
        } else if (LINE_STYLE.equals(tSProperty.getName())) {
            this.setLineStyle(Integer.parseInt(tSProperty.getValue().toString()));
        } else {
            super.setProperty(tSProperty);
        }
    }

    public void getInspectorPropertyIDs(List list) {
        list.add(STYLE_ID);
        list.add(WIDTH_ID);
        super.getInspectorPropertyIDs(list);
    }

    public TSEInspectorProperty getInspectorProperty(TSEInspectorPropertyID tSEInspectorPropertyID) {
        TSEInspectorProperty tSEInspectorProperty;
        block9: {
            block10: {
                block12: {
                    block11: {
                        block6: {
                            block8: {
                                block7: {
                                    if (!tSEInspectorPropertyID.equals(WIDTH_ID)) break block6;
                                    if (widthEditor == null) break block7;
                                    if (widthRenderer != null) break block8;
                                }
                                widthEditor = new TSEKeyValueInspectorPropertyEditor();
                                widthEditor.getComboBox().setRenderer(new h5());
                                widthRenderer = new TSEKeyValueInspectorPropertyRenderer();
                                widthRenderer.getComboBox().setRenderer(new h5());
                            }
                            TSEKeyValueInspectorProperty tSEKeyValueInspectorProperty = new TSEKeyValueInspectorProperty(new Integer(this.getLineWidth()), true, widthRenderer, widthEditor);
                            for (int i = 0; i < LINE_WIDTHS.length; ++i) {
                                tSEKeyValueInspectorProperty.put(new Integer(LINE_WIDTHS[i]), new Integer(LINE_WIDTHS[i]));
                            }
                            tSEInspectorProperty = tSEKeyValueInspectorProperty;
                            break block9;
                        }
                        if (!tSEInspectorPropertyID.equals(STYLE_ID)) break block10;
                        if (styleEditor == null) break block11;
                        if (styleRenderer != null) break block12;
                    }
                    styleEditor = new TSEKeyValueInspectorPropertyEditor();
                    styleEditor.getComboBox().setRenderer(new h6());
                    styleRenderer = new TSEKeyValueInspectorPropertyRenderer();
                    styleRenderer.getComboBox().setRenderer(new h6());
                }
                TSEKeyValueInspectorProperty tSEKeyValueInspectorProperty = new TSEKeyValueInspectorProperty(new Integer(this.getLineStyle()), true, styleRenderer, styleEditor);
                for (int i = 0; i < LINE_STYLES.length; ++i) {
                    tSEKeyValueInspectorProperty.put(new Integer(i), new Integer(i));
                }
                tSEInspectorProperty = tSEKeyValueInspectorProperty;
                break block9;
            }
            tSEInspectorProperty = super.getInspectorProperty(tSEInspectorPropertyID);
        }
        return tSEInspectorProperty;
    }

    public int setInspectorProperty(TSEInspectorPropertyID tSEInspectorPropertyID, TSEInspectorProperty tSEInspectorProperty) {
        int n;
        if (tSEInspectorPropertyID.equals(WIDTH_ID)) {
            this.setLineWidth((Integer)tSEInspectorProperty.getValue());
            n = 1;
        } else if (tSEInspectorPropertyID.equals(STYLE_ID)) {
            this.setLineStyle((Integer)tSEInspectorProperty.getValue());
            n = 1;
        } else {
            n = super.setInspectorProperty(tSEInspectorPropertyID, tSEInspectorProperty);
        }
        return n;
    }

    public int getDefaultLineWidth() {
        return 1;
    }

    public int getDefaultLineStyle() {
        return 0;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

