/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editor.ui;

import com.tomsawyer.drawing.TSLabel;
import com.tomsawyer.drawing.geometry.TSConstPoint;
import com.tomsawyer.drawing.geometry.TSConstRect;
import com.tomsawyer.drawing.geometry.TSExpTransform;
import com.tomsawyer.drawing.geometry.TSRect;
import com.tomsawyer.editor.TSEColor;
import com.tomsawyer.editor.TSEFont;
import com.tomsawyer.editor.TSEGraph;
import com.tomsawyer.editor.TSEObject;
import com.tomsawyer.editor.TSEResourceBundleWrapper;
import com.tomsawyer.editor.TSTransform;
import com.tomsawyer.editor.graphics.TSEGraphics;
import com.tomsawyer.editor.ui.TSEAnnotatedUI;
import java.awt.Point;

public abstract class TSELabelUI
extends TSEAnnotatedUI {
    private static String defaultText = null;
    private TSLabel ownerLabel;

    public void drawSelectedOutline(TSEGraphics tSEGraphics) {
        super.drawSelectedOutline(tSEGraphics);
        if (((TSEObject)((Object)this.getOwnerLabel())).isDragged()) {
            this.drawCalloutOutline(tSEGraphics);
        }
    }

    public void drawSelected(TSEGraphics tSEGraphics) {
        super.drawSelected(tSEGraphics);
        if (((TSEObject)((Object)this.getOwnerLabel())).isDragged()) {
            this.drawCallout(tSEGraphics);
        }
    }

    public void drawCalloutOutline(TSEGraphics tSEGraphics) {
        TSLabel tSLabel = this.getOwnerLabel();
        TSConstPoint tSConstPoint = tSLabel.getDrawableAttachmentPoint();
        TSConstPoint tSConstPoint2 = tSLabel.getLocalCenter();
        TSConstPoint tSConstPoint3 = tSLabel.getLocalBounds().intersection(tSConstPoint.getX(), tSConstPoint.getY(), tSConstPoint2.getX(), tSConstPoint2.getY());
        if (tSConstPoint3 == null) {
            tSConstPoint3 = tSConstPoint2;
        }
        TSTransform tSTransform = tSEGraphics.getTSTransform();
        Point point = tSTransform.pointToDevice(tSConstPoint);
        Point point2 = tSTransform.pointToDevice(tSConstPoint3);
        int n = this.getGrappleSize(tSTransform.getScaleX());
        tSEGraphics.drawLine(point.x, point.y, point2.x, point2.y);
        tSEGraphics.drawOval(point.x - n / 2, point.y - n / 2, n, n);
    }

    public void drawCallout(TSEGraphics tSEGraphics) {
        TSLabel tSLabel = this.getOwnerLabel();
        TSConstPoint tSConstPoint = tSLabel.getLocalAttachmentPoint();
        TSConstPoint tSConstPoint2 = tSLabel.getLocalCenter();
        TSConstPoint tSConstPoint3 = tSLabel.getLocalBounds().intersection(tSConstPoint.getX(), tSConstPoint.getY(), tSConstPoint2.getX(), tSConstPoint2.getY());
        if (tSConstPoint3 == null) {
            tSConstPoint3 = tSConstPoint2;
        }
        TSTransform tSTransform = tSEGraphics.getTSTransform();
        Point point = tSTransform.pointToDevice(tSConstPoint);
        Point point2 = tSTransform.pointToDevice(tSConstPoint3);
        int n = this.getGrappleSize(tSTransform.getScaleX());
        tSEGraphics.drawLine(point.x, point.y, point2.x, point2.y);
        tSEGraphics.fillOval(point.x - n / 2, point.y - n / 2, n, n);
    }

    public TSConstRect getInvalidRegion() {
        TSEGraph tSEGraph = (TSEGraph)this.getOwnerLabel().getOwner().getOwnerGraph();
        TSTransform tSTransform = ((TSEGraph)tSEGraph.getMainDisplayGraph()).getGraphWindow().getTransform();
        TSExpTransform tSExpTransform = tSEGraph.getLocalToMainDisplayGraphTransform();
        return this.getInvalidRegion(tSTransform, tSExpTransform);
    }

    public TSConstRect getInvalidRegion(TSTransform tSTransform, TSExpTransform tSExpTransform) {
        TSConstRect tSConstRect = super.getInvalidRegion(tSTransform, tSExpTransform);
        TSLabel tSLabel = this.getOwnerLabel();
        if (((TSEObject)((Object)tSLabel)).isDragged()) {
            TSRect tSRect = new TSRect(tSConstRect);
            TSTransform tSTransform2 = TSTransform.compose(tSTransform, tSExpTransform);
            TSConstPoint tSConstPoint = tSLabel.getAttachmentPoint();
            int n = this.getGrappleSize(tSTransform2.getScaleX());
            double d = tSTransform.widthToWorld(n);
            double d2 = tSTransform.heightToWorld(n);
            tSRect.merge(tSConstPoint.getX() - d / 2.0, tSConstPoint.getY() - d2 / 2.0, tSConstPoint.getX() + d / 2.0, tSConstPoint.getY() + d2 / 2.0);
            tSConstRect = tSRect;
        }
        return tSConstRect;
    }

    public TSEColor getDefaultFillColor() {
        return TSEColor.white;
    }

    public double getMarginWidth() {
        return 1.0;
    }

    public double getMarginHeight() {
        return 0.0;
    }

    public TSEObject getOwner() {
        return (TSEObject)((Object)this.ownerLabel);
    }

    public TSLabel getOwnerLabel() {
        return this.ownerLabel;
    }

    public void setOwner(TSLabel tSLabel) {
        this.ownerLabel = tSLabel;
        if (this.ownerLabel != null) {
            this.onTextChanged(this.ownerLabel.getText());
        }
    }

    protected void nullifyOwner() {
        this.ownerLabel = null;
    }

    public String getDefaultText() {
        if (defaultText != null) {
            return defaultText;
        }
        return TSEResourceBundleWrapper.getSystemLabelBundle().getStringSafely("Untitled");
    }

    public static void setDefaultText(String string) {
        defaultText = string;
    }

    public boolean isBorderDrawnByDefault() {
        return false;
    }

    public boolean isTransparentByDefault() {
        return true;
    }

    public TSEFont getDefaultFont() {
        return TSEFont.SANS_SERIF_8;
    }
}

