/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editor.ui;

import com.tomsawyer.drawing.TSDEdge;
import com.tomsawyer.drawing.TSGNode;
import com.tomsawyer.drawing.TSPEdge;
import com.tomsawyer.drawing.TSPNode;
import com.tomsawyer.drawing.geometry.TSConstPoint;
import com.tomsawyer.editor.TSEEdge;
import com.tomsawyer.editor.TSEGraphManager;
import com.tomsawyer.editor.TSEGraphWindow;
import com.tomsawyer.editor.TSEObjectUI;
import com.tomsawyer.editor.TSEResourceBundleWrapper;
import com.tomsawyer.editor.TSTransform;
import com.tomsawyer.editor.graphics.TSEGraphics;
import com.tomsawyer.editor.inspector.TSEInspectorProperty;
import com.tomsawyer.editor.inspector.TSEInspectorPropertyID;
import com.tomsawyer.editor.inspector.TSEKeyValueInspectorProperty;
import com.tomsawyer.editor.inspector.TSEKeyValueInspectorPropertyEditor;
import com.tomsawyer.editor.inspector.TSEKeyValueInspectorPropertyRenderer;
import com.tomsawyer.editor.ui.TSEEdgeUI;
import com.tomsawyer.editor.ui.h0;
import com.tomsawyer.graph.TSNode;
import com.tomsawyer.util.TSProperty;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.util.Iterator;
import java.util.List;

public class TSECurvedEdgeUI
extends TSEEdgeUI {
    public static TSEInspectorPropertyID CONTROL_LINE_STYLE_ID = new TSEInspectorPropertyID(TSEResourceBundleWrapper.getSystemLabelBundle().getStringSafely("Control_Line_Style"), class$java$lang$Integer == null ? (class$java$lang$Integer = TSECurvedEdgeUI.class$("java.lang.Integer")) : class$java$lang$Integer);
    public static TSEInspectorPropertyID CURVATURE_ID = new TSEInspectorPropertyID(TSEResourceBundleWrapper.getSystemLabelBundle().getStringSafely("Curvature"), class$java$lang$Integer == null ? (class$java$lang$Integer = TSECurvedEdgeUI.class$("java.lang.Integer")) : class$java$lang$Integer);
    public static final String CURVATURE = "curvature";
    public static final String CONTROL_LINE_STYLE = "controlLineStyle";
    public static final float[][] LINE_STYLES = new float[][]{null, {18.0f, 6.0f}, {6.0f, 6.0f}, {3.0f, 3.0f}, {9.0f, 6.0f, 3.0f, 6.0f}, {9.0f, 3.0f, 3.0f, 3.0f, 3.0f, 3.0f}};
    public static final int LINE_STYLE_SOLID = 0;
    public static final int LINE_STYLE_LONG_DASH = 1;
    public static final int LINE_STYLE_SHORT_DASH = 2;
    public static final int LINE_STYLE_DOT = 3;
    public static final int LINE_STYLE_DASH_DOT = 4;
    public static final int LINE_STYLE_DASH_DOT_DOT = 5;
    static TSEKeyValueInspectorPropertyEditor controlLineStyleEditor = null;
    static TSEKeyValueInspectorPropertyRenderer controlLineStyleRenderer = null;
    private int controlLineStyle;
    private Shape curvedPath;
    private Stroke stroke;
    private int curvature;
    static /* synthetic */ Class class$java$lang$Integer;

    public void reset() {
        super.reset();
        this.setCurvature(this.getDefaultCurvature());
        this.setControlLineStyle(this.getDefaultControlLineStyle());
        this.setControlLineStroke(null);
        this.curvedPath = null;
    }

    public void copy(TSEObjectUI tSEObjectUI) {
        super.copy(tSEObjectUI);
        TSECurvedEdgeUI tSECurvedEdgeUI = (TSECurvedEdgeUI)tSEObjectUI;
        this.setCurvature(tSECurvedEdgeUI.getCurvature());
        this.setControlLineStyle(tSECurvedEdgeUI.getControlLineStyle());
        this.setControlLineStroke(tSECurvedEdgeUI.getControlLineStroke());
        this.curvedPath = null;
    }

    public void draw(TSEGraphics tSEGraphics) {
        if (this.getOwnerEdge().isHighlighted()) {
            tSEGraphics.setColor(this.getHighlightedColor());
        } else {
            tSEGraphics.setColor(this.getLineColor());
        }
        this.drawPath(tSEGraphics);
    }

    public void drawOutline(TSEGraphics tSEGraphics) {
        this.drawPathOutline(tSEGraphics);
    }

    public void drawSelected(TSEGraphics tSEGraphics) {
        tSEGraphics.setColor(this.getSelectedColor());
        this.drawPath(tSEGraphics);
        this.drawControlPath(tSEGraphics);
    }

    public void drawSelectedOutline(TSEGraphics tSEGraphics) {
        tSEGraphics.setColor(this.getSelectedColor());
        this.drawOutline(tSEGraphics);
        this.drawControlPath(tSEGraphics);
    }

    public void drawPath(TSEGraphics tSEGraphics, boolean bl, boolean bl2, boolean bl3) {
        TSPEdge tSPEdge = this.getOwnerEdge().getFirstDrawablePEdge();
        TSPEdge tSPEdge2 = this.getOwnerEdge().getLastDrawablePEdge();
        TSPEdge tSPEdge3 = null;
        Object object = null;
        if (this.isUsingAntiAliasing()) {
            object = tSEGraphics.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            tSEGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        if (tSPEdge != null && tSPEdge2 != null) {
            TSTransform tSTransform = tSEGraphics.getTSTransform();
            TSPEdge tSPEdge4 = tSPEdge;
            TSPEdge tSPEdge5 = tSPEdge2;
            if (!this.getOwnerEdge().isStraight()) {
                Object object2;
                if (bl3) {
                    if (tSPEdge.length() <= this.getArrowHeight() && ((TSNode)(object2 = (Object)((TSGNode)tSPEdge.getTargetNode()))).isPathNode()) {
                        tSPEdge4 = ((TSPNode)object2).getOutEdge();
                    }
                    if (tSPEdge2.length() <= this.getArrowHeight() && ((TSNode)(object2 = (TSGNode)tSPEdge2.getSourceNode())).isPathNode()) {
                        tSPEdge5 = ((TSPNode)object2).getInEdge();
                    }
                }
                object2 = this.createControlPoints(tSTransform);
                this.drawCurve(tSEGraphics, (float[])object2, bl, bl2, tSPEdge4, tSPEdge5);
            } else {
                tSPEdge3 = this.getOwnerEdge().getSourceEdge();
                this.drawPathEdgeOrArrows(tSEGraphics, bl, bl2, tSPEdge3, true, true, tSPEdge4, tSPEdge5, false);
            }
        }
        if (this.isUsingAntiAliasing()) {
            tSEGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
        }
    }

    private float[] createControlPoints(TSTransform tSTransform) {
        int n;
        TSPEdge tSPEdge = this.getOwnerEdge().getFirstDrawablePEdge();
        TSPEdge tSPEdge2 = this.getOwnerEdge().getLastDrawablePEdge();
        int n2 = this.getOwnerEdge().numberOfPathEdges() + 1;
        float[] fArray = new float[2 * n2];
        boolean bl = false;
        int n3 = 0;
        Iterator iterator = this.getOwnerEdge().pathIterator();
        while (iterator.hasNext()) {
            TSConstPoint tSConstPoint;
            TSPEdge tSPEdge3 = (TSPEdge)iterator.next();
            boolean bl2 = tSPEdge3 == tSPEdge;
            int n4 = n = tSPEdge3 == tSPEdge2 ? 1 : 0;
            if (bl2) {
                bl = true;
                tSConstPoint = ((TSDEdge)tSPEdge3.getOwner()).getLocalSourceClippingPoint();
                fArray[n3] = tSTransform.xToDevice(tSConstPoint.getX());
                fArray[n3 + 1] = tSTransform.yToDevice(tSConstPoint.getY());
                n3 += 2;
            }
            if (bl) {
                if (n != 0) {
                    tSConstPoint = ((TSDEdge)tSPEdge3.getOwner()).getLocalTargetClippingPoint();
                    fArray[n3] = tSTransform.xToDevice(tSConstPoint.getX());
                    fArray[n3 + 1] = tSTransform.yToDevice(tSConstPoint.getY());
                } else {
                    tSConstPoint = tSPEdge3.getLocalTargetPoint();
                    fArray[n3] = tSTransform.xToDevice(tSConstPoint.getX());
                    fArray[n3 + 1] = tSTransform.yToDevice(tSConstPoint.getY());
                }
                n3 += 2;
            }
            if (n == 0) continue;
        }
        int n5 = n3;
        float[] fArray2 = new float[n5];
        for (n = 0; n < n5; ++n) {
            fArray2[n] = fArray[n];
        }
        return fArray2;
    }

    public boolean intersects(double d, double d2, double d3, double d4) {
        TSEEdge tSEEdge = this.getOwnerEdge();
        boolean bl = false;
        if (tSEEdge.numberOfPathEdges() > 1) {
            TSECurvedEdgeUI tSECurvedEdgeUI = (TSECurvedEdgeUI)tSEEdge.getUI();
            TSEGraphWindow tSEGraphWindow = ((TSEGraphManager)this.getOwnerEdge().getOwnerGraph().getOwnerGraphManager()).getGraphWindow();
            Graphics2D graphics2D = (Graphics2D)tSEGraphWindow.getGraphics();
            TSTransform tSTransform = tSEGraphWindow.getTransform();
            float[] fArray = tSECurvedEdgeUI.createControlPoints(tSTransform);
            Shape shape = tSECurvedEdgeUI.createCurve(fArray);
            Rectangle rectangle = new Rectangle(tSTransform.xToDevice(d - this.arrowWidth), tSTransform.yToDevice(d4 + this.arrowHeight), tSTransform.widthToDevice(d3 - d + 2.0 * this.arrowWidth), tSTransform.heightToDevice(d4 - d2 + 2.0 * this.arrowHeight));
            bl = graphics2D.hit(rectangle, shape, true);
        } else {
            bl = super.intersects(d, d2, d3, d4);
        }
        return bl;
    }

    public void drawCurve(TSEGraphics tSEGraphics, TSConstPoint[] tSConstPointArray) {
        int n = tSConstPointArray.length;
        TSTransform tSTransform = tSEGraphics.getTSTransform();
        float[] fArray = new float[2 * n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            fArray[n2] = tSTransform.xToDevice(tSConstPointArray[i].getX());
            fArray[++n2] = tSTransform.yToDevice(tSConstPointArray[i].getY());
            ++n2;
        }
        this.drawCurve(tSEGraphics, fArray, true, true, null, null);
    }

    private void drawCurve(TSEGraphics tSEGraphics, float[] fArray, boolean bl, boolean bl2, TSPEdge tSPEdge, TSPEdge tSPEdge2) {
        boolean bl3 = false;
        boolean bl4 = false;
        if (tSPEdge != null) {
            bl3 = true;
        }
        if (tSPEdge2 != null) {
            bl4 = true;
        }
        this.curvedPath = this.createCurve(fArray);
        tSEGraphics.draw(this.curvedPath);
        if (tSPEdge != null && tSPEdge == tSPEdge2) {
            TSPEdge tSPEdge3 = this.getOwnerEdge().getFirstDrawablePEdge();
            this.drawPathEdgeOrArrows(tSEGraphics, bl, bl2, tSPEdge3, true, true, tSPEdge, tSPEdge2, true);
        } else {
            TSPEdge tSPEdge4 = null;
            TSPEdge tSPEdge5 = null;
            if (this.getOwnerEdge() != null) {
                tSPEdge4 = this.getOwnerEdge().getFirstDrawablePEdge();
                tSPEdge5 = this.getOwnerEdge().getLastDrawablePEdge();
            }
            if (tSPEdge4 != null) {
                this.drawPathEdgeOrArrows(tSEGraphics, bl, bl2, tSPEdge4, true, false, tSPEdge, tSPEdge2, true);
            }
            if (tSPEdge5 != null) {
                this.drawPathEdgeOrArrows(tSEGraphics, bl, bl2, tSPEdge5, false, true, tSPEdge, tSPEdge2, true);
            }
        }
    }

    protected Shape createCurve(float[] fArray) {
        float f = fArray[0];
        float f10 = fArray[1];
        float f11 = fArray[2];
        float f12 = fArray[3];
        float f13 = (f11 + f) / 2.0f;
        float f14 = (f12 + f10) / 2.0f;
        GeneralPath generalPath = new GeneralPath(1);
        generalPath.moveTo(f, f10);
        generalPath.lineTo(f13, f14);
        float f15 = 0.5f + (float)this.curvature / 100.0f / 2.0f;
        for (int i = 4; i <= fArray.length; i += 2) {
            float f16 = f13 * (1.0f - f15) + f11 * f15;
            float f17 = f14 * (1.0f - f15) + f12 * f15;
            f = f11;
            f10 = f12;
            if (i < fArray.length) {
                f11 = fArray[i + 0];
                f12 = fArray[i + 1];
            }
            f13 = (f11 + f) / 2.0f;
            f14 = (f12 + f10) / 2.0f;
            float f18 = f13 * (1.0f - f15) + f * f15;
            float f19 = f14 * (1.0f - f15) + f10 * f15;
            generalPath.curveTo(f16, f17, f18, f19, f13, f14);
        }
        return generalPath;
    }

    private void drawPathEdgeOrArrows(TSEGraphics tSEGraphics, boolean bl, boolean bl2, TSPEdge tSPEdge, boolean bl3, boolean bl4, TSPEdge tSPEdge2, TSPEdge tSPEdge3, boolean bl5) {
        TSGNode tSGNode;
        boolean bl6 = tSPEdge == tSPEdge2 && (this.getArrowType() & 1) != 0;
        boolean bl7 = tSPEdge == tSPEdge3 && (this.getArrowType() & 2) != 0;
        TSConstPoint tSConstPoint = bl3 ? this.getOwnerEdge().getLocalSourceClippingPoint() : tSPEdge.getLocalSourcePoint();
        TSConstPoint tSConstPoint2 = bl4 ? this.getOwnerEdge().getLocalTargetClippingPoint() : tSPEdge.getLocalTargetPoint();
        TSPEdge tSPEdge4 = null;
        TSPEdge tSPEdge5 = null;
        TSPEdge tSPEdge6 = this.getOwnerEdge().getFirstDrawablePEdge();
        TSPEdge tSPEdge7 = this.getOwnerEdge().getLastDrawablePEdge();
        if (bl6 && tSPEdge6.length() <= this.getArrowHeight() && (tSGNode = (TSGNode)tSPEdge6.getTargetNode()).isPathNode()) {
            tSPEdge4 = ((TSPNode)tSGNode).getOutEdge();
        }
        if (bl7 && tSPEdge7.length() <= this.getArrowHeight() && (tSGNode = (TSGNode)tSPEdge7.getSourceNode()).isPathNode()) {
            tSPEdge5 = ((TSPNode)tSGNode).getInEdge();
        }
        if (tSPEdge4 != null) {
            tSConstPoint = tSPEdge4.getLocalSourcePoint();
            tSConstPoint2 = tSPEdge4.getLocalTargetPoint();
        }
        if (tSPEdge5 != null) {
            tSConstPoint2 = tSPEdge5.getLocalTargetPoint();
            tSConstPoint = tSPEdge5.getLocalSourcePoint();
        }
        if (bl6 || bl7) {
            this.drawLineWithArrow(tSEGraphics, tSConstPoint.getX(), tSConstPoint.getY(), tSConstPoint2.getX(), tSConstPoint2.getY(), bl6, bl7, bl, bl2, bl5);
        } else if (!bl5) {
            tSEGraphics.drawLine(tSConstPoint, tSConstPoint2);
        }
    }

    public void drawArrow(TSEGraphics tSEGraphics, double d, double d2, double d3, double d4, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.drawLineWithArrow(tSEGraphics, d, d2, d3, d4, bl, bl2, bl3, bl4, true);
    }

    protected void drawLineWithArrow(TSEGraphics tSEGraphics, double d, double d2, double d3, double d4, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        float f;
        TSTransform tSTransform = tSEGraphics.getTSTransform();
        float f10 = tSTransform.widthToDevice(d3 - d);
        float f11 = (float)Math.sqrt(f10 * f10 + (f = (float)tSTransform.heightToDevice(d4 - d2)) * f);
        if (f11 == 0.0f) {
            return;
        }
        int n = tSTransform.xToDevice(d);
        int n2 = tSTransform.yToDevice(d2);
        int n3 = tSTransform.xToDevice(d3);
        int n4 = tSTransform.yToDevice(d4);
        float f12 = (float)tSTransform.widthToDevice(this.getArrowWidth()) / 2.0f;
        if (f12 < 0.5f) {
            tSEGraphics.drawLine(n, n2, n3, n4);
            return;
        }
        float f13 = tSTransform.heightToDevice(this.getArrowHeight());
        float f14 = f13 * (f10 /= f11);
        float f15 = f13 * (f /= f11);
        float f16 = f12 * f;
        float f17 = f12 * f10;
        Polygon polygon = null;
        Polygon polygon2 = null;
        if (bl) {
            polygon = new Polygon();
            polygon.addPoint(n, n2);
            polygon.addPoint(n + (int)(f14 - f16), n2 - (int)(f15 + f17));
            polygon.addPoint(n + (int)(f14 + f16), n2 - (int)(f15 - f17));
            n += (int)f14;
            n2 -= (int)f15;
        }
        if (bl2) {
            polygon2 = new Polygon();
            polygon2.addPoint(n3, n4);
            polygon2.addPoint(n3 - (int)(f14 - f16), n4 + (int)(f15 + f17));
            polygon2.addPoint(n3 - (int)(f14 + f16), n4 + (int)(f15 - f17));
            n3 -= (int)f14;
            n4 += (int)f15;
        }
        if (bl3 && f12 > 1.5f) {
            if (polygon != null) {
                tSEGraphics.fillPolygon(polygon);
            }
            if (polygon2 != null) {
                tSEGraphics.fillPolygon(polygon2);
            }
        }
        if (bl4) {
            if (polygon != null) {
                tSEGraphics.drawPolygon(polygon);
            }
            if (polygon2 != null) {
                tSEGraphics.drawPolygon(polygon2);
            }
        }
        if (!bl5) {
            tSEGraphics.drawLine(n, n2, n3, n4);
        }
    }

    protected void drawControlPath(TSEGraphics tSEGraphics) {
        TSPEdge tSPEdge = this.getOwnerEdge().getFirstDrawablePEdge();
        TSPEdge tSPEdge2 = this.getOwnerEdge().getLastDrawablePEdge();
        Stroke stroke = tSEGraphics.getStroke();
        Stroke stroke2 = this.getControlLineStroke();
        tSEGraphics.setStroke(stroke2);
        boolean bl = false;
        Iterator iterator = this.getOwnerEdge().pathIterator();
        while (iterator.hasNext()) {
            boolean bl2;
            TSPEdge tSPEdge3 = (TSPEdge)iterator.next();
            boolean bl3 = tSPEdge3 == tSPEdge;
            boolean bl4 = bl2 = tSPEdge3 == tSPEdge2;
            if (bl3) {
                bl = true;
            }
            if (bl) {
                this.drawControlPathEdge(tSEGraphics, tSPEdge3, bl3, bl2);
            }
            if (!bl2) continue;
        }
        tSEGraphics.setStroke(stroke);
    }

    public void setControlLineStroke(Stroke stroke) {
        if (stroke != null) {
            this.stroke = stroke;
        }
    }

    public Stroke getControlLineStroke() {
        if (this.stroke == null) {
            this.stroke = new BasicStroke(1.0f, 1, 1, 0.0f, LINE_STYLES[this.getControlLineStyle()], 0.0f);
        }
        return this.stroke;
    }

    private void drawControlPathEdge(TSEGraphics tSEGraphics, TSPEdge tSPEdge, boolean bl, boolean bl2) {
        TSConstPoint tSConstPoint = bl ? this.getOwnerEdge().getLocalSourceClippingPoint() : tSPEdge.getLocalSourcePoint();
        TSConstPoint tSConstPoint2 = bl2 ? this.getOwnerEdge().getLocalTargetClippingPoint() : tSPEdge.getLocalTargetPoint();
        this.drawControlLine(tSEGraphics, tSConstPoint, tSConstPoint2);
    }

    public void drawControlLine(TSEGraphics tSEGraphics, TSConstPoint tSConstPoint, TSConstPoint tSConstPoint2) {
        TSTransform tSTransform = tSEGraphics.getTSTransform();
        int n = tSTransform.xToDevice(tSConstPoint.getX());
        int n2 = tSTransform.yToDevice(tSConstPoint.getY());
        int n3 = tSTransform.xToDevice(tSConstPoint2.getX());
        int n4 = tSTransform.yToDevice(tSConstPoint2.getY());
        tSEGraphics.drawLine(n, n2, n3, n4);
    }

    public int getControlLineStyle() {
        return this.controlLineStyle;
    }

    public void setControlLineStyle(int n) {
        Integer n2 = new Integer(this.controlLineStyle);
        this.controlLineStyle = n;
        this.firePropertyChangedEvent(CONTROL_LINE_STYLE, n2, new Integer(n));
        this.stroke = new BasicStroke(1.0f, 1, 1, 0.0f, LINE_STYLES[this.getControlLineStyle()], 0.0f);
    }

    public void setCurvature(int n) {
        if (n >= 0 && n <= 100) {
            Integer n2 = new Integer(this.curvature);
            this.curvature = n;
            this.firePropertyChangedEvent(CURVATURE, n2, new Integer(n));
        }
    }

    public int getCurvature() {
        return this.curvature;
    }

    public Shape getCurve() {
        return this.curvedPath;
    }

    public int getDefaultCurvature() {
        return 90;
    }

    public int getDefaultControlLineStyle() {
        return 3;
    }

    public List getProperties() {
        List list = super.getProperties();
        list.add(new TSProperty(CURVATURE, new Integer(this.getCurvature())));
        list.add(new TSProperty(CONTROL_LINE_STYLE, new Integer(this.getControlLineStyle())));
        return list;
    }

    public List getChangedProperties() {
        List list = super.getChangedProperties();
        if (this.getDefaultCurvature() != this.getCurvature()) {
            list.add(new TSProperty(CURVATURE, new Integer(this.getCurvature())));
        }
        if (this.getDefaultControlLineStyle() != this.getControlLineStyle()) {
            list.add(new TSProperty(CONTROL_LINE_STYLE, new Integer(this.getControlLineStyle())));
        }
        return list;
    }

    public void setProperty(TSProperty tSProperty) {
        if (CURVATURE.equals(tSProperty.getName())) {
            this.setCurvature(Integer.parseInt(tSProperty.getValue().toString()));
        } else if (CONTROL_LINE_STYLE.equals(tSProperty.getName())) {
            this.setControlLineStyle(Integer.parseInt(tSProperty.getValue().toString()));
        } else {
            super.setProperty(tSProperty);
        }
    }

    public void getInspectorPropertyIDs(List list) {
        list.add(CURVATURE_ID);
        list.add(CONTROL_LINE_STYLE_ID);
        super.getInspectorPropertyIDs(list);
    }

    public TSEInspectorProperty getInspectorProperty(TSEInspectorPropertyID tSEInspectorPropertyID) {
        TSEInspectorProperty tSEInspectorProperty;
        block4: {
            block5: {
                block7: {
                    block6: {
                        block3: {
                            TSEInspectorProperty tSEInspectorProperty2;
                            if (!tSEInspectorPropertyID.equals(CURVATURE_ID)) break block3;
                            tSEInspectorProperty = tSEInspectorProperty2 = new TSEInspectorProperty((Object)new Integer(this.getCurvature()), true);
                            break block4;
                        }
                        if (!tSEInspectorPropertyID.equals(CONTROL_LINE_STYLE_ID)) break block5;
                        if (controlLineStyleEditor == null) break block6;
                        if (controlLineStyleRenderer != null) break block7;
                    }
                    controlLineStyleEditor = new TSEKeyValueInspectorPropertyEditor();
                    controlLineStyleEditor.getComboBox().setRenderer(new h0());
                    controlLineStyleRenderer = new TSEKeyValueInspectorPropertyRenderer();
                    controlLineStyleRenderer.getComboBox().setRenderer(new h0());
                }
                TSEKeyValueInspectorProperty tSEKeyValueInspectorProperty = new TSEKeyValueInspectorProperty(new Integer(this.getControlLineStyle()), true, controlLineStyleRenderer, controlLineStyleEditor);
                for (int i = 0; i < LINE_STYLES.length; ++i) {
                    tSEKeyValueInspectorProperty.put(new Integer(i), new Integer(i));
                }
                tSEInspectorProperty = tSEKeyValueInspectorProperty;
                break block4;
            }
            tSEInspectorProperty = super.getInspectorProperty(tSEInspectorPropertyID);
        }
        return tSEInspectorProperty;
    }

    public int setInspectorProperty(TSEInspectorPropertyID tSEInspectorPropertyID, TSEInspectorProperty tSEInspectorProperty) {
        int n;
        if (tSEInspectorPropertyID.equals(CURVATURE_ID)) {
            int n2 = (Integer)tSEInspectorProperty.getValue();
            if (n2 >= 0 && n2 <= 100) {
                this.setCurvature(n2);
                n = 1;
            } else if (n2 < 0) {
                this.setCurvature(0);
                n = 2;
            } else {
                this.setCurvature(100);
                n = 2;
            }
        } else if (tSEInspectorPropertyID.equals(CONTROL_LINE_STYLE_ID)) {
            this.setControlLineStyle((Integer)tSEInspectorProperty.getValue());
            n = 1;
        } else {
            n = super.setInspectorProperty(tSEInspectorPropertyID, tSEInspectorProperty);
        }
        return n;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

