/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editor.ui;

import com.tomsawyer.drawing.geometry.TSConstRect;
import com.tomsawyer.drawing.geometry.TSConstSize;
import com.tomsawyer.editor.TSEColor;
import com.tomsawyer.editor.TSEFont;
import com.tomsawyer.editor.TSENode;
import com.tomsawyer.editor.TSEObjectUI;
import com.tomsawyer.editor.TSEResourceBundleWrapper;
import com.tomsawyer.editor.TSESolidObject;
import com.tomsawyer.editor.TSTransform;
import com.tomsawyer.editor.graphics.TSEGraphics;
import com.tomsawyer.editor.inspector.TSEInspectorProperty;
import com.tomsawyer.editor.inspector.TSEInspectorPropertyID;
import com.tomsawyer.editor.inspector.TSEKeyValueInspectorProperty;
import com.tomsawyer.editor.ui.TSERectangularUI;
import com.tomsawyer.util.TSProperty;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.util.List;

public abstract class TSEAnnotatedUI
extends TSERectangularUI {
    public static TSEInspectorPropertyID FONT_ID = new TSEInspectorPropertyID(TSEResourceBundleWrapper.getSystemLabelBundle().getStringSafely("Font"), class$com$tomsawyer$editor$TSEFont == null ? (class$com$tomsawyer$editor$TSEFont = TSEAnnotatedUI.class$("com.tomsawyer.editor.TSEFont")) : class$com$tomsawyer$editor$TSEFont);
    public static TSEInspectorPropertyID TEXT_COLOR_ID = new TSEInspectorPropertyID(TSEResourceBundleWrapper.getSystemLabelBundle().getStringSafely("Text_Color"), class$com$tomsawyer$editor$TSEColor == null ? (class$com$tomsawyer$editor$TSEColor = TSEAnnotatedUI.class$("com.tomsawyer.editor.TSEColor")) : class$com$tomsawyer$editor$TSEColor);
    public static TSEInspectorPropertyID JUSTIFICATION_ID = new TSEInspectorPropertyID(TSEResourceBundleWrapper.getSystemLabelBundle().getStringSafely("Text_Justification"), class$java$lang$Integer == null ? (class$java$lang$Integer = TSEAnnotatedUI.class$("java.lang.Integer")) : class$java$lang$Integer);
    public static final String LEFT_STRING = TSEResourceBundleWrapper.getSystemLabelBundle().getStringSafely("Left");
    public static final String RIGHT_STRING = TSEResourceBundleWrapper.getSystemLabelBundle().getStringSafely("Right");
    public static final String CENTER_STRING = TSEResourceBundleWrapper.getSystemLabelBundle().getStringSafely("Center");
    public static final String TEXT_COLOR = "textColor";
    public static final String FONT = "textFont";
    public static final String JUSTIFICATION = "justification";
    public static final int RIGHT = 0;
    public static final int CENTER = 1;
    public static final int LEFT = 2;
    int textLength;
    int textWidth;
    int textHeight;
    int numberOfLines;
    String longestLine;
    int lineHeight;
    TSEFont font;
    TSEColor textColor;
    int textJustification;
    protected String formattedText;
    private boolean isFormatted;
    private double oldWidth;
    private double oldHeight;
    static /* synthetic */ Class class$com$tomsawyer$editor$TSEFont;
    static /* synthetic */ Class class$com$tomsawyer$editor$TSEColor;
    static /* synthetic */ Class class$java$lang$Integer;

    public void reset() {
        super.reset();
        this.setFont(new TSEFont(this.getDefaultFont()));
        this.setTextColor(new TSEColor(this.getDefaultTextColor()));
        this.setJustification(this.getDefaultJustification());
        this.setFormattingEnabled(true);
    }

    public void copy(TSEObjectUI tSEObjectUI) {
        super.copy(tSEObjectUI);
        TSEAnnotatedUI tSEAnnotatedUI = (TSEAnnotatedUI)tSEObjectUI;
        this.setFont(tSEAnnotatedUI.getFont());
        this.setTextColor(tSEAnnotatedUI.getTextColor());
        this.setJustification(tSEAnnotatedUI.getJustification());
    }

    public void drawText(TSEGraphics tSEGraphics) {
        String string;
        TSTransform tSTransform = tSEGraphics.getTSTransform();
        if (this.getOwner().getWidth() != this.oldWidth || this.getOwner().getHeight() != this.oldHeight) {
            this.oldWidth = this.getOwner().getWidth();
            this.oldHeight = this.getOwner().getWidth();
            this.updateTextWidthAndHeight();
        }
        if ((string = this.formattedText) != null) {
            TSConstRect tSConstRect = this.getOwner().getLocalBounds();
            double d = this.getTextOffsetX() + tSConstRect.getCenterX();
            double d2 = this.getTextOffsetY() + tSConstRect.getCenterY();
            Font font = this.getScaledFont(tSTransform);
            tSEGraphics.setFont(font);
            FontMetrics fontMetrics = tSEGraphics.getFontMetrics();
            int n = fontMetrics.stringWidth(this.getLongestLine());
            int n2 = fontMetrics.getAscent() - fontMetrics.getLeading() - fontMetrics.getDescent();
            int n3 = n2 + fontMetrics.getHeight() * (this.numberOfLines - 1);
            int n4 = tSTransform.xToDevice(d) - n / 2;
            int n5 = tSTransform.yToDevice(d2) - n3 / 2;
            tSEGraphics.setColor(this.textColor.getColor());
            Shape shape = tSEGraphics.getClip();
            Rectangle rectangle = tSTransform.boundsToDevice(tSConstRect);
            tSEGraphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            int n6 = this.getJustification();
            int n7 = 0;
            int n8 = n5 + n2;
            int n9 = string.length();
            while (n7 < n9) {
                int n10 = string.indexOf(10, n7);
                if (n10 == -1) {
                    n10 = n9;
                }
                String string2 = string.substring(n7, n10);
                if (n6 == 0) {
                    n4 = tSTransform.xToDevice(d) + n / 2 - fontMetrics.stringWidth(string2);
                } else if (n6 == 1) {
                    n4 = tSTransform.xToDevice(d) - fontMetrics.stringWidth(string2) / 2;
                }
                if (string2.length() > 0) {
                    tSEGraphics.drawString(string2, n4, n8);
                }
                n8 += fontMetrics.getHeight();
                n7 = n10 + 1;
            }
            tSEGraphics.setClip(shape);
        }
    }

    protected String getFormattedText() {
        if (this.getOwner() == null) {
            return this.getDefaultText();
        }
        if (this.getOwner().getText() == null) {
            if (this.getOwner() instanceof TSENode) {
                return null;
            }
            return this.getDefaultText();
        }
        if (!this.isFormattingEnabled()) {
            this.formattedText = this.getOwner().getText();
            return this.formattedText;
        }
        int n = ((TSESolidObject)this.getOwner()).getResizability();
        if (!((n & 1) == 0 && (n & 2) == 0 || this.getOwner() instanceof TSENode && ((TSENode)this.getOwner()).isExpanded())) {
            this.formattedText = this.getOwner().getText();
            return this.formattedText;
        }
        double d = this.getWidth();
        String string = this.getOwner().getText();
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.getFont().getFont());
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        int n3 = -1;
        this.numberOfLines = 0;
        for (int i = 1; i < string.length(); ++i) {
            if (string.charAt(i) == '\n') {
                stringBuffer.append(string.substring(n2, i + 1));
                n2 = i + 1;
                n3 = -1;
                continue;
            }
            if (Character.isWhitespace(string.charAt(i))) {
                n3 = i;
            }
            if (!((double)fontMetrics.stringWidth(string.substring(n2, i + 1)) > d)) continue;
            if (n3 != -1) {
                stringBuffer.append(string.substring(n2, n3));
                n2 = n3 + 1;
                n3 = -1;
            } else {
                stringBuffer.append(string.substring(n2, i));
                n2 = i;
            }
            stringBuffer.append('\n');
        }
        if (string.substring(n2).length() > 0) {
            stringBuffer.append(string.substring(n2));
        }
        this.formattedText = stringBuffer.toString();
        return this.formattedText;
    }

    public boolean isFormattingEnabled() {
        return this.isFormatted;
    }

    public void setFormattingEnabled(boolean bl) {
        this.isFormatted = bl;
    }

    public TSEFont getFont() {
        return this.font;
    }

    public void setFont(TSEFont tSEFont) {
        TSEFont tSEFont2 = this.font;
        this.font = tSEFont;
        this.textLength = 0;
        this.updateTextSize();
        this.firePropertyChangedEvent(FONT, tSEFont2, tSEFont);
    }

    public Font getScaledFont(TSTransform tSTransform) {
        TSEFont tSEFont = this.getFont();
        if (tSEFont == null) {
            return null;
        }
        return tSEFont.getScaledFont(tSTransform.getScaleX(), this.getLongestLine(), tSTransform.widthToDevice(this.getTextWidth()));
    }

    public boolean isAnnotationEditable() {
        return true;
    }

    public String getLongestLine() {
        if (this.longestLine == null) {
            return "";
        }
        return this.longestLine;
    }

    public int getJustification() {
        return this.textJustification;
    }

    public int getDefaultJustification() {
        return 1;
    }

    public void setJustification(int n) {
        Integer n2 = new Integer(this.textJustification);
        this.textJustification = n;
        this.firePropertyChangedEvent(JUSTIFICATION, n2, new Integer(n));
    }

    public void onTextChanged(String string) {
        if (!(this.getOwner() instanceof TSENode)) {
            if (string == null && (this.getDefaultText() != null || string != null)) {
                this.getOwner().setTag(this.getDefaultText());
            }
            if (this.getOwner().getText() == null) {
                this.formattedText = this.getDefaultText();
                if (this.formattedText != null) {
                    this.getOwner().setTag(this.formattedText);
                }
            }
        } else if (this.getOwner().getText() == null) {
            this.formattedText = null;
        }
        this.textLength = 0;
        this.updateTextSize();
    }

    public TSEColor getTextColor() {
        return this.textColor;
    }

    public void setTextColor(TSEColor tSEColor) {
        TSEColor tSEColor2 = this.textColor;
        this.textColor = tSEColor;
        this.firePropertyChangedEvent(TEXT_COLOR, tSEColor2, tSEColor);
    }

    public TSConstSize getTextOffset() {
        return new TSConstSize(this.getTextOffsetX(), this.getTextOffsetY());
    }

    public double getTextOffsetX() {
        return 0.0;
    }

    public double getTextOffsetY() {
        return 0.0;
    }

    public List getProperties() {
        List list = super.getProperties();
        list.add(new TSProperty(FONT, this.getFont()));
        list.add(new TSProperty(TEXT_COLOR, this.getTextColor()));
        list.add(new TSProperty(JUSTIFICATION, new Integer(this.getJustification())));
        return list;
    }

    public void setProperty(TSProperty tSProperty) {
        String string = null;
        if (tSProperty.getValue() != null) {
            string = tSProperty.getValue().toString();
        }
        if (FONT.equals(tSProperty.getName()) || "font".equals(tSProperty.getName())) {
            if (tSProperty.getValue() instanceof TSEFont) {
                this.setFont((TSEFont)tSProperty.getValue());
            } else {
                this.setFont(new TSEFont(string));
            }
        } else if (TEXT_COLOR.equals(tSProperty.getName())) {
            if (tSProperty.getValue() instanceof TSEColor) {
                this.setTextColor((TSEColor)tSProperty.getValue());
            } else {
                this.setTextColor(new TSEColor(tSProperty.getValue().toString()));
            }
        } else if (JUSTIFICATION.equals(tSProperty.getName())) {
            this.setJustification(Integer.parseInt(string));
        } else {
            super.setProperty(tSProperty);
        }
    }

    public List getChangedProperties() {
        List list = super.getChangedProperties();
        if (!this.getDefaultFont().equals(this.getFont())) {
            list.add(new TSProperty(FONT, this.getFont()));
        }
        if (!this.getDefaultTextColor().equals(this.getTextColor())) {
            list.add(new TSProperty(TEXT_COLOR, this.getTextColor()));
        }
        if (this.getDefaultJustification() != this.getJustification()) {
            list.add(new TSProperty(JUSTIFICATION, new Integer(this.getJustification())));
        }
        return list;
    }

    public int getTextWidth() {
        return this.textWidth;
    }

    public int getTextHeight() {
        return this.textHeight;
    }

    public int getLineHeight() {
        return this.lineHeight;
    }

    public int getNumberOfLines() {
        return this.numberOfLines;
    }

    protected void updateTextWidthAndHeight() {
        this.updateTextWidthAndHeight(this.getFormattedText());
    }

    protected void updateTextWidthAndHeight(String string) {
        if (this.getOwner() != null) {
            this.textWidth = 0;
            this.textHeight = 0;
            this.lineHeight = 0;
            this.numberOfLines = 0;
            this.longestLine = null;
            if (this.getFont() == null || this.getFont().getFont() == null) {
                return;
            }
            FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.getFont().getFont());
            this.lineHeight = fontMetrics.getHeight();
            if (this.getOwner() == null) {
                return;
            }
            if (string != null) {
                this.textLength = string.length();
                this.longestLine = "";
                this.textWidth = 0;
                this.numberOfLines = 1;
                int n = 0;
                int n2 = 0;
                while (n2 < this.textLength) {
                    n2 = string.indexOf(10, n);
                    if (n2 == -1) {
                        n2 = this.textLength;
                    } else {
                        ++this.numberOfLines;
                    }
                    String string2 = string.substring(n, n2);
                    int n3 = fontMetrics.stringWidth(string2);
                    if (n3 > this.textWidth) {
                        this.textWidth = n3;
                        this.longestLine = string2;
                    }
                    n = n2 + 1;
                }
                this.textHeight = string.equals("") ? 0 : this.lineHeight * this.numberOfLines - fontMetrics.getLeading();
            }
        }
    }

    protected void updateTextSize() {
        this.updateTextWidthAndHeight();
        if (this.getOwner() instanceof TSESolidObject) {
            ((TSESolidObject)this.getOwner()).resize();
        }
    }

    public TSEFont getDefaultFont() {
        return TSEFont.SANS_SERIF_10;
    }

    public TSEColor getDefaultTextColor() {
        return TSEColor.black;
    }

    public String getDefaultText() {
        return null;
    }

    public double getTightWidth() {
        this.updateTextWidthAndHeight(this.getOwner().getText());
        return (double)this.getTextWidth() + this.getMarginWidth() * 2.0;
    }

    public double getTightHeight() {
        this.updateTextWidthAndHeight(this.getOwner().getText());
        int n = this.getTextHeight();
        if (n == 0) {
            FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.getFont().getFont());
            n = fontMetrics.getHeight() - fontMetrics.getLeading();
        }
        return (double)n + this.getMarginHeight() * 2.0;
    }

    public double getMarginWidth() {
        return 3.0;
    }

    public double getMarginHeight() {
        return 1.0;
    }

    public void getInspectorPropertyIDs(List list) {
        list.add(FONT_ID);
        list.add(TEXT_COLOR_ID);
        list.add(JUSTIFICATION_ID);
        super.getInspectorPropertyIDs(list);
    }

    public TSEInspectorProperty getInspectorProperty(TSEInspectorPropertyID tSEInspectorPropertyID) {
        TSEInspectorProperty tSEInspectorProperty;
        if (tSEInspectorPropertyID.equals(FONT_ID)) {
            tSEInspectorProperty = new TSEInspectorProperty(this.getFont());
        } else if (tSEInspectorPropertyID.equals(TEXT_COLOR_ID)) {
            tSEInspectorProperty = new TSEInspectorProperty(this.getTextColor());
        } else if (tSEInspectorPropertyID.equals(JUSTIFICATION_ID)) {
            TSEKeyValueInspectorProperty tSEKeyValueInspectorProperty = new TSEKeyValueInspectorProperty(new Integer(this.getJustification()));
            tSEKeyValueInspectorProperty.put(LEFT_STRING, new Integer(2));
            tSEKeyValueInspectorProperty.put(CENTER_STRING, new Integer(1));
            tSEKeyValueInspectorProperty.put(RIGHT_STRING, new Integer(0));
            tSEInspectorProperty = tSEKeyValueInspectorProperty;
        } else {
            tSEInspectorProperty = super.getInspectorProperty(tSEInspectorPropertyID);
        }
        return tSEInspectorProperty;
    }

    public int setInspectorProperty(TSEInspectorPropertyID tSEInspectorPropertyID, TSEInspectorProperty tSEInspectorProperty) {
        int n;
        if (tSEInspectorPropertyID.equals(FONT_ID)) {
            this.setFont((TSEFont)tSEInspectorProperty.getValue());
            n = 2;
        } else if (tSEInspectorPropertyID.equals(TEXT_COLOR_ID)) {
            this.setTextColor((TSEColor)tSEInspectorProperty.getValue());
            n = 1;
        } else if (tSEInspectorPropertyID.equals(JUSTIFICATION_ID)) {
            this.setJustification((Integer)tSEInspectorProperty.getValue());
            n = 1;
        } else {
            n = super.setInspectorProperty(tSEInspectorPropertyID, tSEInspectorProperty);
        }
        return n;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

