/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editor.tool;

import com.tomsawyer.drawing.geometry.TSConstPoint;
import com.tomsawyer.drawing.geometry.TSConstRect;
import com.tomsawyer.editor.TSECursorManager;
import com.tomsawyer.editor.TSEWindowInputTool;
import com.tomsawyer.editor.graphics.TSEGraphics;
import com.tomsawyer.util.f2;
import java.awt.Color;
import java.awt.event.MouseEvent;

public class TSEZoomTool
extends TSEWindowInputTool {
    TSConstPoint startPoint;
    TSConstPoint currentPoint;
    boolean marqueeActive;
    TSConstRect marqueeBounds;

    public TSEZoomTool() {
        f2.a(f2.a1);
        this.setDefaultCursor(TSECursorManager.getCursor("MarqueeZoom.32x32", 13));
        this.setActionCursor(TSECursorManager.getCursor("MarqueeZoom.32x32", 13));
    }

    public void onMousePressed(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & 0x10) != 0 && !mouseEvent.isPopupTrigger()) {
            this.startPoint = this.currentPoint = this.getWorldPoint(mouseEvent);
            this.marqueeActive = true;
            this.addDirtyRegion(this.startPoint);
        } else {
            super.onMousePressed(mouseEvent);
        }
    }

    public void onMouseDragged(MouseEvent mouseEvent) {
        if (this.marqueeActive) {
            this.currentPoint = this.getWorldPoint(mouseEvent);
            this.addDirtyRegion(this.currentPoint);
            if (!this.updateVisibleArea(this.currentPoint, true)) {
                this.paintDirtyRegion(false);
            }
        }
    }

    public void onMouseReleased(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & 0x10) != 0 && !mouseEvent.isPopupTrigger()) {
            if (this.marqueeActive) {
                this.marqueeActive = false;
                this.setDirtyRegion(null);
                this.marqueeBounds = new TSConstRect(this.startPoint, this.currentPoint);
                this.zoomToBounds(this.marqueeBounds);
            }
        } else {
            super.onMouseReleased(mouseEvent);
        }
    }

    public void onMouseMoved(MouseEvent mouseEvent) {
    }

    public void paint(TSEGraphics tSEGraphics) {
        if (this.marqueeActive) {
            tSEGraphics.setColor(Color.gray);
            tSEGraphics.drawRect(new TSConstRect(this.startPoint, this.currentPoint));
        }
    }

    public void cancelAction() {
        this.marqueeActive = false;
        this.getGraphWindow().fastRepaint();
    }

    public void zoomToBounds(TSConstRect tSConstRect) {
        if (this.startPoint.getX() == this.currentPoint.getX() || this.startPoint.getY() == this.currentPoint.getY()) {
            this.cancelAction();
        } else {
            int n = this.getEventManager().getContext();
            this.getEventManager().setContext(this.getEventContext());
            this.getGraphWindow().fitRectInWindow(tSConstRect, true);
            this.getEventManager().setContext(n);
        }
    }

    public TSConstRect getMarqueeBounds() {
        return this.marqueeBounds;
    }

    public TSConstPoint getStartPoint() {
        return this.startPoint;
    }

    public TSConstPoint getCurrentPoint() {
        return this.currentPoint;
    }

    public int getEventContext() {
        return 12;
    }
}

