/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editor.tool;

import com.tomsawyer.drawing.geometry.TSConstPoint;
import com.tomsawyer.drawing.geometry.TSConstRect;
import com.tomsawyer.drawing.geometry.TSPoint;
import com.tomsawyer.drawing.geometry.TSRect;
import com.tomsawyer.editor.TSEConnector;
import com.tomsawyer.editor.TSEConnectorLabel;
import com.tomsawyer.editor.TSEEdge;
import com.tomsawyer.editor.TSEEdgeLabel;
import com.tomsawyer.editor.TSEGraph;
import com.tomsawyer.editor.TSEGraphWindow;
import com.tomsawyer.editor.TSEHitTesting;
import com.tomsawyer.editor.TSENode;
import com.tomsawyer.editor.TSENodeLabel;
import com.tomsawyer.editor.TSEPNode;
import com.tomsawyer.editor.TSEWindowInputTool;
import com.tomsawyer.editor.graphics.TSEGraphics;
import java.awt.Color;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class TSESelectRegionTool
extends TSEWindowInputTool {
    private TSEGraph selectedGraph;
    TSConstPoint startPoint;
    TSConstPoint currentPoint;
    boolean marqueeActive;
    boolean partialSelection;
    List hitList;

    public TSESelectRegionTool(TSEWindowInputTool tSEWindowInputTool, TSConstPoint tSConstPoint, TSEGraph tSEGraph) {
        this(tSEWindowInputTool, tSConstPoint, tSEGraph, true);
    }

    public TSESelectRegionTool(TSEWindowInputTool tSEWindowInputTool, TSConstPoint tSConstPoint, TSEGraph tSEGraph, boolean bl) {
        super(tSEWindowInputTool);
        this.startPoint = this.currentPoint = tSConstPoint;
        this.marqueeActive = true;
        this.partialSelection = bl;
        this.selectedGraph = tSEGraph;
        this.hitList = new Vector();
    }

    protected void setGraphWindow(TSEGraphWindow tSEGraphWindow) {
        super.setGraphWindow(tSEGraphWindow);
        this.addDirtyRegion(this.startPoint);
    }

    public void onMouseDragged(MouseEvent mouseEvent) {
        TSConstPoint tSConstPoint = this.getNonalignedWorldPoint(mouseEvent);
        if (this.selectedGraph != this.getGraph() && this.selectedGraph.getParent() instanceof TSENode) {
            TSENode tSENode = (TSENode)this.selectedGraph.getParent();
            TSConstRect tSConstRect = ((TSEGraph)tSENode.getChildGraph()).getFrameBounds();
            if (tSConstRect.contains(tSConstPoint)) {
                this.currentPoint = tSConstPoint;
            } else {
                this.arrangeEndPoint(tSConstRect, tSConstPoint);
            }
        } else {
            this.currentPoint = tSConstPoint;
        }
        this.addDirtyRegion(this.currentPoint);
        if (!this.updateVisibleArea(tSConstPoint, true)) {
            this.paintDirtyRegion(false);
        }
    }

    public void onMouseReleased(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & 0x10) != 0 && !mouseEvent.isPopupTrigger()) {
            this.setDirtyRegion(null);
            if (this.marqueeActive) {
                this.marqueeActive = false;
                TSRect tSRect = new TSRect(this.startPoint, this.currentPoint);
                this.hitList = this.getSelectedObjects(tSRect, this.hitList);
                int n = this.getEventManager().getContext();
                this.getEventManager().setContext(this.getEventContext());
                if (!mouseEvent.isShiftDown() && !mouseEvent.isControlDown()) {
                    this.getGraphWindow().deselectAll(true);
                }
                if (mouseEvent.isControlDown()) {
                    this.getGraphWindow().toggleGroupSelection(this.hitList, true);
                } else {
                    this.getGraphWindow().selectGroup(this.hitList, true);
                }
                this.getEventManager().setContext(n);
            }
            this.getGraphWindow().fastRepaint();
            this.finalizeTool();
        } else {
            super.onMouseReleased(mouseEvent);
        }
    }

    private void arrangeEndPoint(TSConstRect tSConstRect, TSConstPoint tSConstPoint) {
        TSPoint tSPoint = new TSPoint(tSConstPoint);
        if (tSConstRect.getRight() < tSConstPoint.getX()) {
            if (tSConstRect.getTop() < tSConstPoint.getY()) {
                tSPoint.setLocation(tSConstRect.getRight(), tSConstRect.getTop());
            } else if (tSConstRect.getBottom() > tSConstPoint.getY()) {
                tSPoint.setLocation(tSConstRect.getRight(), tSConstRect.getBottom());
            } else {
                tSPoint.setX(tSConstRect.getRight());
            }
        } else if (tSConstRect.getLeft() > tSConstPoint.getX()) {
            if (tSConstRect.getTop() < tSConstPoint.getY()) {
                tSPoint.setLocation(tSConstRect.getLeft(), tSConstRect.getTop());
            } else if (tSConstRect.getBottom() > tSConstPoint.getY()) {
                tSPoint.setLocation(tSConstRect.getLeft(), tSConstRect.getBottom());
            } else {
                tSPoint.setX(tSConstRect.getLeft());
            }
        } else if (tSConstRect.getTop() < tSConstPoint.getY()) {
            tSPoint.setY(tSConstRect.getTop());
        } else if (tSConstRect.getBottom() > tSConstPoint.getY()) {
            tSPoint.setY(tSConstRect.getBottom());
        }
        this.currentPoint = new TSConstPoint(tSPoint.getX(), tSPoint.getY());
    }

    public void paint(TSEGraphics tSEGraphics) {
        if (this.marqueeActive) {
            tSEGraphics.setColor(Color.gray);
            tSEGraphics.drawRect(new TSConstRect(this.startPoint, this.currentPoint));
        }
    }

    public void cancelAction() {
        this.marqueeActive = false;
        this.getGraphWindow().fastRepaint();
        this.finalizeTool();
    }

    public List getSelectedObjects(TSConstRect tSConstRect, List list) {
        list = this.partialSelection ? this.getObjectsTouchingBounds(tSConstRect, list) : this.getObjectsInsideBounds(tSConstRect, list);
        return list;
    }

    public List getObjectsTouchingBounds(TSConstRect tSConstRect, List list) {
        TSEHitTesting tSEHitTesting = this.getHitTesting();
        tSEHitTesting.findObjectsIntersectingRect(tSConstRect, this.getGraph(), this.getGraphWindow().isNestedGraphEditingEnabled(), list, list, list, list, list, list, list, null);
        return list;
    }

    public List getObjectsInsideBounds(TSConstRect tSConstRect, List list) {
        Vector vector = new Vector();
        this.getObjectsTouchingBounds(tSConstRect, vector);
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof TSENode && ((TSENode)e).inside(tSConstRect)) {
                list.add(e);
                continue;
            }
            if (e instanceof TSEEdge && ((TSEEdge)e).inside(tSConstRect)) {
                list.add(e);
                continue;
            }
            if (e instanceof TSEConnector && ((TSEConnector)e).inside(tSConstRect)) {
                list.add(e);
                continue;
            }
            if (e instanceof TSEPNode && ((TSEPNode)e).inside(tSConstRect)) {
                list.add(e);
                continue;
            }
            if (e instanceof TSENodeLabel && ((TSENodeLabel)e).inside(tSConstRect)) {
                list.add(e);
                continue;
            }
            if (e instanceof TSEEdgeLabel && ((TSEEdgeLabel)e).inside(tSConstRect)) {
                list.add(e);
                continue;
            }
            if (!(e instanceof TSEConnectorLabel) || !((TSEConnectorLabel)e).inside(tSConstRect)) continue;
            list.add(e);
        }
        return list;
    }

    public List getHitObjectList() {
        return this.hitList;
    }

    public TSConstPoint getStartPoint() {
        return this.startPoint;
    }

    public TSConstPoint getEndPoint() {
        return this.currentPoint;
    }

    public TSConstRect getMarqueeBounds() {
        return new TSConstRect(this.startPoint, this.currentPoint);
    }

    public int getEventContext() {
        return 10;
    }
}

