/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editor.tool;

import com.tomsawyer.complexity.TSNestingManager;
import com.tomsawyer.diagramming.TSResizeControl;
import com.tomsawyer.drawing.TSConnector;
import com.tomsawyer.drawing.TSDEdge;
import com.tomsawyer.drawing.TSDGraph;
import com.tomsawyer.drawing.TSEdgeLabel;
import com.tomsawyer.drawing.TSGraphTailor;
import com.tomsawyer.drawing.TSLabel;
import com.tomsawyer.drawing.TSSolidGeometricObject;
import com.tomsawyer.drawing.geometry.TSConstPoint;
import com.tomsawyer.drawing.geometry.TSConstRect;
import com.tomsawyer.drawing.geometry.TSConstSize;
import com.tomsawyer.drawing.geometry.TSPoint;
import com.tomsawyer.editor.TSEConnector;
import com.tomsawyer.editor.TSEConnectorLabel;
import com.tomsawyer.editor.TSEEdge;
import com.tomsawyer.editor.TSEEdgeLabel;
import com.tomsawyer.editor.TSEGraph;
import com.tomsawyer.editor.TSEGraphManager;
import com.tomsawyer.editor.TSEGraphWindow;
import com.tomsawyer.editor.TSEHitTesting;
import com.tomsawyer.editor.TSENode;
import com.tomsawyer.editor.TSENodeLabel;
import com.tomsawyer.editor.TSEObject;
import com.tomsawyer.editor.TSEWindowInputTool;
import com.tomsawyer.editor.TSTransform;
import com.tomsawyer.editor.command.TSEResizeGraphObjectCommand;
import com.tomsawyer.editor.graphics.TSEGraphics;
import com.tomsawyer.editor.tool.f7;
import com.tomsawyer.graph.TSEdge;
import com.tomsawyer.graph.TSGraphObject;
import com.tomsawyer.util.TSSystem;
import com.tomsawyer.util.f2;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.Timer;

public class TSEResizeGraphObjectTool
extends TSEWindowInputTool {
    TSSolidGeometricObject resizeGraphObject;
    int grapple;
    double dx;
    double dy;
    TSResizeControl control;
    TSConstPoint startPoint;
    boolean needsGridCorrection;
    Vector visibleAffectedEdges;
    Vector visibleAffectedNodeLabels;
    Timer timer;
    MouseEvent event;
    List graphs;
    List margins;

    public TSEResizeGraphObjectTool(TSEWindowInputTool tSEWindowInputTool, TSConstPoint tSConstPoint, boolean bl) {
        super(tSEWindowInputTool);
        f2.a(f2.bt);
        TSSystem.tsAssert(tSEWindowInputTool != null);
        TSSystem.tsAssert(tSConstPoint != null);
        this.startPoint = tSConstPoint;
        this.needsGridCorrection = bl;
    }

    protected void init() {
        super.init();
        TSEHitTesting tSEHitTesting = this.getHitTesting();
        this.resizeGraphObject = tSEHitTesting.getOwnerOfGrappleAt(this.startPoint, this.getGraph(), this.getGraphWindow().isNestedGraphEditingEnabled());
        this.grapple = tSEHitTesting.getGrappleAt(this.startPoint, this.getGraph(), this.getGraphWindow().isNestedGraphEditingEnabled());
        this.storeOldMargins();
        this.control = new TSResizeControl();
        int n = this.getResizeMode(this.grapple);
        this.control.init(this.resizeGraphObject, n);
        this.control.setPreventResizeInversion(this.getGraphWindow().getPreferences().getBooleanValue("preventResizeInversion"));
        this.control.onStart();
        this.computeOffset(this.startPoint);
        if (this.resizeGraphObject instanceof TSENode) {
            TSGraphObject tSGraphObject;
            this.visibleAffectedEdges = new Vector();
            this.visibleAffectedNodeLabels = new Vector();
            Iterator iterator = this.control.getAffectedEdges().iterator();
            while (iterator.hasNext()) {
                tSGraphObject = (TSGraphObject)iterator.next();
                if (!tSGraphObject.isVisible()) continue;
                this.visibleAffectedEdges.add(tSGraphObject);
            }
            iterator = this.control.getAffectedNodeLabels().iterator();
            while (iterator.hasNext()) {
                tSGraphObject = (TSGraphObject)iterator.next();
                if (!tSGraphObject.isVisible()) continue;
                this.visibleAffectedNodeLabels.add(tSGraphObject);
            }
        }
        this.setAffectedObjectsVisible(false);
        this.invalidateAffectedObjects();
    }

    public TSConstPoint getWorldPoint(MouseEvent mouseEvent) {
        TSEGraphWindow tSEGraphWindow = this.getGraphWindow();
        double d = this.dx + tSEGraphWindow.getTransform().xToWorld(mouseEvent.getX());
        double d2 = this.dy + tSEGraphWindow.getTransform().yToWorld(mouseEvent.getY());
        if (this.isAlignmentEnabled(mouseEvent) && tSEGraphWindow.hasGrid()) {
            d = this.getGridOffsetX() + tSEGraphWindow.getGrid().getNearestGridX(d);
            d2 = this.getGridOffsetY() + tSEGraphWindow.getGrid().getNearestGridY(d2);
        }
        return new TSConstPoint(d, d2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMouseDragged(MouseEvent mouseEvent) {
        TSConstPoint tSConstPoint = this.getWorldPoint(mouseEvent);
        TSPoint tSPoint = new TSPoint(tSConstPoint);
        TSDGraph tSDGraph = (TSDGraph)this.resizeGraphObject.getOwnerGraph();
        if (tSDGraph.isIntergraph() && this.resizeGraphObject instanceof TSEdgeLabel) {
            tSDGraph = ((TSEdgeLabel)this.resizeGraphObject).getTransformGraph();
        }
        tSDGraph.inverseExpandedTransformPoint(tSPoint);
        this.updateDirtyRegion();
        boolean bl = this.getEventManager().isFiringEvents();
        this.getEventManager().setFireEvents(false);
        this.control.onDragTo(tSPoint.getX(), tSPoint.getY());
        this.getEventManager().setFireEvents(bl);
        this.updateDirtyRegion();
        if (!this.updateVisibleArea(tSConstPoint, true)) {
            this.paintDirtyRegion(true);
        }
        MouseEvent mouseEvent2 = mouseEvent;
        synchronized (mouseEvent2) {
            this.setMouseEvent(mouseEvent);
        }
    }

    public void onMouseReleased(MouseEvent mouseEvent) {
        TSConstPoint tSConstPoint = this.getWorldPoint(mouseEvent);
        TSPoint tSPoint = new TSPoint(tSConstPoint);
        TSDGraph tSDGraph = (TSDGraph)this.resizeGraphObject.getOwnerGraph();
        if (tSDGraph.isIntergraph() && this.resizeGraphObject instanceof TSEdgeLabel) {
            tSDGraph = ((TSEdgeLabel)this.resizeGraphObject).getTransformGraph();
        }
        tSDGraph.inverseExpandedTransformPoint(tSPoint);
        this.commitResize(tSPoint.getX(), tSPoint.getY());
        this.finalizeTool();
    }

    public void onMouseEntered(MouseEvent mouseEvent) {
        if (this.timer != null && this.timer.isRunning()) {
            this.timer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMouseExited(MouseEvent mouseEvent) {
        if (this.resizeGraphObject != null) {
            if (this.timer == null) {
                this.timer = new Timer(50, new f7(this));
                this.timer.setCoalesce(true);
            }
            if (!this.timer.isRunning()) {
                this.timer.start();
            }
            MouseEvent mouseEvent2 = mouseEvent;
            synchronized (mouseEvent2) {
                this.setMouseEvent(mouseEvent);
            }
        }
    }

    void updateDirtyRegion() {
        if (this.resizeGraphObject instanceof TSENode) {
            TSGraphObject tSGraphObject;
            this.addDirtyRegion((TSENode)this.resizeGraphObject);
            this.addDirtyRegion(((TSENode)this.resizeGraphObject).labels());
            Iterator iterator = ((TSENode)this.resizeGraphObject).connectors().iterator();
            while (iterator.hasNext()) {
                tSGraphObject = (TSEConnector)iterator.next();
                this.addDirtyRegion((TSEObject)((Object)tSGraphObject));
                this.addDirtyRegion(((TSConnector)tSGraphObject).labels());
            }
            iterator = this.control.getAffectedEdges().iterator();
            while (iterator.hasNext()) {
                tSGraphObject = (TSEEdge)iterator.next();
                this.addDirtyRegion((TSEObject)((Object)tSGraphObject));
                this.addDirtyRegion(((TSDEdge)tSGraphObject).labels());
            }
        } else if (this.resizeGraphObject instanceof TSENodeLabel) {
            this.addDirtyRegion((TSENodeLabel)this.resizeGraphObject);
        } else if (this.resizeGraphObject instanceof TSEConnectorLabel) {
            this.addDirtyRegion((TSEConnectorLabel)this.resizeGraphObject);
        } else if (this.resizeGraphObject instanceof TSEEdgeLabel) {
            this.addDirtyRegion((TSEEdgeLabel)this.resizeGraphObject);
        }
    }

    public void paint(TSEGraphics tSEGraphics) {
        if (this.control.getState() == 200) {
            Vector vector = new Vector();
            Vector vector2 = new Vector();
            if (this.getGraphWindow().isDrawInvisibleOnDragging()) {
                vector = (Vector)this.control.getAffectedNodeLabels();
                vector2 = (Vector)this.control.getAffectedEdges();
            } else {
                vector = this.visibleAffectedNodeLabels;
                vector2 = this.visibleAffectedEdges;
            }
            TSDGraph tSDGraph = (TSDGraph)this.resizeGraphObject.getOwnerGraph();
            if (tSDGraph.isIntergraph() && this.resizeGraphObject instanceof TSEdgeLabel) {
                tSDGraph = ((TSEdgeLabel)this.resizeGraphObject).getTransformGraph();
            }
            TSEGraphics tSEGraphics2 = tSEGraphics.deriveGraphics(TSTransform.compose(tSEGraphics.getTSTransform(), tSDGraph.getLocalToMainDisplayGraphTransform()));
            if (this.getGraphWindow().isDrawFullUIOnDragging()) {
                if (this.resizeGraphObject instanceof TSENode) {
                    TSGraphObject tSGraphObject;
                    TSENode tSENode = (TSENode)this.resizeGraphObject;
                    tSENode.getUI().drawSelected(tSEGraphics2);
                    tSENode.getNodeUI().drawConnectors(tSEGraphics2);
                    Iterator iterator = tSENode.labels().iterator();
                    while (iterator.hasNext()) {
                        tSGraphObject = (TSENodeLabel)iterator.next();
                        if (!this.getGraphWindow().isDrawInvisibleOnDragging() && !((TSLabel)tSGraphObject).isVisible()) continue;
                        if (((TSENodeLabel)tSGraphObject).isSelected()) {
                            ((TSENodeLabel)tSGraphObject).getUI().drawSelected(tSEGraphics2);
                            continue;
                        }
                        ((TSENodeLabel)tSGraphObject).getUI().draw(tSEGraphics2);
                    }
                    iterator = vector2.iterator();
                    while (iterator.hasNext()) {
                        tSGraphObject = (TSEEdge)iterator.next();
                        boolean bl = ((TSEdge)tSGraphObject).isIntergraphEdge();
                        TSTransform tSTransform = TSTransform.compose(tSEGraphics.getTSTransform(), ((TSDEdge)tSGraphObject).getLocalToMainDisplayGraphTransform());
                        TSEGraphics tSEGraphics3 = tSEGraphics.deriveGraphics(tSTransform);
                        if (bl && ((TSDEdge)tSGraphObject).isViewable()) {
                            if (((TSEEdge)tSGraphObject).isSelected()) {
                                ((TSEEdge)tSGraphObject).getUI().drawSelected(tSEGraphics3);
                            } else {
                                ((TSEEdge)tSGraphObject).getUI().draw(tSEGraphics3);
                            }
                            ((TSEEdge)tSGraphObject).getEdgeUI().drawBends(tSEGraphics3);
                        } else {
                            if (((TSEEdge)tSGraphObject).isSelected()) {
                                ((TSEEdge)tSGraphObject).getUI().drawSelected(tSEGraphics2);
                            } else {
                                ((TSEEdge)tSGraphObject).getUI().draw(tSEGraphics2);
                            }
                            ((TSEEdge)tSGraphObject).getEdgeUI().drawBends(tSEGraphics2);
                        }
                        Iterator iterator2 = ((TSDEdge)tSGraphObject).labels().iterator();
                        while (iterator2.hasNext()) {
                            TSEEdgeLabel tSEEdgeLabel = (TSEEdgeLabel)iterator2.next();
                            if (!this.getGraphWindow().isDrawInvisibleOnDragging() && !tSEEdgeLabel.isVisible()) continue;
                            if (bl && ((TSDEdge)tSGraphObject).isViewable()) {
                                if (tSEEdgeLabel.isSelected()) {
                                    tSEEdgeLabel.getUI().drawSelected(tSEGraphics3);
                                    continue;
                                }
                                tSEEdgeLabel.getUI().draw(tSEGraphics3);
                                continue;
                            }
                            if (tSEEdgeLabel.isSelected()) {
                                tSEEdgeLabel.getUI().drawSelected(tSEGraphics2);
                                continue;
                            }
                            tSEEdgeLabel.getUI().draw(tSEGraphics2);
                        }
                    }
                    iterator = vector.iterator();
                    while (iterator.hasNext()) {
                        tSGraphObject = (TSENodeLabel)iterator.next();
                        if (((TSENodeLabel)tSGraphObject).isSelected()) {
                            ((TSENodeLabel)tSGraphObject).getUI().drawSelected(tSEGraphics2);
                            continue;
                        }
                        ((TSENodeLabel)tSGraphObject).getUI().draw(tSEGraphics2);
                    }
                } else if (this.resizeGraphObject instanceof TSENodeLabel) {
                    ((TSENodeLabel)this.resizeGraphObject).getUI().drawSelected(tSEGraphics2);
                } else if (this.resizeGraphObject instanceof TSEConnectorLabel) {
                    ((TSEConnectorLabel)this.resizeGraphObject).getUI().drawSelected(tSEGraphics2);
                } else if (this.resizeGraphObject instanceof TSEEdgeLabel) {
                    ((TSEEdgeLabel)this.resizeGraphObject).getUI().drawSelected(tSEGraphics2);
                }
            } else if (this.resizeGraphObject instanceof TSENode) {
                TSGraphObject tSGraphObject;
                TSENode tSENode = (TSENode)this.resizeGraphObject;
                tSENode.getUI().drawSelectedOutline(tSEGraphics2);
                tSENode.getNodeUI().drawConnectorOutlines(tSEGraphics2);
                Iterator iterator = tSENode.labels().iterator();
                while (iterator.hasNext()) {
                    tSGraphObject = (TSENodeLabel)iterator.next();
                    if (!this.getGraphWindow().isDrawInvisibleOnDragging() && !((TSLabel)tSGraphObject).isVisible()) continue;
                    if (((TSENodeLabel)tSGraphObject).isSelected()) {
                        ((TSENodeLabel)tSGraphObject).getUI().drawSelectedOutline(tSEGraphics2);
                        continue;
                    }
                    ((TSENodeLabel)tSGraphObject).getUI().drawOutline(tSEGraphics2);
                }
                iterator = vector2.iterator();
                while (iterator.hasNext()) {
                    tSGraphObject = (TSEEdge)iterator.next();
                    boolean bl = ((TSEdge)tSGraphObject).isIntergraphEdge();
                    if (bl && ((TSDEdge)tSGraphObject).isViewable()) {
                        TSTransform tSTransform = TSTransform.compose(tSEGraphics.getTSTransform(), ((TSDEdge)tSGraphObject).getLocalToMainDisplayGraphTransform());
                        TSEGraphics tSEGraphics4 = tSEGraphics.deriveGraphics(tSTransform);
                        if (((TSEEdge)tSGraphObject).isSelected()) {
                            ((TSEEdge)tSGraphObject).getUI().drawSelectedOutline(tSEGraphics4);
                        } else {
                            ((TSEEdge)tSGraphObject).getUI().drawOutline(tSEGraphics4);
                        }
                        ((TSEEdge)tSGraphObject).getEdgeUI().drawBendOutlines(tSEGraphics4);
                        continue;
                    }
                    if (((TSEEdge)tSGraphObject).isSelected()) {
                        ((TSEEdge)tSGraphObject).getUI().drawSelectedOutline(tSEGraphics2);
                    } else {
                        ((TSEEdge)tSGraphObject).getUI().drawOutline(tSEGraphics2);
                    }
                    ((TSEEdge)tSGraphObject).getEdgeUI().drawBendOutlines(tSEGraphics2);
                }
                iterator = vector.iterator();
                while (iterator.hasNext()) {
                    tSGraphObject = (TSENodeLabel)iterator.next();
                    if (((TSENodeLabel)tSGraphObject).isSelected()) {
                        ((TSENodeLabel)tSGraphObject).getUI().drawSelectedOutline(tSEGraphics2);
                        continue;
                    }
                    ((TSENodeLabel)tSGraphObject).getUI().drawOutline(tSEGraphics2);
                }
            } else if (this.resizeGraphObject instanceof TSENodeLabel) {
                ((TSENodeLabel)this.resizeGraphObject).getUI().drawSelectedOutline(tSEGraphics2);
            } else if (this.resizeGraphObject instanceof TSEConnectorLabel) {
                ((TSEConnectorLabel)this.resizeGraphObject).getUI().drawSelectedOutline(tSEGraphics2);
            } else if (this.resizeGraphObject instanceof TSEEdgeLabel) {
                ((TSEEdgeLabel)this.resizeGraphObject).getUI().drawSelectedOutline(tSEGraphics2);
            }
        }
    }

    public void cancelAction() {
        if (this.timer != null && this.timer.isRunning()) {
            this.timer.stop();
        }
        this.control.onCancel();
        this.setAffectedObjectsVisible(true);
        this.invalidateAffectedObjects();
        this.getGraphWindow().fastRepaint();
        this.finalizeTool();
    }

    void computeOffset(TSConstPoint tSConstPoint) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        this.dy = 0.0;
        this.dx = 0.0;
        if (this.resizeGraphObject instanceof TSENode || this.resizeGraphObject instanceof TSLabel) {
            d = this.resizeGraphObject.getRight();
            d2 = this.resizeGraphObject.getLeft();
            d3 = this.resizeGraphObject.getTop();
            d4 = this.resizeGraphObject.getBottom();
        }
        if ((this.grapple & 1) != 0) {
            this.dy = d3 - tSConstPoint.getY();
        } else if ((this.grapple & 2) != 0) {
            this.dy = d4 - tSConstPoint.getY();
        }
        if ((this.grapple & 8) != 0) {
            this.dx = d2 - tSConstPoint.getX();
        } else if ((this.grapple & 4) != 0) {
            this.dx = d - tSConstPoint.getX();
        }
    }

    void setAffectedObjectsVisible(boolean bl) {
        if (this.resizeGraphObject instanceof TSENode) {
            this.resizeGraphObject.setVisible(bl);
            Iterator iterator = this.visibleAffectedEdges.iterator();
            while (iterator.hasNext()) {
                ((TSEObject)iterator.next()).setVisible(bl);
            }
            iterator = this.visibleAffectedNodeLabels.iterator();
            while (iterator.hasNext()) {
                ((TSEObject)iterator.next()).setVisible(bl);
            }
        } else if (this.resizeGraphObject instanceof TSENodeLabel || this.resizeGraphObject instanceof TSEConnectorLabel || this.resizeGraphObject instanceof TSEEdgeLabel) {
            this.resizeGraphObject.setVisible(bl);
        }
    }

    void invalidateAffectedObjects() {
        if (this.resizeGraphObject instanceof TSENode) {
            TSGraphObject tSGraphObject;
            this.getGraphWindow().addInvalidRegion((TSENode)this.resizeGraphObject);
            this.getGraphWindow().addInvalidRegion(((TSENode)this.resizeGraphObject).labels());
            Iterator iterator = ((TSENode)this.resizeGraphObject).connectors().iterator();
            while (iterator.hasNext()) {
                tSGraphObject = (TSEConnector)iterator.next();
                this.getGraphWindow().addInvalidRegion(((TSConnector)tSGraphObject).labels());
                this.getGraphWindow().addInvalidRegion((TSEObject)((Object)tSGraphObject));
            }
            iterator = this.control.getAffectedEdges().iterator();
            while (iterator.hasNext()) {
                tSGraphObject = (TSEEdge)iterator.next();
                this.getGraphWindow().addInvalidRegion(((TSDEdge)tSGraphObject).labels());
                this.getGraphWindow().addInvalidRegion((TSEObject)((Object)tSGraphObject));
            }
        } else if (this.resizeGraphObject instanceof TSENodeLabel) {
            this.getGraphWindow().addInvalidRegion((TSENodeLabel)this.resizeGraphObject);
        } else if (this.resizeGraphObject instanceof TSEConnectorLabel) {
            this.getGraphWindow().addInvalidRegion((TSEConnectorLabel)this.resizeGraphObject);
        } else if (this.resizeGraphObject instanceof TSEEdgeLabel) {
            this.getGraphWindow().addInvalidRegion((TSEEdgeLabel)this.resizeGraphObject);
        }
        this.getGraphWindow().updateInvalidRegion();
    }

    public TSConstPoint getStartPoint() {
        return this.startPoint;
    }

    public TSSolidGeometricObject getResizeGraphObject() {
        return this.resizeGraphObject;
    }

    public int getGrapple() {
        return this.grapple;
    }

    public TSResizeControl getResizeControl() {
        return this.control;
    }

    public void commitResize(double d, double d2) {
        boolean bl = this.getEventManager().isFiringEvents();
        this.getEventManager().setFireEvents(false);
        this.control.onDropAt(d, d2);
        TSConstRect tSConstRect = this.control.getOldBounds();
        TSConstRect tSConstRect2 = this.control.getNewBounds();
        TSConstSize tSConstSize = this.control.getOldOriginalSize();
        this.setAffectedObjectsVisible(true);
        if (this.timer != null && this.timer.isRunning()) {
            this.timer.stop();
        }
        this.resizeGraphObject.setLocalBounds(this.control.getOldBounds());
        this.getGraphWindow().getGraphManager().getEventManager().setFireEvents(bl);
        int n = this.getEventManager().getContext();
        this.getEventManager().setContext(this.getEventContext());
        TSEResizeGraphObjectCommand tSEResizeGraphObjectCommand = new TSEResizeGraphObjectCommand(this.resizeGraphObject, tSConstRect, tSConstRect2);
        tSEResizeGraphObjectCommand.setMarginLists(this.graphs, this.margins);
        this.getGraphWindow().transmit(tSEResizeGraphObjectCommand);
        this.getEventManager().setContext(n);
    }

    public MouseEvent getMouseEvent() {
        return this.event;
    }

    public void setMouseEvent(MouseEvent mouseEvent) {
        this.event = mouseEvent;
    }

    private void storeOldMargins() {
        TSEGraphManager tSEGraphManager;
        if (this.resizeGraphObject != null && this.resizeGraphObject.getOwnerGraph() != null && (tSEGraphManager = (TSEGraphManager)this.resizeGraphObject.getOwnerGraph().getOwnerGraphManager()) != null) {
            this.graphs = new Vector();
            this.margins = new Vector();
            TSNestingManager.buildNestedGraphList(tSEGraphManager.getMainDisplayGraph(), this.graphs, false);
            if (this.graphs != null) {
                Iterator iterator = this.graphs.iterator();
                while (iterator.hasNext()) {
                    double[] dArray = new double[4];
                    TSGraphTailor tSGraphTailor = ((TSEGraph)iterator.next()).getTailor();
                    dArray[0] = tSGraphTailor.getLeftConstantMargin();
                    dArray[1] = tSGraphTailor.getRightConstantMargin();
                    dArray[2] = tSGraphTailor.getBottomConstantMargin();
                    dArray[3] = tSGraphTailor.getTopConstantMargin();
                    this.margins.add(dArray);
                }
            }
        }
    }

    public int getEventContext() {
        return 5;
    }
}

