/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editor.inspector;

import com.tomsawyer.editor.TSEResourceBundleWrapper;
import com.tomsawyer.editor.inspector.TSEInspectorTable;
import com.tomsawyer.editor.inspector.TSETextRenderer;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.DefaultCellEditor;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;

public class TSETextEditor
extends DefaultCellEditor
implements MouseListener {
    JScrollPane scrollPane;
    JTextArea textArea;
    String dialogTitle;
    String text;
    boolean dialogShown;
    DefaultTableCellRenderer dummyRenderer;
    JTextField textField = (JTextField)this.getComponent();
    Component parentComponent;

    public TSETextEditor() {
        super(new JTextField());
        this.textField.addMouseListener(this);
        this.textArea = new JTextArea(5, 20);
        this.scrollPane = new JScrollPane(this.textArea);
        this.dummyRenderer = new TSETextRenderer();
        this.dummyRenderer.addMouseListener(this);
    }

    protected boolean showDialog() {
        this.textArea.setText(this.text);
        int n = JOptionPane.showConfirmDialog(this.parentComponent, this.scrollPane, this.getDialogTitle(), 2, -1);
        this.dialogShown = true;
        if (n == 0) {
            this.text = this.textArea.getText();
            return true;
        }
        return false;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this.textField && mouseEvent.isShiftDown()) {
            this.text = this.textField.getText();
            if (this.showDialog()) {
                this.stopCellEditing();
            } else {
                this.cancelCellEditing();
            }
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this.dummyRenderer) {
            if (this.showDialog()) {
                this.stopCellEditing();
            } else {
                this.cancelCellEditing();
            }
        }
    }

    public Object getCellEditorValue() {
        if (this.dialogShown) {
            return this.text;
        }
        Object object = super.getCellEditorValue();
        if (object == null) {
            return null;
        }
        if ("".equals(object.toString()) && this.text == null) {
            return null;
        }
        return object;
    }

    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.dialogShown = false;
        if (object != null) {
            this.text = object.toString();
            if (this.text.indexOf(10) != -1) {
                return this.dummyRenderer.getTableCellRendererComponent(jTable, object, bl, true, n, n2);
            }
        } else {
            this.text = null;
        }
        this.parentComponent = jTable instanceof TSEInspectorTable ? SwingUtilities.getRootPane(((TSEInspectorTable)jTable).getInspector().getParentWindow()) : null;
        return super.getTableCellEditorComponent(jTable, object, bl, n, n2);
    }

    protected String getDialogTitle() {
        if (this.dialogTitle == null) {
            this.dialogTitle = TSEResourceBundleWrapper.getSystemLabelBundle().getStringSafely("Enter_Text_Here");
        }
        return this.dialogTitle;
    }
}

