/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editor.inspector;

import com.tomsawyer.editor.TSEColor;
import com.tomsawyer.editor.TSELocalization;
import com.tomsawyer.editor.TSEResourceBundleWrapper;
import com.tomsawyer.editor.inspector.TSEColorRenderer;
import com.tomsawyer.editor.inspector.TSEInspectorTable;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.DefaultCellEditor;
import javax.swing.JColorChooser;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;

public class TSEColorEditor
extends DefaultCellEditor
implements ActionListener,
MouseListener {
    JColorChooser chooser;
    TSEColor currentColor;
    DefaultTableCellRenderer dummyRenderer;
    Component parentComponent;

    public TSEColorEditor() {
        super(new JTextField());
        if (UIManager.getString("ColorChooser.sampleText") == null) {
            UIManager.put("ColorChooser.sampleText", TSEResourceBundleWrapper.getSystemLabelBundle().getStringSafely("Sample_Text__Sample_Text"));
        }
        this.chooser = new JColorChooser();
        TSELocalization.setComponentOrientation(this.chooser);
        this.dummyRenderer = new TSEColorRenderer();
        this.dummyRenderer.addMouseListener(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand() == "OK") {
            this.currentColor = new TSEColor(this.chooser.getColor());
            this.stopCellEditing();
        } else {
            this.cancelCellEditing();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this.dummyRenderer) {
            JColorChooser.createDialog(this.parentComponent, TSEResourceBundleWrapper.getSystemLabelBundle().getStringSafely("Choose_Color"), true, this.chooser, this, this).show();
        }
    }

    public Object getCellEditorValue() {
        return this.currentColor;
    }

    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.currentColor = (TSEColor)object;
        if (this.currentColor != null && this.currentColor.getColor() != null) {
            this.chooser.setColor(this.currentColor.getColor());
        } else {
            this.chooser.setColor(Color.white);
        }
        this.parentComponent = jTable instanceof TSEInspectorTable ? SwingUtilities.getRootPane(((TSEInspectorTable)jTable).getInspector().getParentWindow()) : null;
        return this.dummyRenderer.getTableCellRendererComponent(jTable, object, bl, true, n, n2);
    }
}

