/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editor.export;

import com.tomsawyer.editor.TSEFont;
import com.tomsawyer.editor.TSEGraphWindow;
import com.tomsawyer.editor.export.TSEMultiPageExportSetup;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.LineMetrics;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import java.util.Vector;

public class TSEPrintSetup
extends TSEMultiPageExportSetup {
    PageFormat pageFormat;

    public TSEPrintSetup(TSEGraphWindow tSEGraphWindow) {
        super(tSEGraphWindow);
    }

    protected TSEPrintSetup() {
    }

    public void copy(Object object) {
        super.copy(object);
        if (!(object instanceof TSEPrintSetup)) {
            throw new ClassCastException(object.getClass().getName());
        }
        TSEPrintSetup tSEPrintSetup = (TSEPrintSetup)object;
        this.setPageFormat((PageFormat)tSEPrintSetup.getPageFormat().clone());
    }

    public void setDefaults() {
        this.setExportRange(1);
        this.setExportScale(4);
        this.setPageColumns(1);
        this.setPageRows(1);
        this.setCaptionExported(true);
        this.setCaptionFont(new TSEFont(new Font("TimesNewRoman", 0, 12)));
        Vector vector = new Vector();
        this.setCaption(vector);
        this.setCaptionPosition(10);
        this.setBorderExported(true);
        this.setBorderColor(Color.black);
        this.setPageNumberExported(true);
        this.setCropMarkExported(true);
        this.setCropMarkLength(36.0);
        this.setBackgroundExported(false);
        this.setGridExported(false);
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        this.setPageFormat(printerJob.defaultPage());
    }

    public void setPageFormat(PageFormat pageFormat) {
        this.pageFormat = pageFormat;
    }

    public PageFormat getPageFormat() {
        return this.pageFormat;
    }

    public double getTopMargin() {
        return this.pageFormat.getImageableY();
    }

    public double getBottomMargin() {
        return this.pageFormat.getHeight() - this.pageFormat.getImageableHeight() - this.pageFormat.getImageableY();
    }

    public double getLeftMargin() {
        return this.pageFormat.getImageableX();
    }

    public double getRightMargin() {
        return this.pageFormat.getWidth() - this.pageFormat.getImageableWidth() - this.pageFormat.getImageableX();
    }

    public double getWidth() {
        return this.pageFormat.getWidth();
    }

    public double getHeight() {
        return this.pageFormat.getHeight();
    }

    public double getImageableWidth() {
        return this.pageFormat.getImageableWidth();
    }

    public double getImageableHeight() {
        String string = "default";
        if (this.caption != null && this.caption.size() > 0) {
            string = (String)this.caption.firstElement();
        }
        LineMetrics lineMetrics = this.captionFont.getFont().getLineMetrics(string, ((Graphics2D)this.graphWindow.getGraphics()).getFontRenderContext());
        this.graphWindow.getGraphics();
        int n = Math.round(lineMetrics.getHeight());
        int n2 = this.caption.size();
        if (this.isCaptionExported()) {
            return this.pageFormat.getImageableHeight() - (double)(n2 * n) - 5.0;
        }
        return this.pageFormat.getImageableHeight();
    }

    public double getImageableX() {
        return this.pageFormat.getImageableX();
    }

    public double getImageableY() {
        block2: {
            int n;
            int n2;
            block3: {
                n2 = this.captionFont.getFont().getSize();
                n = this.caption.size();
                if (!this.isCaptionExported()) break block2;
                if (this.getCaptionPosition() == 7) break block3;
                if (this.getCaptionPosition() != 8) break block2;
            }
            return this.pageFormat.getImageableY() + (double)(n * n2) + 5.0;
        }
        return this.pageFormat.getImageableY();
    }
}

