/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editor.export;

import com.tomsawyer.editor.TSECursorManager;
import com.tomsawyer.editor.export.TSEPrintPreviewWindow;
import com.tomsawyer.editor.export.c2;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JViewport;
import javax.swing.border.Border;
import javax.swing.border.MatteBorder;

public class TSEPrintPreviewZoomTool
extends MouseAdapter {
    TSEPrintPreviewWindow previewWindow;
    c2 pagePreview;
    Border pageBorder;
    Cursor originalCursor;

    public TSEPrintPreviewZoomTool(TSEPrintPreviewWindow tSEPrintPreviewWindow) {
        this.previewWindow = tSEPrintPreviewWindow;
        this.registerListeners();
    }

    public void registerListeners() {
        for (int i = 0; i < this.previewWindow.getPreviewPane().previewContainer.getComponentCount(); ++i) {
            Component component = this.previewWindow.getPreviewPane().previewContainer.getComponent(i);
            component.addMouseListener(this);
            this.originalCursor = component.getCursor();
            component.setCursor(TSECursorManager.getCursor("PrintPreviewZoom.32x32", 12));
        }
    }

    public void unRegisterListeners() {
        for (int i = 0; i < this.previewWindow.getPreviewPane().previewContainer.getComponentCount(); ++i) {
            Component component = this.previewWindow.getPreviewPane().previewContainer.getComponent(i);
            component.removeMouseListener(this);
            component.setCursor(this.originalCursor);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        Component component = mouseEvent.getComponent();
        if (component instanceof c2) {
            this.pagePreview = (c2)component;
            this.pageBorder = this.pagePreview.getBorder();
            this.pagePreview.setBorder(new MatteBorder(2, 2, 2, 2, Color.yellow));
            this.pagePreview.repaint();
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.pagePreview.setBorder(this.pageBorder);
        this.pagePreview.repaint();
        this.pagePreview = null;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.pagePreview != null) {
            this.previewWindow.onZoomIn();
            this.positionPageInViewport();
            this.previewWindow.validate();
        }
    }

    public void positionPageInViewport() {
        JViewport jViewport = this.previewWindow.getPreviewPane().getViewport();
        int n = this.previewWindow.getPreviewPane().previewContainer.getPreferredSize().width;
        int n2 = this.previewWindow.getPreviewPane().previewContainer.getPreferredSize().height;
        int n3 = this.pagePreview.getLocation().x + this.pagePreview.getPreferredSize().width / 2 - jViewport.getSize().width / 2;
        int n4 = this.pagePreview.getLocation().y + this.pagePreview.getPreferredSize().height / 2 - jViewport.getSize().height / 2;
        if (n3 < 0) {
            n3 = 0;
        }
        if (n4 < 0) {
            n4 = 0;
        }
        if (n3 + jViewport.getSize().width > n) {
            n3 = n - jViewport.getSize().width;
        }
        if (n4 + jViewport.getSize().height > n2) {
            n4 = n2 - jViewport.getSize().height;
        }
        jViewport.setViewPosition(new Point(n3, n4));
        jViewport.setViewSize(new Dimension(jViewport.getViewSize().width * 2, jViewport.getViewSize().height * 2));
    }
}

