/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editor.export;

import com.tomsawyer.editor.TSEButtonKeyListener;
import com.tomsawyer.editor.TSEResourceBundleWrapper;
import com.tomsawyer.editor.export.TSEPrint;
import com.tomsawyer.editor.export.TSEPrintPreviewPane;
import com.tomsawyer.editor.export.TSEPrintPreviewZoomTool;
import com.tomsawyer.editor.export.TSEPrintSetup;
import com.tomsawyer.editor.export.TSEPrintSetupDialog;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.accessibility.AccessibleContext;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JToolBar;

public class TSEPrintPreviewWindow
extends JDialog
implements ActionListener {
    public static int[] SCALES = new int[]{100, 50, 25};
    Frame owner;
    protected JToolBar toolBar;
    protected JButton printButton;
    protected JButton printSetupButton;
    protected JButton zoomInButton;
    protected JButton zoomOutButton;
    protected JButton fitInButton;
    protected JButton closeButton;
    protected JComboBox scalesBox;
    protected TSEPrintPreviewPane previewPane;
    protected double scale;
    TSEResourceBundleWrapper labels;
    int[] scales;
    protected TSEPrintPreviewZoomTool zoomTool;

    public TSEPrintPreviewWindow(Frame owner, String title, TSEPrintSetup printSetup, int gap, int[] scales) {
        this(owner, title, new TSEPrintPreviewPane(printSetup, gap, (double)scales[0]), scales);
    }

    public TSEPrintPreviewWindow(Frame owner, String title, TSEPrintPreviewPane previewPane, int[] scales) {
        super(owner, title, true);
        this.previewPane = previewPane;
        this.owner = owner;
        this.scales = scales;
        this.scale = previewPane.getScale();
        this.labels = TSEResourceBundleWrapper.getSystemLabelBundle();
        this.init();
    }

    public TSEPrintPreviewWindow(Frame owner, String title, TSEPrintSetup printSetup) {
        this(owner, title, printSetup, TSEPrintPreviewPane.GAP, SCALES);
    }

    protected void init() {
        this.addKeyListener(new TSEButtonKeyListener(this, this));
        this.setLocationRelativeTo(this.owner);
        this.makeToolBar();
        this.getContentPane().add((Component)this.toolBar, "North");
        this.zoomTool = new TSEPrintPreviewZoomTool(this);
        this.getContentPane().add((Component)this.previewPane, "Center");
        this.setDefaultCloseOperation(1);
        this.addWindowListener(new PrintPreviewAdapter());
        TSEPrintSetup printSetup = this.previewPane.getPrintSetup();
        if (printSetup.getPageColumns() == 0 || printSetup.getPageRows() == 0) {
            this.printButton.setEnabled(false);
        } else {
            this.printButton.setEnabled(true);
        }
        this.getAccessibleContext().setAccessibleDescription(this.getTitle());
    }

    protected void makeToolBar() {
        this.toolBar = new JToolBar();
        this.toolBar.setFloatable(false);
        this.toolBar.setLayout(new BoxLayout(this.toolBar, 0));
        this.printButton = new JButton(this.labels.getStringSafely("Print..."));
        this.printButton.setMnemonic(80);
        this.printButton.setVerticalTextPosition(0);
        this.printButton.setHorizontalTextPosition(4);
        this.printButton.setActionCommand("print");
        this.printButton.addActionListener(this);
        this.printButton.setMargin(new Insets(2, 6, 2, 6));
        this.printSetupButton = new JButton(this.labels.getStringSafely("Print_Setup..."));
        this.printSetupButton.setMnemonic(83);
        this.printSetupButton.setActionCommand("print setup");
        this.printSetupButton.addActionListener(this);
        this.printSetupButton.setMargin(new Insets(2, 6, 2, 6));
        this.zoomInButton = new JButton(this.labels.getStringSafely("Zoom_In"));
        this.zoomInButton.setMnemonic(73);
        this.zoomInButton.setActionCommand("zoom in");
        this.zoomInButton.addActionListener(this);
        this.zoomInButton.setMargin(new Insets(2, 6, 2, 6));
        this.zoomOutButton = new JButton(this.labels.getStringSafely("Zoom_Out"));
        this.zoomOutButton.setMnemonic(79);
        this.zoomOutButton.setActionCommand("zoom out");
        this.zoomOutButton.addActionListener(this);
        this.zoomOutButton.setMargin(new Insets(2, 6, 2, 6));
        String[] scalesSt = new String[this.scales.length];
        for (int i = 0; i < this.scales.length; ++i) {
            scalesSt[i] = Integer.toString(this.scales[i]).concat("%");
        }
        this.scalesBox = new JComboBox<String>(scalesSt);
        this.scalesBox.setActionCommand("scales");
        this.scalesBox.addActionListener(this);
        this.scalesBox.setMinimumSize(new Dimension(90, 30));
        this.scalesBox.setMaximumSize(new Dimension(90, 30));
        this.scalesBox.setEditable(true);
        this.fitInButton = new JButton(this.labels.getStringSafely("Fit_In_Window"));
        this.fitInButton.setMnemonic(70);
        this.fitInButton.setActionCommand("fit in");
        this.fitInButton.addActionListener(this);
        this.fitInButton.setMargin(new Insets(2, 6, 2, 6));
        this.closeButton = new JButton(this.labels.getStringSafely("Close"));
        this.closeButton.setMnemonic(67);
        this.closeButton.setActionCommand("close");
        this.closeButton.addActionListener(this);
        this.closeButton.setMargin(new Insets(2, 6, 2, 6));
        this.toolBar.add(this.printButton);
        this.toolBar.add(Box.createRigidArea(new Dimension(3, 0)));
        this.toolBar.add(this.printSetupButton);
        this.toolBar.add(Box.createRigidArea(new Dimension(3, 0)));
        this.toolBar.add(this.zoomInButton);
        this.toolBar.add(Box.createRigidArea(new Dimension(3, 0)));
        this.toolBar.add(this.zoomOutButton);
        this.toolBar.add(Box.createRigidArea(new Dimension(3, 0)));
        this.toolBar.add(this.scalesBox);
        this.toolBar.add(Box.createRigidArea(new Dimension(3, 0)));
        this.toolBar.add(this.fitInButton);
        this.toolBar.add(Box.createRigidArea(new Dimension(3, 0)));
        this.toolBar.add(this.closeButton);
        this.toolBar.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        this.setAccessibleProperties();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("print")) {
            this.onPrint();
        } else if (e.getActionCommand().equals("print setup")) {
            this.onPrintSetup();
        } else if (e.getActionCommand().equals("close")) {
            this.removeAllComponents(this);
        } else if (e.getActionCommand().equals("scales")) {
            this.onUpdateScales();
        } else if (e.getActionCommand().equals("zoom in")) {
            this.onZoomIn();
        } else if (e.getActionCommand().equals("zoom out")) {
            this.onZoomOut();
        } else if (e.getActionCommand().equals("fit in")) {
            this.onFitIn();
        }
    }

    protected void onPrint() {
        TSEPrint print = new TSEPrint(this.owner, this.previewPane.getPrintSetup());
        print.execute();
    }

    protected void onPrintSetup() {
        TSEPrintSetup printSetup = this.previewPane.getPrintSetup();
        TSEPrintSetupDialog dialog = new TSEPrintSetupDialog((Dialog)this, "Print Setup", printSetup);
        dialog.setVisible(true);
        if (!dialog.getReturnValue()) {
            return;
        }
        this.previewPane.rebuildPreviewContainer(false);
        this.onFitIn();
        this.zoomTool.registerListeners();
        if (printSetup.getPageColumns() == 0 || printSetup.getPageRows() == 0) {
            this.printButton.setEnabled(false);
        } else {
            this.printButton.setEnabled(true);
        }
    }

    protected boolean onZoomIn() {
        double scale = 0.0;
        boolean rc = false;
        for (int k = this.scales.length - 1; k >= 0; --k) {
            String s = this.scalesBox.getItemAt(k).toString();
            if (s.endsWith("%")) {
                s = s.substring(0, s.length() - 1);
            }
            s = s.trim();
            try {
                scale = Double.valueOf(s) / 100.0;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            if (!(scale > this.scale)) continue;
            this.scalesBox.setSelectedIndex(k);
            rc = true;
            break;
        }
        if (!rc) {
            this.scalesBox.setSelectedIndex(this.scales.length - 1);
        }
        return rc;
    }

    protected boolean onZoomOut() {
        double scale = 1.0;
        boolean rc = false;
        for (int k = 0; k < this.scales.length; ++k) {
            String s = this.scalesBox.getItemAt(k).toString();
            if (s.endsWith("%")) {
                s = s.substring(0, s.length() - 1);
            }
            s = s.trim();
            try {
                scale = Double.valueOf(s) / 100.0;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            if (!(scale < this.scale)) continue;
            this.scalesBox.setSelectedIndex(k);
            rc = true;
            break;
        }
        return rc;
    }

    protected void onUpdateScales() {
        String s = this.scalesBox.getSelectedItem().toString();
        if (s.endsWith("%")) {
            s = s.substring(0, s.length() - 1);
        }
        s = s.trim();
        try {
            this.scale = Double.valueOf(s) / 100.0;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (this.scale <= 0.0) {
            return;
        }
        this.previewPane.setScale(this.scale);
        this.zoomOutButton.setEnabled(this.scale > (double)this.scales[this.scales.length - 1] / 100.0);
        this.zoomInButton.setEnabled(this.scale < (double)this.scales[0] / 100.0);
    }

    protected void onFitIn() {
        this.scale = this.previewPane.getFitInScale();
        if (this.scale >= 0.0) {
            long scaleRounded = Math.round(this.scale * 10000.0);
            String s = Double.toString((double)scaleRounded / 100.0).concat("%");
            this.scalesBox.setSelectedItem(s);
        }
    }

    void removeAllComponents(Container cont) {
        Component[] comps = cont.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            Component comp = comps[i];
            if (comp == null) continue;
            if (comp instanceof Container) {
                this.removeAllComponents((Container)comp);
            }
            comp.removeNotify();
            cont.remove(comp);
        }
        if (cont instanceof Window) {
            ((Window)cont).dispose();
        }
    }

    public TSEPrintPreviewPane getPreviewPane() {
        return this.previewPane;
    }

    public JToolBar getToolBar() {
        return this.toolBar;
    }

    public TSEPrintSetup getPrintSetup() {
        return this.previewPane.getPrintSetup();
    }

    public void setPrintSetup(TSEPrintSetup printSetup, boolean rebuild, boolean fitIn) {
        this.previewPane.setPrintSetup(printSetup, rebuild, fitIn);
        this.zoomTool.registerListeners();
    }

    private void setAccessibleProperties() {
        this.setAccessibleProperties(this.printButton, null, "ACSD_Print");
        this.setAccessibleProperties(this.printSetupButton, null, "ACSD_Print_Setup");
        this.setAccessibleProperties(this.zoomInButton, null, "ACSD_Zoom_In");
        this.setAccessibleProperties(this.zoomOutButton, null, "ACSD_Zoom_Out");
        this.setAccessibleProperties(this.scalesBox, "ACSN_Zoom_Percentage", "ACSD_Zoom_Percentage");
        this.setAccessibleProperties(this.fitInButton, null, "ACSD_Fit_In_Window");
        this.setAccessibleProperties(this.closeButton, null, "ACSD_Close");
    }

    protected void setAccessibleProperties(Component comp, String accsNameKey, String accsDescKey) {
        if (comp != null) {
            String labelStr = null;
            AccessibleContext accsContext = comp.getAccessibleContext();
            if (accsNameKey != null) {
                labelStr = this.labels.getStringSafely(accsNameKey);
                accsContext.setAccessibleName(labelStr);
            }
            if (accsDescKey != null) {
                labelStr = this.labels.getStringSafely(accsDescKey);
                accsContext.setAccessibleDescription(labelStr);
            }
        }
    }

    class PrintPreviewAdapter
    implements WindowListener {
        PrintPreviewAdapter() {
        }

        public void windowActivated(WindowEvent e) {
        }

        public void windowClosed(WindowEvent e) {
        }

        public void windowClosing(WindowEvent e) {
        }

        public void windowDeactivated(WindowEvent e) {
        }

        public void windowDeiconified(WindowEvent e) {
        }

        public void windowIconified(WindowEvent e) {
        }

        public void windowOpened(WindowEvent e) {
            TSEPrintPreviewWindow.this.onFitIn();
        }
    }
}

