/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editor.export;

import com.tomsawyer.drawing.geometry.TSRect;
import com.tomsawyer.editor.TSEFont;
import com.tomsawyer.editor.TSEGraphWindow;
import com.tomsawyer.util.f2;
import java.awt.Color;
import java.util.Enumeration;
import java.util.Vector;

public abstract class TSEMultiPageExportSetup
implements Cloneable {
    public static final int ENTIRE_GRAPH = 1;
    public static final int CURRENT_WINDOW = 2;
    public static final int CURRENT_SELECTION = 3;
    public static final int SCALE_BY_PAGES = 4;
    public static final int ACTUAL_SIZE = 5;
    public static final int ZOOM_LEVEL = 6;
    public static final int TOP_LEFT = 7;
    public static final int TOP_RIGHT = 8;
    public static final int BOTTOM_LEFT = 9;
    public static final int BOTTOM_RIGHT = 10;
    int exportRange;
    int exportScale;
    int pageColumns;
    int pageRows;
    boolean exportCaption;
    int captionPosition;
    TSEFont captionFont;
    boolean exportBorder;
    Color borderColor;
    boolean exportPageNumber;
    boolean exportCropMark;
    double cropMarkLength;
    boolean exportBackground;
    boolean exportGrid;
    Vector caption;
    TSEGraphWindow graphWindow;

    public TSEMultiPageExportSetup(TSEGraphWindow tSEGraphWindow) {
        f2.a(f2.a2);
        this.graphWindow = tSEGraphWindow;
        this.setDefaults();
    }

    protected TSEMultiPageExportSetup() {
        this.setDefaults();
    }

    public TSEGraphWindow getGraphWindow() {
        return this.graphWindow;
    }

    public void setGraphWindow(TSEGraphWindow tSEGraphWindow) {
        this.graphWindow = tSEGraphWindow;
    }

    public Object clone() {
        try {
            TSEMultiPageExportSetup tSEMultiPageExportSetup = (TSEMultiPageExportSetup)super.clone();
            tSEMultiPageExportSetup.copy(this);
            return tSEMultiPageExportSetup;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.getMessage());
        }
    }

    public void copy(Object object) {
        if (!(object instanceof TSEMultiPageExportSetup)) {
            throw new ClassCastException(object.getClass().getName());
        }
        TSEMultiPageExportSetup tSEMultiPageExportSetup = (TSEMultiPageExportSetup)object;
        this.setGraphWindow(tSEMultiPageExportSetup.getGraphWindow());
        this.setExportRange(tSEMultiPageExportSetup.getExportRange());
        this.setExportScale(tSEMultiPageExportSetup.getExportScale());
        this.setCaptionExported(tSEMultiPageExportSetup.isCaptionExported());
        this.setCaptionFont(new TSEFont(tSEMultiPageExportSetup.getCaptionFont()));
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = tSEMultiPageExportSetup.getCaption().elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            vector.addElement(string);
        }
        this.setCaption(vector);
        this.setCaptionPosition(tSEMultiPageExportSetup.getCaptionPosition());
        this.setBorderExported(tSEMultiPageExportSetup.isBorderExported());
        this.setBorderColor(tSEMultiPageExportSetup.getBorderColor());
        this.setPageNumberExported(tSEMultiPageExportSetup.isPageNumberExported());
        this.setCropMarkExported(tSEMultiPageExportSetup.isCropMarkExported());
        this.setCropMarkLength(tSEMultiPageExportSetup.getCropMarkLength());
        this.setBackgroundExported(tSEMultiPageExportSetup.isBackgroundExported());
        this.setGridExported(tSEMultiPageExportSetup.isGridExported());
    }

    public abstract void setDefaults();

    public void setExportRange(int n) {
        this.exportRange = n;
    }

    public int getExportRange() {
        return this.exportRange;
    }

    public void setExportScale(int n) {
        this.exportScale = n;
    }

    public int getExportScale() {
        return this.exportScale;
    }

    public int getPageColumns() {
        int n = 1;
        if (this.getExportScale() == 4) {
            n = this.pageColumns;
        } else {
            double d = 1.0;
            if (this.getExportScale() == 5) {
                d = 1.0;
            } else if (this.getExportScale() == 6) {
                d = this.graphWindow.getZoomLevel();
            }
            if (this.getExportRange() == 1) {
                int n2;
                n = n2 = (int)Math.ceil(this.graphWindow.getGraph().getFrameBounds().getWidth() * d / this.getImageableWidth());
            } else if (this.getExportRange() == 2) {
                int n3;
                n = n3 = (int)Math.ceil(this.graphWindow.getTransform().getWorldBounds().getWidth() * d / this.getImageableWidth());
            } else if (this.getExportRange() == 3) {
                TSRect tSRect = this.graphWindow.getGraphManager().getSelectedObjectsBounds();
                int n4 = tSRect != null ? (int)Math.ceil(tSRect.getWidth() * d / this.getImageableWidth()) : 0;
                n = n4;
            } else {
                n = 1;
            }
        }
        if (n > 1) {
            f2.a(f2.ba);
        }
        return n;
    }

    public int getPageRows() {
        int n = 1;
        if (this.getExportScale() == 4) {
            n = this.pageRows;
        } else {
            double d = 1.0;
            if (this.getExportScale() == 5) {
                d = 1.0;
            } else if (this.getExportScale() == 6) {
                d = this.graphWindow.getZoomLevel();
            }
            if (this.getExportRange() == 1) {
                int n2;
                n = n2 = (int)Math.ceil(this.graphWindow.getGraph().getFrameBounds().getHeight() * d / this.getImageableHeight());
            } else if (this.getExportRange() == 2) {
                int n3;
                n = n3 = (int)Math.ceil(this.graphWindow.getTransform().getWorldBounds().getHeight() * d / this.getImageableHeight());
            } else if (this.getExportRange() == 3) {
                TSRect tSRect = this.graphWindow.getGraphManager().getSelectedObjectsBounds();
                int n4 = tSRect != null ? (int)Math.ceil(tSRect.getHeight() * d / this.getImageableHeight()) : 0;
                n = n4;
            } else {
                n = 1;
            }
        }
        if (n > 1) {
            f2.a(f2.ba);
        }
        return n;
    }

    public void setPageColumns(int n) {
        this.pageColumns = n;
    }

    public void setPageRows(int n) {
        this.pageRows = n;
    }

    public Vector getCaption() {
        return this.caption;
    }

    public void setCaption(Vector vector) {
        this.caption = vector;
    }

    public void setCaptionPosition(int n) {
        this.captionPosition = n;
    }

    public int getCaptionPosition() {
        return this.captionPosition;
    }

    public TSEFont getCaptionFont() {
        return this.captionFont;
    }

    public void setCaptionFont(TSEFont tSEFont) {
        this.captionFont = tSEFont;
    }

    public void setBorderColor(Color color) {
        this.borderColor = color;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setCropMarkLength(double d) {
        this.cropMarkLength = d;
    }

    public double getCropMarkLength() {
        return this.cropMarkLength;
    }

    public abstract double getTopMargin();

    public abstract double getBottomMargin();

    public abstract double getLeftMargin();

    public abstract double getRightMargin();

    public abstract double getWidth();

    public abstract double getHeight();

    public abstract double getImageableWidth();

    public abstract double getImageableHeight();

    public abstract double getImageableX();

    public abstract double getImageableY();

    public void setCaptionExported(boolean bl) {
        this.exportCaption = bl;
    }

    public boolean isCaptionExported() {
        return this.exportCaption;
    }

    public void setBorderExported(boolean bl) {
        this.exportBorder = bl;
    }

    public boolean isBorderExported() {
        return this.exportBorder;
    }

    public void setPageNumberExported(boolean bl) {
        this.exportPageNumber = bl;
    }

    public boolean isPageNumberExported() {
        return this.exportPageNumber;
    }

    public void setCropMarkExported(boolean bl) {
        this.exportCropMark = bl;
    }

    public boolean isCropMarkExported() {
        return this.exportCropMark;
    }

    public void setBackgroundExported(boolean bl) {
        this.exportBackground = bl;
    }

    public boolean isBackgroundExported() {
        return this.exportBackground;
    }

    public void setGridExported(boolean bl) {
        this.exportGrid = bl;
    }

    public boolean isGridExported() {
        return this.exportGrid;
    }
}

