/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editor.export;

import com.tomsawyer.drawing.geometry.TSRect;
import com.tomsawyer.editor.TSEGraphWindow;
import com.tomsawyer.editor.export.TSEMultiPageExportSetup;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Toolkit;

public class TSEImageExportSetup
extends TSEMultiPageExportSetup {
    double topMargin;
    double bottomMargin;
    double leftMargin;
    double rightMargin;
    Dimension pageDimension;

    public TSEImageExportSetup(TSEGraphWindow tSEGraphWindow) {
        super(tSEGraphWindow);
    }

    protected TSEImageExportSetup() {
    }

    public void copy(Object object) {
        super.copy(object);
        if (!(object instanceof TSEImageExportSetup)) {
            throw new ClassCastException(object.getClass().getName());
        }
        TSEImageExportSetup tSEImageExportSetup = (TSEImageExportSetup)object;
        this.setPageDimension(new Dimension(tSEImageExportSetup.getPageDimension()));
        this.setTopMargin(tSEImageExportSetup.getTopMargin());
        this.setBottomMargin(tSEImageExportSetup.getBottomMargin());
        this.setLeftMargin(tSEImageExportSetup.getLeftMargin());
        this.setRightMargin(tSEImageExportSetup.getRightMargin());
    }

    public void setDefaults() {
        this.setExportRange(1);
        this.setExportScale(4);
        this.setPageColumns(1);
        this.setPageRows(1);
        this.setCaptionExported(false);
        this.setBorderExported(false);
        this.setPageNumberExported(false);
        this.setCropMarkExported(false);
        this.setBackgroundExported(false);
        this.setGridExported(false);
        this.setPageDimension(new Dimension(612, 792));
        this.setTopMargin(0.0);
        this.setBottomMargin(0.0);
        this.setLeftMargin(0.0);
        this.setRightMargin(0.0);
    }

    public double getTopMargin() {
        return this.topMargin;
    }

    public double getBottomMargin() {
        return this.bottomMargin;
    }

    public double getLeftMargin() {
        return this.leftMargin;
    }

    public double getRightMargin() {
        return this.rightMargin;
    }

    public void setTopMargin(double d) {
        this.topMargin = d;
    }

    public void setBottomMargin(double d) {
        this.bottomMargin = d;
    }

    public void setLeftMargin(double d) {
        this.leftMargin = d;
    }

    public void setRightMargin(double d) {
        this.rightMargin = d;
    }

    public Dimension getPageDimension() {
        return this.pageDimension;
    }

    public void setPageDimension(Dimension dimension) {
        if (dimension != null) {
            this.pageDimension = dimension;
        } else {
            TSRect tSRect;
            if (this.getExportScale() == 4) {
                this.setExportScale(5);
            }
            double d = 1.0;
            if (this.getExportScale() == 5) {
                d = 1.0;
            } else if (this.getExportScale() == 6) {
                d = this.graphWindow.getZoomLevel();
            }
            if (this.getExportRange() == 1) {
                double d2 = this.graphWindow.getGraph().getFrameBounds().getHeight() * d + this.getTopMargin() + this.getBottomMargin();
                double d3 = this.graphWindow.getGraph().getFrameBounds().getWidth() * d + this.getLeftMargin() + this.getBottomMargin();
                this.pageDimension = new Dimension((int)Math.ceil(d3), (int)Math.ceil(d2));
            } else if (this.getExportRange() == 2) {
                double d4 = this.graphWindow.getTransform().getWorldBounds().getHeight() * d + this.getTopMargin() + this.getBottomMargin();
                double d5 = this.graphWindow.getTransform().getWorldBounds().getWidth() * d + this.getLeftMargin() + this.getRightMargin();
                this.pageDimension = new Dimension((int)Math.ceil(d5), (int)Math.ceil(d4));
            } else if (this.getExportRange() == 3 && (tSRect = this.graphWindow.getGraphManager().getSelectedObjectsBounds()) != null) {
                double d6 = this.graphWindow.getGraphManager().getSelectedObjectsBounds().getHeight() * d + this.getTopMargin() + this.getBottomMargin();
                double d7 = this.graphWindow.getGraphManager().getSelectedObjectsBounds().getWidth() * d + this.getLeftMargin() + this.getRightMargin();
                this.pageDimension = new Dimension((int)Math.ceil(d7), (int)Math.ceil(d6));
            }
        }
    }

    public double getWidth() {
        return this.pageDimension.width;
    }

    public double getHeight() {
        return this.pageDimension.height;
    }

    public double getImageableWidth() {
        return (double)this.pageDimension.width - this.leftMargin - this.rightMargin;
    }

    public double getImageableHeight() {
        if (this.isCaptionExported()) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            FontMetrics fontMetrics = toolkit.getFontMetrics(this.captionFont.getFont());
            int n = fontMetrics.getHeight();
            int n2 = this.caption.size();
            return (double)this.pageDimension.height - this.topMargin - this.bottomMargin - (double)(n2 * n) - 5.0;
        }
        return (double)this.pageDimension.height - this.topMargin - this.bottomMargin;
    }

    public double getImageableX() {
        return this.leftMargin;
    }

    public double getImageableY() {
        block2: {
            block3: {
                if (!this.isCaptionExported()) break block2;
                if (this.getCaptionPosition() == 7) break block3;
                if (this.getCaptionPosition() != 8) break block2;
            }
            int n = this.captionFont.getFont().getSize();
            int n2 = this.caption.size();
            return this.topMargin + (double)(n2 * n) + 5.0;
        }
        return this.topMargin;
    }
}

