/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editor.export;

import com.keypoint.PngEncoder;
import com.lowagie.text.Document;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import com.sun.image.codec.jpeg.ImageFormatException;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import com.tomsawyer.editor.export.TSEExportData;
import com.tomsawyer.editor.export.TSEImageExportSetup;
import com.tomsawyer.util.f2;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGraphics2D;
import org.w3c.dom.DOMImplementation;

public class TSEImageExport {
    TSEImageExportSetup exportSetup;
    TSEExportData exportData;
    static /* synthetic */ Class class$com$lowagie$text$Rectangle;
    static /* synthetic */ Class class$java$lang$String;

    public TSEImageExport(TSEImageExportSetup tSEImageExportSetup) {
        f2.a(f2.a6);
        this.exportSetup = tSEImageExportSetup;
        this.exportData = this.newExportData();
    }

    protected TSEExportData newExportData() {
        return new TSEExportData(this.exportSetup);
    }

    public boolean writeJPEGFormat(OutputStream outputStream, int n) throws IOException, ImageFormatException {
        return this.writeJPEGFormat(outputStream, 0.75f, n);
    }

    public boolean writeJPEGFormat(OutputStream outputStream, float f, int n) throws IOException, ImageFormatException {
        BufferedImage bufferedImage = new BufferedImage((int)this.exportSetup.getWidth(), (int)this.exportSetup.getHeight(), 1);
        Graphics graphics = bufferedImage.getGraphics();
        Color color = graphics.getColor();
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        graphics.setColor(color);
        boolean bl = this.exportData.renderGraphics(graphics, n);
        JPEGImageEncoder jPEGImageEncoder = JPEGCodec.createJPEGEncoder((OutputStream)outputStream);
        JPEGEncodeParam jPEGEncodeParam = this.getJPEGEncodeParameters();
        if (jPEGEncodeParam == null) {
            jPEGEncodeParam = jPEGImageEncoder.getDefaultJPEGEncodeParam(bufferedImage);
        }
        jPEGEncodeParam.setQuality(f, false);
        jPEGImageEncoder.setJPEGEncodeParam(jPEGEncodeParam);
        if (bufferedImage != null) {
            jPEGImageEncoder.encode(bufferedImage);
        }
        return bl;
    }

    public JPEGEncodeParam getJPEGEncodeParameters() {
        return null;
    }

    public boolean writeSVGFormat(OutputStream outputStream, int n) throws IOException {
        boolean bl = false;
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "UTF-8");
        DOMImplementation dOMImplementation = GenericDOMImplementation.getDOMImplementation();
        org.w3c.dom.Document document = dOMImplementation.createDocument(null, "svg", null);
        SVGGraphics2D sVGGraphics2D = new SVGGraphics2D(document);
        sVGGraphics2D.setSVGCanvasSize(new Dimension((int)this.exportSetup.getWidth(), (int)this.exportSetup.getHeight()));
        String string = System.getProperty("useCss", "true");
        boolean bl2 = string.equalsIgnoreCase("true");
        bl = this.exportData.renderGraphics((Graphics)sVGGraphics2D, n);
        if (outputStreamWriter != null) {
            sVGGraphics2D.stream((Writer)outputStreamWriter, bl2);
        }
        ((Writer)outputStreamWriter).close();
        return bl;
    }

    public boolean writeGIFFormat(OutputStream outputStream, int n) throws IOException, ImageFormatException {
        return false;
    }

    public boolean writePNGFormat(OutputStream outputStream, int n, boolean bl, int n2, int n3) throws IOException, ImageFormatException {
        BufferedImage bufferedImage = new BufferedImage((int)this.exportSetup.getWidth(), (int)this.exportSetup.getHeight(), 1);
        Graphics graphics = bufferedImage.getGraphics();
        Color color = graphics.getColor();
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        graphics.setColor(color);
        boolean bl2 = false;
        bl2 = this.exportData.renderGraphics(graphics, n);
        byte[] byArray = null;
        PngEncoder pngEncoder = new PngEncoder((Image)bufferedImage, bl, n2, n3);
        byArray = pngEncoder.pngEncode();
        if (byArray == null) {
            System.out.println("Null image");
        } else {
            outputStream.write(byArray);
        }
        return bl2;
    }

    public boolean writePNGFormat(OutputStream outputStream, int n) throws IOException, ImageFormatException {
        return this.writePNGFormat(outputStream, n, false, 0, 3);
    }

    public boolean writePDFFormat(OutputStream outputStream, int n) throws IOException {
        int n2;
        boolean bl = false;
        if (outputStream == null) {
            return bl;
        }
        int n3 = (int)this.exportSetup.getWidth();
        Object object = this.createPDFDocument(n3, n2 = (int)this.exportSetup.getHeight());
        if (object == null) {
            return bl;
        }
        Document document = (Document)object;
        try {
            PdfWriter pdfWriter = PdfWriter.getInstance((Document)document, (OutputStream)outputStream);
            document.open();
            PdfContentByte pdfContentByte = pdfWriter.getDirectContent();
            PdfTemplate pdfTemplate = pdfContentByte.createTemplate((float)n3, (float)n2);
            Graphics2D graphics2D = pdfTemplate.createGraphics((float)n3, (float)n2);
            bl = this.exportData.renderGraphics(graphics2D, n);
            graphics2D.dispose();
            pdfContentByte.addTemplate(pdfTemplate, 0.0f, 0.0f);
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
        document.close();
        return bl;
    }

    public Object createPDFDocument(int n, int n2) {
        Object obj;
        Executable executable;
        Class<?> clazz;
        try {
            clazz = Class.forName("com.lowagie.text.Document");
            executable = clazz.getConstructor(class$com$lowagie$text$Rectangle == null ? (class$com$lowagie$text$Rectangle = TSEImageExport.class$("com.lowagie.text.Rectangle")) : class$com$lowagie$text$Rectangle);
            obj = ((Constructor)executable).newInstance(new Rectangle((float)n, (float)n2));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        try {
            executable = clazz.getMethod("addAuthor", class$java$lang$String == null ? (class$java$lang$String = TSEImageExport.class$("java.lang.String")) : class$java$lang$String);
            Method method = clazz.getMethod("addCreator", class$java$lang$String == null ? (class$java$lang$String = TSEImageExport.class$("java.lang.String")) : class$java$lang$String);
            Boolean bl = (Boolean)((Method)executable).invoke(obj, "Tom Sawyer Software");
            bl = (Boolean)method.invoke(obj, "Tom Sawyer Visualization");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        return obj;
    }

    public TSEImageExportSetup getExportSetup() {
        return this.exportSetup;
    }

    public TSEExportData getExportData() {
        return this.exportData;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

