/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editor.complexity.command;

import com.tomsawyer.complexity.TSNestingManager;
import com.tomsawyer.complexity.command.TSUnfoldCommand;
import com.tomsawyer.complexity.event.TSComplexityChangeEvent;
import com.tomsawyer.complexity.event.TSComplexityChangeEventData;
import com.tomsawyer.diagramming.command.cs;
import com.tomsawyer.drawing.TSDGraph;
import com.tomsawyer.drawing.TSDGraphManager;
import com.tomsawyer.drawing.TSDNode;
import com.tomsawyer.drawing.geometry.TSPoint;
import com.tomsawyer.editor.TSEEdge;
import com.tomsawyer.editor.TSEGraph;
import com.tomsawyer.editor.TSEGraphManager;
import com.tomsawyer.editor.TSEGraphWindow;
import com.tomsawyer.editor.TSENode;
import com.tomsawyer.editor.complexity.TSEFoldingManager;
import com.tomsawyer.graph.TSEdge;
import com.tomsawyer.graph.TSGraphObject;
import com.tomsawyer.util.TSSystem;
import com.tomsawyer.util.command.TSCommand;
import com.tomsawyer.util.command.TSGroupCommand;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;

public class TSEUnfoldCommand
extends TSUnfoldCommand {
    TSENode folder;
    List nodeList;
    TSGroupCommand groupUnfoldCommand;
    boolean compressMetaEdges;
    boolean isChildCommand;
    TSPoint oldCenter;
    boolean updateMetaEdges;
    List removedMetaEdges;
    List insertedMetaEdges;
    TSEGraphManager graphManager;
    TSEGraph startGraph;
    boolean deep;
    boolean allFolders;
    cs adjustmentCommand;
    boolean geometricAdjustment = false;

    public TSEUnfoldCommand(TSEGraph tSEGraph, boolean bl) {
        this(tSEGraph, bl, false);
    }

    public TSEUnfoldCommand(TSEGraph tSEGraph, boolean bl, boolean bl2) {
        this.folder = null;
        this.nodeList = null;
        this.oldCenter = null;
        this.groupUnfoldCommand = new TSGroupCommand();
        this.setChildCommand(false);
        this.graphManager = (TSEGraphManager)tSEGraph.getOwnerGraphManager();
        this.startGraph = tSEGraph;
        this.deep = bl;
        this.allFolders = bl2;
        this.updateMetaEdges = true;
        this.insertedMetaEdges = null;
        this.removedMetaEdges = null;
    }

    public TSEUnfoldCommand(TSENode tSENode) {
        this.folder = null;
        this.nodeList = null;
        this.oldCenter = null;
        this.setChildCommand(false);
        this.startGraph = null;
        this.deep = false;
        this.allFolders = true;
        if (tSENode != null && tSENode.isFolderNode()) {
            this.folder = tSENode;
        }
        this.graphManager = (TSEGraphManager)tSENode.getOwnerGraphManager();
        this.updateMetaEdges = true;
        this.insertedMetaEdges = null;
        this.removedMetaEdges = null;
    }

    public TSEUnfoldCommand(List list) {
        TSSystem.tsAssert(list != null && list.size() > 0);
        this.folder = null;
        this.setChildCommand(false);
        this.startGraph = null;
        this.deep = false;
        this.allFolders = true;
        this.groupUnfoldCommand = new TSGroupCommand();
        Iterator iterator = list.iterator();
        TSGraphObject tSGraphObject = null;
        while (iterator.hasNext()) {
            tSGraphObject = (TSENode)iterator.next();
            if (!((TSDNode)tSGraphObject).isFolderNode()) continue;
            TSEUnfoldCommand tSEUnfoldCommand = new TSEUnfoldCommand((TSENode)tSGraphObject);
            tSEUnfoldCommand.setChildCommand(true);
            tSEUnfoldCommand.setUpdateMetaEdges(false);
            this.groupUnfoldCommand.add(tSEUnfoldCommand);
        }
        this.graphManager = (TSEGraphManager)tSGraphObject.getOwnerGraphManager();
        this.updateMetaEdges = true;
        this.insertedMetaEdges = null;
        this.removedMetaEdges = null;
    }

    protected void init() {
        if (this.folder != null && this.folder.isFolderNode()) {
            this.compressMetaEdges = ((TSEGraphManager)this.folder.getOwner().getOwner()).getCompressMetaEdges();
            if (this.folder.getChildGraph() != null) {
                this.nodeList = new Vector(this.folder.getChildGraph().nodes());
            }
        } else if (this.startGraph != null) {
            Vector<Object> vector = new Vector<Object>();
            TSEGraph tSEGraph = this.startGraph;
            vector.add(tSEGraph);
            this.nodeList = new Vector();
            if (this.deep) {
                TSNestingManager.buildAllNestedGraphList(tSEGraph, vector, false);
            }
            while (!vector.isEmpty()) {
                TSEGraph tSEGraph2 = (TSEGraph)vector.remove(0);
                Iterator iterator = this.allFolders ? tSEGraph2.nodes().iterator() : tSEGraph2.selectedNodes().iterator();
                while (iterator.hasNext()) {
                    Object object;
                    TSENode tSENode = (TSENode)iterator.next();
                    if (!tSENode.isFolderNode()) continue;
                    if (this.allFolders && tSENode.getChildGraph() != null && !TSNestingManager.isNested((TSEGraph)tSENode.getChildGraph())) {
                        object = (TSEGraph)tSENode.getChildGraph();
                        vector.add(object);
                        TSNestingManager.buildAllNestedGraphList((TSDGraph)object, vector, false);
                    }
                    object = new TSEUnfoldCommand(tSENode);
                    this.nodeList.add(tSENode);
                    ((TSUnfoldCommand)object).setChildCommand(true);
                    ((TSEUnfoldCommand)object).setUpdateMetaEdges(false);
                    this.groupUnfoldCommand.add((TSCommand)object);
                }
            }
        }
        this.geometricAdjustment = ((TSEFoldingManager)TSEFoldingManager.getManager(this.graphManager)).isUsingGeometricAdjustment();
        if (this.geometricAdjustment) {
            this.adjustmentCommand = new cs(this.graphManager, this.nodeList, 3);
        }
    }

    protected void doAction() throws Throwable {
        if (this.folder != null) {
            TSEGraph tSEGraph = (TSEGraph)this.folder.getOwnerGraph();
            TSEFoldingManager tSEFoldingManager = (TSEFoldingManager)TSEFoldingManager.getManager((TSEGraphManager)tSEGraph.getOwner());
            this.oldCenter = new TSPoint(this.folder.getLocalCenter());
            if (tSEGraph.fireEvent(new TSComplexityChangeEvent(16L, new TSComplexityChangeEventData(this.folder, null, null)), true)) {
                Object object;
                Object object2;
                tSEFoldingManager.unfold(this.folder, true);
                tSEGraph.remove(this.folder);
                if (((TSEGraph)this.folder.getChildGraph()).isSelected()) {
                    ((TSEGraph)this.graphManager.getMainDisplayGraph()).setSelected(true);
                }
                this.graphManager.remove(this.folder.getChildGraph());
                if (!this.isChildCommand() && (object2 = this.getGraphWindow()) != null) {
                    ((TSEGraphWindow)object2).deselectAll(false);
                }
                this.nodeList = new LinkedList();
                this.nodeList.addAll(tSEFoldingManager.getResultNodeList());
                object2 = tSEFoldingManager.getResultEdgeList().iterator();
                while (object2.hasNext()) {
                    object = (TSEEdge)object2.next();
                    ((TSEEdge)object).setSelected(true);
                    ((TSEEdge)object).setLabelsSelected(true);
                }
                object = this.nodeList.iterator();
                while (object.hasNext()) {
                    TSENode tSENode = (TSENode)object.next();
                    tSENode.setSelected(true);
                    tSENode.setLabelsSelected(true);
                    tSENode.setConnectorLabelsSelected(true);
                }
            } else {
                this.setAddToUndoStack(false);
            }
            tSEFoldingManager.clearResultLists();
        } else if (this.groupUnfoldCommand != null) {
            TSEGraphWindow tSEGraphWindow;
            if (!this.isChildCommand() && (tSEGraphWindow = this.getGraphWindow()) != null) {
                tSEGraphWindow.deselectAll(false);
            }
            this.groupUnfoldCommand.execute();
        }
        if (this.updateMetaEdges) {
            this.insertedMetaEdges = new Vector();
            this.removedMetaEdges = new Vector();
            this.graphManager.checkMetaEdges(this.insertedMetaEdges, this.removedMetaEdges);
            this.graphManager.updateMetaEdges(this.insertedMetaEdges, this.removedMetaEdges, this.insertedMetaEdges);
        }
        if (this.geometricAdjustment) {
            this.adjustmentCommand.a(this.nodeList);
            this.adjustmentCommand.execute();
        }
    }

    protected void redoAction() throws Throwable {
        TSGraphObject tSGraphObject;
        Iterator iterator;
        if (this.folder != null) {
            Object object;
            Object object2;
            iterator = (TSEGraph)this.folder.getOwnerGraph();
            tSGraphObject = (TSEGraphManager)((TSGraphObject)((Object)iterator)).getOwner();
            TSEFoldingManager tSEFoldingManager = (TSEFoldingManager)TSEFoldingManager.getManager((TSDGraphManager)tSGraphObject);
            tSEFoldingManager.unfold(this.folder, true);
            this.graphManager.remove(this.folder.getChildGraph());
            ((TSDGraph)((Object)iterator)).remove(this.folder);
            if (this.nodeList == null) {
                this.nodeList = new LinkedList();
            }
            this.nodeList.addAll(tSEFoldingManager.getResultNodeList());
            if (!this.isChildCommand() && (object2 = this.getGraphWindow()) != null) {
                ((TSEGraphWindow)object2).deselectAll(false);
            }
            object2 = tSEFoldingManager.getResultEdgeList().iterator();
            while (object2.hasNext()) {
                object = (TSEEdge)object2.next();
                ((TSEEdge)object).setSelected(true);
                ((TSEEdge)object).setLabelsSelected(true);
            }
            object = this.nodeList.iterator();
            while (object.hasNext()) {
                TSENode tSENode = (TSENode)object.next();
                tSENode.setSelected(true);
                tSENode.setLabelsSelected(true);
                tSENode.setConnectorLabelsSelected(true);
            }
            tSEFoldingManager.clearResultLists();
        } else if (this.groupUnfoldCommand != null) {
            if (!this.isChildCommand() && (iterator = this.getGraphWindow()) != null) {
                ((TSEGraphWindow)((Object)iterator)).deselectAll(false);
            }
            this.groupUnfoldCommand.redo();
        }
        if (this.updateMetaEdges) {
            iterator = this.insertedMetaEdges.iterator();
            while (iterator.hasNext()) {
                tSGraphObject = (TSEEdge)iterator.next();
                ((TSEdge)tSGraphObject).getOwnerGraph().insert((TSEdge)tSGraphObject);
            }
            iterator = this.removedMetaEdges.iterator();
            while (iterator.hasNext()) {
                tSGraphObject = (TSEEdge)iterator.next();
                this.graphManager.remove((TSEdge)tSGraphObject);
            }
        }
        if (this.geometricAdjustment) {
            this.adjustmentCommand.redo();
        }
    }

    protected void undoAction() throws Throwable {
        TSGraphObject tSGraphObject;
        Object object;
        if (this.geometricAdjustment) {
            this.adjustmentCommand.undo();
        }
        if (this.updateMetaEdges) {
            object = this.insertedMetaEdges.iterator();
            while (object.hasNext()) {
                tSGraphObject = (TSEEdge)object.next();
                this.graphManager.remove((TSEdge)tSGraphObject);
            }
            object = this.removedMetaEdges.iterator();
            while (object.hasNext()) {
                tSGraphObject = (TSEEdge)object.next();
                ((TSEdge)tSGraphObject).getOwnerGraph().insert((TSEdge)tSGraphObject);
            }
        }
        if (this.folder != null) {
            TSEGraphWindow tSEGraphWindow;
            object = (TSEGraph)this.folder.getOwner();
            tSGraphObject = (TSEGraphManager)((TSGraphObject)object).getOwner();
            ((TSDGraph)object).insert(this.folder);
            TSEFoldingManager tSEFoldingManager = (TSEFoldingManager)TSEFoldingManager.getManager((TSDGraphManager)tSGraphObject);
            tSEFoldingManager.fold(this.folder, (TSEGraph)this.folder.getChildGraph(), this.nodeList, true);
            this.folder.setLocalCenter(this.oldCenter);
            if (!this.isChildCommand() && (tSEGraphWindow = this.getGraphWindow()) != null) {
                tSEGraphWindow.deselectAll(false);
            }
            this.folder.setSelected(true);
            tSEFoldingManager.clearResultLists();
        } else if (this.groupUnfoldCommand != null) {
            if (!this.isChildCommand() && (object = this.getGraphWindow()) != null) {
                ((TSEGraphWindow)object).deselectAll(false);
            }
            this.groupUnfoldCommand.undo();
        }
    }

    TSEGraphWindow getGraphWindow() {
        if (this.folder != null) {
            TSEGraph tSEGraph = (TSEGraph)this.folder.getOwnerGraph();
            if (tSEGraph != null) {
                return ((TSEGraphManager)tSEGraph.getOwner()).getGraphWindow();
            }
        } else if (this.groupUnfoldCommand != null && !this.groupUnfoldCommand.getCommandList().isEmpty()) {
            return ((TSEUnfoldCommand)this.groupUnfoldCommand.getCommandList().get(0)).getGraphWindow();
        }
        return null;
    }

    public boolean isAddToUndoStack() {
        boolean bl = super.isAddToUndoStack();
        if (this.groupUnfoldCommand != null) {
            Iterator iterator = this.groupUnfoldCommand.getCommandList().iterator();
            while (iterator.hasNext()) {
                TSCommand tSCommand = (TSCommand)iterator.next();
                bl = bl || tSCommand.isAddToUndoStack();
            }
        }
        return bl;
    }

    protected void doCleanup() {
        if (this.folder != null && !this.folder.isOwned()) {
            this.folder.dispose();
        }
        if (this.groupUnfoldCommand != null) {
            this.groupUnfoldCommand.undoCleanup();
        }
    }

    public void setUpdateMetaEdges(boolean bl) {
        this.updateMetaEdges = bl;
    }
}

