/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editor.complexity.command;

import com.tomsawyer.complexity.TSNestingManager;
import com.tomsawyer.complexity.command.TSCollapseCommand;
import com.tomsawyer.complexity.event.TSComplexityChangeEvent;
import com.tomsawyer.complexity.event.TSComplexityChangeEventData;
import com.tomsawyer.diagramming.command.cs;
import com.tomsawyer.drawing.TSDNode;
import com.tomsawyer.editor.TSEEdge;
import com.tomsawyer.editor.TSEGraph;
import com.tomsawyer.editor.TSEGraphManager;
import com.tomsawyer.editor.TSENode;
import com.tomsawyer.editor.complexity.TSENestingManager;
import com.tomsawyer.graph.TSEdge;
import com.tomsawyer.util.command.TSCommand;
import com.tomsawyer.util.df;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class TSECollapseCommand
extends TSCollapseCommand {
    boolean updateMetaEdges;
    List removedMetaEdges;
    List insertedMetaEdges;
    TSEGraphManager graphManager;
    cs adjustmentCommand;
    boolean geometricAdjustment = false;

    public TSECollapseCommand(TSEGraph tSEGraph, boolean bl) {
        this(tSEGraph, bl, false);
    }

    public TSECollapseCommand(TSEGraph tSEGraph, boolean bl, boolean bl2) {
        df df2 = new df();
        List list = this.getNodeList();
        TSENestingManager.getManager((TSEGraphManager)tSEGraph.getOwner());
        if (!bl) {
            TSNestingManager.buildNestedGraphList(tSEGraph, df2, false);
        } else {
            TSNestingManager.buildAllNestedGraphList(tSEGraph, df2, false);
        }
        Iterator iterator = df2.iterator();
        while (iterator.hasNext()) {
            TSEGraph tSEGraph2 = (TSEGraph)iterator.next();
            if (!(tSEGraph2.getParent() instanceof TSENode)) continue;
            TSENode tSENode = (TSENode)tSEGraph2.getParent();
            if ((bl2 || !tSENode.isSelected()) && !bl2) continue;
            list.add(tSENode);
        }
        if (list.size() == 0) {
            this.setAddToUndoStack(false);
        }
        this.updateMetaEdges = true;
        this.insertedMetaEdges = null;
        this.removedMetaEdges = null;
        this.graphManager = (TSEGraphManager)tSEGraph.getOwnerGraphManager();
        this.compressMetaEdges = ((TSEGraphManager)tSEGraph.getOwner()).getCompressMetaEdges();
    }

    public TSECollapseCommand(List list) {
        super(list);
        if (list.size() != 0) {
            TSEGraph tSEGraph = (TSEGraph)((TSENode)list.get(0)).getOwnerGraph();
            TSENestingManager.getManager((TSEGraphManager)tSEGraph.getOwner());
            this.graphManager = (TSEGraphManager)tSEGraph.getOwnerGraphManager();
        }
        this.updateMetaEdges = true;
        this.insertedMetaEdges = null;
        this.removedMetaEdges = null;
    }

    public TSECollapseCommand(TSDNode tSDNode) {
        super(tSDNode);
        TSENestingManager.getManager((TSEGraphManager)tSDNode.getOwnerGraph().getOwner());
        this.updateMetaEdges = true;
        this.insertedMetaEdges = null;
        this.removedMetaEdges = null;
        this.graphManager = (TSEGraphManager)tSDNode.getOwnerGraphManager();
    }

    protected void init() {
        super.init();
        this.geometricAdjustment = ((TSENestingManager)TSENestingManager.getManager(this.graphManager)).isUsingGeometricAdjustment();
        if (this.geometricAdjustment) {
            this.adjustmentCommand = new cs(this.graphManager, this.getNodeList(), 1);
        }
    }

    protected void doAction() throws Throwable {
        this.storeOldMargins();
        this.graphManager.getGraphWindow().deselectAll(false);
        Iterator iterator = this.getNodeList().iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            TSENode tSENode = (TSENode)iterator.next();
            if (!tSENode.hasChildGraph() || !tSENode.isExpanded()) continue;
            if (this.graphManager.getEventManager().fireEvent(new TSComplexityChangeEvent(2L, new TSComplexityChangeEventData(tSENode, null, null)), true)) {
                this.storeOldClippings(tSENode);
                TSENestingManager.collapse(tSENode);
                tSENode.adjustIncidentClippings();
                tSENode.setSelected(true);
                bl = true;
                continue;
            }
            iterator.remove();
        }
        if (bl && this.updateMetaEdges) {
            this.insertedMetaEdges = new Vector();
            this.removedMetaEdges = new Vector();
            this.graphManager.checkMetaEdges(this.insertedMetaEdges, this.removedMetaEdges);
            this.graphManager.updateMetaEdges(this.insertedMetaEdges, this.removedMetaEdges, this.insertedMetaEdges);
        }
        this.setAddToUndoStack(bl);
        if (this.geometricAdjustment) {
            if (this.getState() == TSCommand.CREATED) {
                this.adjustmentCommand.execute();
            } else if (this.getState() == TSCommand.UNDONE) {
                this.adjustmentCommand.redo();
            }
        }
    }

    protected void undoAction() throws Throwable {
        if (!this.getNodeList().isEmpty()) {
            Object object;
            Iterator iterator;
            if (this.geometricAdjustment) {
                this.adjustmentCommand.undo();
            }
            if (this.updateMetaEdges) {
                iterator = this.insertedMetaEdges.iterator();
                while (iterator.hasNext()) {
                    object = (TSEEdge)iterator.next();
                    this.graphManager.remove((TSEdge)object);
                }
                iterator = this.removedMetaEdges.iterator();
                while (iterator.hasNext()) {
                    object = (TSEEdge)iterator.next();
                    ((TSEdge)object).getOwnerGraph().insert((TSEdge)object);
                }
            }
            this.graphManager.getGraphWindow().deselectAll(false);
            iterator = new Vector();
            iterator.addAll(this.getNodeList());
            Collections.reverse(iterator);
            object = iterator.iterator();
            while (object.hasNext()) {
                TSENode tSENode = (TSENode)object.next();
                if (!tSENode.hasChildGraph() || tSENode.isExpanded()) continue;
                TSENestingManager.expand(tSENode);
                tSENode.setSelected(true);
            }
            this.restoreOldClippings();
            this.restoreMargins();
        }
    }

    protected void redoAction() throws Throwable {
        if (!this.getNodeList().isEmpty()) {
            boolean bl = this.updateMetaEdges;
            this.updateMetaEdges = false;
            super.redoAction();
            this.updateMetaEdges = bl;
            if (this.updateMetaEdges) {
                TSEEdge tSEEdge;
                Iterator iterator = this.insertedMetaEdges.iterator();
                while (iterator.hasNext()) {
                    tSEEdge = (TSEEdge)iterator.next();
                    tSEEdge.getOwnerGraph().insert(tSEEdge);
                }
                iterator = this.removedMetaEdges.iterator();
                while (iterator.hasNext()) {
                    tSEEdge = (TSEEdge)iterator.next();
                    this.graphManager.remove(tSEEdge);
                }
            }
        }
    }

    public void setUpdateMetaEdges(boolean bl) {
        this.updateMetaEdges = bl;
    }
}

