/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editor.complexity;

import com.tomsawyer.complexity.TSFoldingManager;
import com.tomsawyer.complexity.TSNestingManager;
import com.tomsawyer.drawing.TSDGraphManager;
import com.tomsawyer.drawing.TSDNode;
import com.tomsawyer.editor.TSEGraph;
import com.tomsawyer.editor.TSEGraphManager;
import com.tomsawyer.editor.TSEGraphWindow;
import com.tomsawyer.editor.TSENode;
import com.tomsawyer.editor.complexity.TSEHidingManager;
import com.tomsawyer.editor.ui.TSENodeUI;
import com.tomsawyer.editorx.ui.TSEImageNodeUI;
import com.tomsawyer.graph.TSGraph;
import com.tomsawyer.graph.TSGraphMember;
import com.tomsawyer.graph.TSGraphObject;
import com.tomsawyer.graph.TSNode;
import com.tomsawyer.util.TSProperty;
import java.util.Iterator;
import java.util.Vector;

public class TSEFoldingManager
extends TSFoldingManager {
    TSENodeUI folderUI;

    protected TSEFoldingManager(TSEGraphManager tSEGraphManager) {
        super(tSEGraphManager);
    }

    protected void reset() {
        this.hidingManager = TSEHidingManager.getManager(this.getGraphManager());
        super.reset();
    }

    public static boolean hasSelectedFolderNodes(TSEGraph tSEGraph) {
        boolean bl = false;
        Iterator iterator = tSEGraph.selectedNodes().iterator();
        while (!bl && iterator.hasNext()) {
            bl = TSFoldingManager.isFolderNode((TSENode)iterator.next());
        }
        return bl;
    }

    public boolean hasSelectedFolderNodes() {
        Iterator iterator = ((TSEGraphManager)this.getGraphManager()).reachableGraphList().iterator();
        while (iterator.hasNext()) {
            if (!TSEFoldingManager.hasSelectedFolderNodes((TSEGraph)iterator.next())) continue;
            return true;
        }
        return false;
    }

    public void foldSelected() {
        if (this.graphManager != null) {
            TSEGraph tSEGraph = (TSEGraph)this.graphManager.getMainDisplayGraph();
            Vector<TSEGraph> vector = new Vector<TSEGraph>();
            TSNestingManager.buildAllNestedGraphList(tSEGraph, vector, false);
            vector.add(0, tSEGraph);
            Iterator iterator = vector.iterator();
            Vector vector2 = null;
            while (iterator.hasNext()) {
                TSEGraph tSEGraph2 = (TSEGraph)iterator.next();
                vector2 = new Vector(tSEGraph2.selectedNodes());
                if (vector2.isEmpty()) continue;
                TSENode tSENode = (TSENode)tSEGraph2.addNode();
                tSENode.setSize(tSENode.getDefaultWidth(), tSENode.getDefaultHeight());
                tSENode.setTag("Folder");
                tSENode.setUI(this.getFolderUI());
                TSEGraph tSEGraph3 = (TSEGraph)this.graphManager.addGraph();
                this.fold(tSENode, tSEGraph3, vector2, true);
            }
        }
    }

    public void unfoldAll() {
        if (this.graphManager != null) {
            Object object;
            Object object2;
            Vector<TSENode> vector = new Vector<TSENode>();
            TSEGraph tSEGraph = (TSEGraph)this.graphManager.getMainDisplayGraph();
            Vector<TSEGraph> vector2 = new Vector<TSEGraph>();
            vector2.add(tSEGraph);
            TSEGraph tSEGraph2 = tSEGraph;
            TSNestingManager.buildAllNestedGraphList(tSEGraph2, vector2, false);
            while (!vector2.isEmpty()) {
                object2 = (TSEGraph)vector2.remove(0);
                object = ((TSGraph)object2).nodes().iterator();
                while (object.hasNext()) {
                    TSENode tSENode = (TSENode)object.next();
                    if (!tSENode.isFolderNode()) continue;
                    if (tSENode.getChildGraph() != null && !TSNestingManager.isNested((TSEGraph)tSENode.getChildGraph())) {
                        TSEGraph tSEGraph3 = (TSEGraph)tSENode.getChildGraph();
                        vector2.add(tSEGraph3);
                        TSNestingManager.buildAllNestedGraphList(tSEGraph3, vector2, false);
                    }
                    vector.add(tSENode);
                }
            }
            object2 = vector.iterator();
            while (object2.hasNext()) {
                object = (TSENode)object2.next();
                this.unfold((TSDNode)object, true);
                if (((TSGraphObject)object).isOwned()) {
                    ((TSNode)object).getOwnerGraph().remove((TSNode)object);
                }
                if (((TSEGraph)((TSGraphMember)object).getChildGraph()).isSelected()) {
                    ((TSEGraph)this.graphManager.getMainDisplayGraph()).setSelected(true);
                }
                this.graphManager.remove(((TSGraphMember)object).getChildGraph());
            }
        }
    }

    public void unfoldSelected() {
        if (this.graphManager != null) {
            Object object;
            Object object2;
            Vector<TSENode> vector = new Vector<TSENode>();
            TSEGraph tSEGraph = (TSEGraph)this.graphManager.getMainDisplayGraph();
            Vector<TSEGraph> vector2 = new Vector<TSEGraph>();
            vector2.add(tSEGraph);
            TSEGraph tSEGraph2 = tSEGraph;
            TSNestingManager.buildAllNestedGraphList(tSEGraph2, vector2, false);
            while (!vector2.isEmpty()) {
                object2 = (TSEGraph)vector2.remove(0);
                object = ((TSEGraph)object2).selectedNodes().iterator();
                while (object.hasNext()) {
                    TSENode tSENode = (TSENode)object.next();
                    if (!tSENode.isFolderNode()) continue;
                    vector.add(tSENode);
                }
            }
            object2 = vector.iterator();
            while (object2.hasNext()) {
                object = (TSENode)object2.next();
                this.unfold((TSDNode)object, true);
                if (((TSGraphObject)object).isOwned()) {
                    ((TSNode)object).getOwnerGraph().remove((TSNode)object);
                }
                if (((TSEGraph)((TSGraphMember)object).getChildGraph()).isSelected()) {
                    ((TSEGraph)this.graphManager.getMainDisplayGraph()).setSelected(true);
                }
                this.graphManager.remove(((TSGraphMember)object).getChildGraph());
            }
        }
    }

    public TSENodeUI getFolderUI() {
        if (this.folderUI == null) {
            this.folderUI = new TSEImageNodeUI();
            this.folderUI.setProperty(new TSProperty("imageUsed", "images/folder.gif"));
            this.folderUI.setDrawChildGraphMark(false);
        }
        return (TSENodeUI)this.folderUI.clone();
    }

    public void setFolderUI(TSENodeUI tSENodeUI) {
        if (tSENodeUI != null) {
            this.folderUI = tSENodeUI;
        }
    }

    public static TSFoldingManager getManager(TSDGraphManager tSDGraphManager) {
        TSFoldingManager tSFoldingManager = TSFoldingManager.hasManager(tSDGraphManager);
        if (tSFoldingManager == null) {
            tSFoldingManager = new TSEFoldingManager((TSEGraphManager)tSDGraphManager);
        }
        return tSFoldingManager;
    }

    public boolean isUsingGeometricAdjustment() {
        boolean bl = false;
        TSEGraphWindow tSEGraphWindow = ((TSEGraphManager)this.graphManager).getGraphWindow();
        if (tSEGraphWindow != null) {
            bl = tSEGraphWindow.getPreferences().getBooleanValue("geometricAdjustment");
        }
        return bl;
    }

    public void setUsingGeometricAdjustment(boolean bl) {
        TSEGraphWindow tSEGraphWindow = ((TSEGraphManager)this.graphManager).getGraphWindow();
        if (tSEGraphWindow != null) {
            tSEGraphWindow.getPreferences().setValue((Object)"geometricAdjustment", bl);
        }
    }
}

