/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editor.complexity;

import com.tomsawyer.complexity.TSExpandedNodeExtension;
import com.tomsawyer.editor.TSEGraphManager;
import com.tomsawyer.editor.TSENode;

public class TSEExpandedNodeExtension
extends TSExpandedNodeExtension {
    int preExpandResizability;

    public TSEExpandedNodeExtension(TSENode tSENode, TSEGraphManager tSEGraphManager) {
        super(tSENode, tSEGraphManager);
        if (tSENode != null) {
            this.preExpandResizability = tSENode.getResizability();
        }
    }

    public void init() {
        super.init();
        this.preExpandResizability = 0;
    }

    public int getPreExpandResizability() {
        return this.preExpandResizability;
    }

    public void setPreExpandResizability(int n) {
        this.preExpandResizability = n;
    }

    public void exchangeContents(boolean bl) {
        TSENode tSENode = (TSENode)this.getExpandedNode();
        if (tSENode != null && bl) {
            tSENode.setResizability(0);
        }
        super.exchangeContents(bl);
        if (tSENode != null) {
            if (bl) {
                tSENode.setResizability(this.preExpandResizability);
            } else {
                this.preExpandResizability = tSENode.getResizability();
                tSENode.setResizability(1 | 2);
            }
        }
    }

    public void copy(Object object) {
        super.copy(object);
        if (object instanceof TSEExpandedNodeExtension) {
            TSEExpandedNodeExtension tSEExpandedNodeExtension = (TSEExpandedNodeExtension)object;
            this.setPreExpandResizability(tSEExpandedNodeExtension.getPreExpandResizability());
        } else {
            this.setPreExpandResizability(((TSENode)this.getExpandedNode()).getDefaultResizability());
        }
    }
}

