/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editor.command;

import com.tomsawyer.editor.TSEObjectUI;
import com.tomsawyer.util.TSProperty;
import com.tomsawyer.util.TSSystem;
import com.tomsawyer.util.command.TSCommand;

public class TSESetPropertyCommand
extends TSCommand {
    TSProperty oldValue;
    TSProperty newValue;
    TSEObjectUI objectUI;

    public TSESetPropertyCommand(TSEObjectUI tSEObjectUI, TSProperty tSProperty) {
        if (tSEObjectUI == null || tSProperty == null) {
            throw new IllegalArgumentException();
        }
        this.objectUI = tSEObjectUI;
        this.oldValue = tSEObjectUI.getProperty(tSProperty.getName());
        this.newValue = tSProperty;
        TSSystem.tsAssert(this.oldValue != null);
        this.oldValue.setValue(this.oldValue.getValue().toString());
        tSProperty.setValue(tSProperty.getValue().toString());
    }

    protected void doAction() throws Throwable {
        this.objectUI.setProperty(this.newValue);
    }

    protected void undoAction() throws Throwable {
        this.objectUI.setProperty(this.oldValue);
    }

    public TSProperty getOriginalValue() {
        return this.oldValue;
    }

    public TSProperty getNewValue() {
        return this.newValue;
    }

    public TSEObjectUI getObjectUI() {
        return this.objectUI;
    }
}

