/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editor.command;

import com.tomsawyer.drawing.geometry.TSConstRect;
import com.tomsawyer.editor.TSEGraph;
import com.tomsawyer.editor.TSEGraphManager;
import com.tomsawyer.editor.TSEGraphWindow;
import com.tomsawyer.editor.command.TSELayoutOperationCommand;
import com.tomsawyer.editor.service.TSEAllOptionsServiceInputData;
import com.tomsawyer.service.client.TSServiceProxy;
import java.util.LinkedList;
import java.util.List;

public class TSERoutingCommand
extends TSELayoutOperationCommand {
    TSConstRect viewBounds;
    boolean selectedEdgesOnly;
    List edgeList;

    public TSERoutingCommand(TSEGraphWindow tSEGraphWindow, TSServiceProxy tSServiceProxy, TSEAllOptionsServiceInputData tSEAllOptionsServiceInputData) {
        this(tSEGraphWindow, tSServiceProxy, tSEAllOptionsServiceInputData, false);
    }

    public TSERoutingCommand(TSEGraphWindow tSEGraphWindow, TSServiceProxy tSServiceProxy, TSEAllOptionsServiceInputData tSEAllOptionsServiceInputData, boolean bl) {
        this(tSEGraphWindow.getGraphManager(), tSServiceProxy, tSEAllOptionsServiceInputData, bl);
    }

    public TSERoutingCommand(TSEGraphWindow tSEGraphWindow, TSServiceProxy tSServiceProxy, TSEAllOptionsServiceInputData tSEAllOptionsServiceInputData, List list) {
        this(tSEGraphWindow.getGraphManager(), tSServiceProxy, tSEAllOptionsServiceInputData);
        this.edgeList = list;
    }

    public TSERoutingCommand(TSEGraphManager tSEGraphManager, TSServiceProxy tSServiceProxy, TSEAllOptionsServiceInputData tSEAllOptionsServiceInputData) {
        this(tSEGraphManager, tSServiceProxy, tSEAllOptionsServiceInputData, false);
    }

    public TSERoutingCommand(TSEGraphManager tSEGraphManager, TSServiceProxy tSServiceProxy, TSEAllOptionsServiceInputData tSEAllOptionsServiceInputData, boolean bl) {
        super(tSEGraphManager, tSServiceProxy, tSEAllOptionsServiceInputData);
        this.selectedEdgesOnly = bl;
    }

    public TSERoutingCommand(TSEGraphManager tSEGraphManager, TSServiceProxy tSServiceProxy, TSEAllOptionsServiceInputData tSEAllOptionsServiceInputData, List list) {
        super(tSEGraphManager, tSServiceProxy, tSEAllOptionsServiceInputData);
        this.edgeList = list;
    }

    public TSERoutingCommand(TSEGraph tSEGraph, TSServiceProxy tSServiceProxy, TSEAllOptionsServiceInputData tSEAllOptionsServiceInputData) {
        this(tSEGraph, tSServiceProxy, tSEAllOptionsServiceInputData, false);
    }

    public TSERoutingCommand(TSEGraph tSEGraph, TSServiceProxy tSServiceProxy, TSEAllOptionsServiceInputData tSEAllOptionsServiceInputData, boolean bl) {
        super(tSEGraph, tSServiceProxy, tSEAllOptionsServiceInputData);
        this.selectedEdgesOnly = bl;
    }

    public TSERoutingCommand(TSEGraph tSEGraph, TSServiceProxy tSServiceProxy, TSEAllOptionsServiceInputData tSEAllOptionsServiceInputData, List list) {
        super(tSEGraph, tSServiceProxy, tSEAllOptionsServiceInputData);
        this.edgeList = list;
    }

    protected List computeEdgeList() {
        List list;
        if (this.edgeList != null) {
            list = this.edgeList;
        } else {
            list = new LinkedList();
            if (this.selectedEdgesOnly) {
                if (this.singleGraph) {
                    list.addAll(this.graph.selectedEdges());
                } else {
                    list.addAll(this.graphManager.selectedEdges(true));
                }
            } else {
                int n = 83;
                list = this.singleGraph ? this.graph.buildEdges(n) : this.graphManager.buildEdges(n);
            }
        }
        return list;
    }

    protected void doAction() throws Throwable {
        if (this.graphWindow != null) {
            this.viewBounds = new TSConstRect(this.graphWindow.getTransform().getWorldBounds());
        }
        this.inputData.setOption((Object)this.graphManager, "routing:all:graphManager:edgeList", (Object)this.computeEdgeList());
        super.doAction();
        this.inputData.remove((Object)this.graphManager, "routing:all:graphManager:edgeList");
    }

    protected void postLayout() {
        this.graphWindow.fitInWindow(true);
    }

    protected void undoAction() throws Throwable {
        TSConstRect tSConstRect = this.viewBounds;
        if (this.graphWindow != null) {
            this.viewBounds = new TSConstRect(this.graphWindow.getTransform().getWorldBounds());
        }
        super.undoAction();
        if (this.graphWindow != null) {
            this.graphWindow.fitRectInWindow(tSConstRect, false);
        }
    }

    protected void redoAction() throws Throwable {
        TSConstRect tSConstRect = this.viewBounds;
        if (this.graphWindow != null) {
            this.viewBounds = new TSConstRect(this.graphWindow.getTransform().getWorldBounds());
        }
        this.inputData.setOption((Object)this.graphManager, "routing:all:graphManager:edgeList", (Object)this.computeEdgeList());
        super.redoAction();
        this.inputData.remove((Object)this.graphManager, "routing:all:graphManager:edgeList");
        if (this.graphWindow != null) {
            this.graphWindow.fitRectInWindow(tSConstRect, false);
        }
    }

    public int getOperation() {
        return 1001;
    }
}

