/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editor.command;

import com.tomsawyer.drawing.TSDGraphManager;
import com.tomsawyer.drawing.geometry.TSConstRect;
import com.tomsawyer.editor.TSEGraphManager;
import com.tomsawyer.editor.TSEGraphWindow;
import com.tomsawyer.service.TSServiceInputData;
import com.tomsawyer.service.TSServiceOutputData;
import com.tomsawyer.service.layout.client.TSApplyLayoutResults;
import com.tomsawyer.service.layout.client.TSRandomLayout;
import com.tomsawyer.util.command.TSCommand;

public class TSERandomLayoutCommand
extends TSCommand {
    TSEGraphManager graphManager;
    TSEGraphWindow graphWindow;
    TSConstRect viewBounds;
    TSServiceInputData inputData;
    TSServiceOutputData outputDataAfterLayout;
    TSServiceOutputData outputDataBeforeLayout;

    public TSERandomLayoutCommand(TSEGraphWindow tSEGraphWindow) {
        this(tSEGraphWindow.getGraphManager());
    }

    public TSERandomLayoutCommand(TSEGraphManager tSEGraphManager) {
        this.graphManager = tSEGraphManager;
        this.graphWindow = tSEGraphManager.getGraphWindow();
    }

    protected void doAction() {
        this.inputData = new TSServiceInputData();
        this.inputData.setOption(null, "all:all:none:operation", 1000);
        this.inputData.setOption(null, "all:all:none:graphManager", (Object)this.graphManager);
        TSApplyLayoutResults tSApplyLayoutResults = new TSApplyLayoutResults();
        this.outputDataBeforeLayout = tSApplyLayoutResults.generateOutputData((TSDGraphManager)this.graphManager, this.inputData);
        if (this.graphWindow != null) {
            this.viewBounds = new TSConstRect(this.graphWindow.getTransform().getWorldBounds());
        }
        TSRandomLayout tSRandomLayout = new TSRandomLayout();
        tSRandomLayout.layout((TSDGraphManager)this.graphManager);
        this.outputDataAfterLayout = tSApplyLayoutResults.generateOutputData((TSDGraphManager)this.graphManager, this.inputData);
        this.postLayout();
    }

    protected void postLayout() {
        this.graphWindow.fitInWindow(true);
    }

    protected void undoAction() {
        TSApplyLayoutResults tSApplyLayoutResults = new TSApplyLayoutResults();
        tSApplyLayoutResults.apply(this.inputData, this.outputDataBeforeLayout);
        TSConstRect tSConstRect = this.viewBounds;
        if (this.graphWindow != null) {
            this.viewBounds = new TSConstRect(this.graphWindow.getTransform().getWorldBounds());
        }
        if (this.graphWindow != null) {
            this.graphWindow.fitRectInWindow(tSConstRect, false);
        }
    }

    protected void redoAction() throws Throwable {
        TSConstRect tSConstRect = this.viewBounds;
        if (this.graphWindow != null) {
            this.viewBounds = new TSConstRect(this.graphWindow.getTransform().getWorldBounds());
        }
        TSApplyLayoutResults tSApplyLayoutResults = new TSApplyLayoutResults();
        tSApplyLayoutResults.apply(this.inputData, this.outputDataAfterLayout);
        if (this.graphWindow != null) {
            this.graphWindow.fitRectInWindow(tSConstRect, false);
        }
    }
}

