/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editor.command;

import com.tomsawyer.complexity.TSNestingManager;
import com.tomsawyer.diagramming.TSCutCopyPasteControl;
import com.tomsawyer.drawing.TSConnector;
import com.tomsawyer.drawing.TSConnectorLabel;
import com.tomsawyer.drawing.TSDEdge;
import com.tomsawyer.drawing.TSDGraph;
import com.tomsawyer.drawing.TSDNode;
import com.tomsawyer.drawing.TSEdgeLabel;
import com.tomsawyer.drawing.TSGraphTailor;
import com.tomsawyer.drawing.TSNodeLabel;
import com.tomsawyer.drawing.geometry.TSPoint;
import com.tomsawyer.editor.TSEConnector;
import com.tomsawyer.editor.TSEConnectorLabel;
import com.tomsawyer.editor.TSEEdge;
import com.tomsawyer.editor.TSEEdgeLabel;
import com.tomsawyer.editor.TSEGraph;
import com.tomsawyer.editor.TSEGraphManager;
import com.tomsawyer.editor.TSENode;
import com.tomsawyer.editor.TSENodeLabel;
import com.tomsawyer.editor.TSEPNode;
import com.tomsawyer.graph.TSEdge;
import com.tomsawyer.graph.TSGraphObject;
import com.tomsawyer.graph.TSNode;
import com.tomsawyer.util.TSOptionData;
import com.tomsawyer.util.command.TSCommand;
import com.tomsawyer.util.f2;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class TSEPasteCommand
extends TSCommand {
    Vector nodes;
    Vector edges;
    Vector nodeLabels;
    Vector connectorLabels;
    Vector edgeLabels;
    TSGraphObject targetObject;
    TSPoint pastePoint;
    TSCutCopyPasteControl control;
    TSOptionData serviceInputData;
    boolean compressMetaEdges;
    List graphs;
    List margins;
    boolean updateMetaEdges;
    List removedMetaEdges;
    List insertedMetaEdges;
    TSEGraphManager graphManager;

    public TSEPasteCommand(TSGraphObject tSGraphObject, TSCutCopyPasteControl tSCutCopyPasteControl, TSPoint tSPoint) {
        this(tSGraphObject, tSCutCopyPasteControl, tSPoint, null);
    }

    public TSEPasteCommand(TSGraphObject tSGraphObject, TSCutCopyPasteControl tSCutCopyPasteControl, TSPoint tSPoint, TSOptionData tSOptionData) {
        f2.a(f2.bx);
        this.control = tSCutCopyPasteControl;
        this.serviceInputData = tSOptionData;
        this.targetObject = tSGraphObject;
        this.pastePoint = new TSPoint(tSPoint);
        this.graphManager = this.targetObject instanceof TSEGraph ? (TSEGraphManager)this.targetObject.getOwner() : (TSEGraphManager)this.targetObject.getOwnerGraph().getOwner();
        this.compressMetaEdges = this.graphManager.getCompressMetaEdges();
        this.nodes = new Vector();
        this.edges = new Vector();
        this.nodeLabels = new Vector();
        this.connectorLabels = new Vector();
        this.edgeLabels = new Vector();
        this.updateMetaEdges = true;
        this.insertedMetaEdges = null;
        this.removedMetaEdges = null;
    }

    public TSCutCopyPasteControl getControl() {
        return this.control;
    }

    protected void doAction() throws Throwable {
        this.storeOldMargins();
        this.control.paste(this.targetObject, this.serviceInputData, (long)this.pastePoint.getX(), (long)this.pastePoint.getY(), this.nodes, this.edges, this.nodeLabels, this.connectorLabels, this.edgeLabels);
        if (this.updateMetaEdges) {
            this.insertedMetaEdges = new Vector();
            this.removedMetaEdges = new Vector();
            this.graphManager.checkMetaEdges(this.insertedMetaEdges, this.removedMetaEdges);
            this.graphManager.updateMetaEdges(this.insertedMetaEdges, this.removedMetaEdges, this.insertedMetaEdges);
        }
        this.setSelection();
    }

    protected void undoAction() throws Throwable {
        Iterator iterator;
        Object object;
        if (this.updateMetaEdges) {
            object = this.insertedMetaEdges.iterator();
            while (object.hasNext()) {
                iterator = (TSEEdge)object.next();
                this.graphManager.remove((TSEdge)((Object)iterator));
            }
            object = this.removedMetaEdges.iterator();
            while (object.hasNext()) {
                iterator = (TSEEdge)object.next();
                ((TSEdge)((Object)iterator)).getOwnerGraph().insert((TSEdge)((Object)iterator));
            }
        }
        if (this.targetObject instanceof TSEGraph) {
            object = (TSEGraph)this.targetObject;
            iterator = this.edges.iterator();
            while (iterator.hasNext()) {
                this.graphManager.remove((TSEdge)iterator.next());
            }
            iterator = this.nodes.iterator();
            while (iterator.hasNext()) {
                ((TSDGraph)object).remove((TSNode)iterator.next());
            }
            ((TSDGraph)object).updateBounds();
        } else if (this.targetObject instanceof TSENode) {
            object = (TSENode)this.targetObject;
            iterator = this.nodeLabels.iterator();
            while (iterator.hasNext()) {
                TSENodeLabel tSENodeLabel = (TSENodeLabel)iterator.next();
                if (!((TSDNode)object).labels().contains(tSENodeLabel)) continue;
                ((TSDNode)object).remove(tSENodeLabel);
            }
        } else if (this.targetObject instanceof TSEConnector) {
            object = (TSEConnector)this.targetObject;
            iterator = this.connectorLabels.iterator();
            while (iterator.hasNext()) {
                TSEConnectorLabel tSEConnectorLabel = (TSEConnectorLabel)iterator.next();
                if (!((TSConnector)object).labels().contains(tSEConnectorLabel)) continue;
                ((TSConnector)object).remove(tSEConnectorLabel);
            }
        } else if (this.targetObject instanceof TSEEdge) {
            object = (TSEEdge)this.targetObject;
            iterator = this.edgeLabels.iterator();
            while (iterator.hasNext()) {
                TSEEdgeLabel tSEEdgeLabel = (TSEEdgeLabel)iterator.next();
                if (!((TSDEdge)object).labels().contains(tSEEdgeLabel)) continue;
                ((TSDEdge)object).remove(tSEEdgeLabel);
            }
        }
        this.restoreMargins();
    }

    protected void redoAction() throws Throwable {
        TSGraphObject tSGraphObject;
        Object object;
        Iterator iterator;
        if (this.targetObject instanceof TSEGraph) {
            iterator = (TSEGraph)this.targetObject;
            object = this.nodes.iterator();
            while (object.hasNext()) {
                ((TSDGraph)((Object)iterator)).insert((TSNode)object.next());
            }
            object = this.edges.iterator();
            while (object.hasNext()) {
                tSGraphObject = (TSEdge)object.next();
                ((TSEdge)tSGraphObject).getOwnerGraph().insert((TSEdge)tSGraphObject);
            }
        }
        iterator = this.nodeLabels.iterator();
        while (iterator.hasNext()) {
            object = (TSENodeLabel)iterator.next();
            tSGraphObject = (TSENode)((TSGraphObject)object).getOwner();
            if (((TSDNode)tSGraphObject).labels().contains(object)) continue;
            ((TSDNode)tSGraphObject).insert((TSNodeLabel)object);
        }
        iterator = this.connectorLabels.iterator();
        while (iterator.hasNext()) {
            object = (TSEConnectorLabel)iterator.next();
            tSGraphObject = (TSEConnector)((TSGraphObject)object).getOwner();
            if (((TSConnector)tSGraphObject).labels().contains(object)) continue;
            ((TSConnector)tSGraphObject).insert((TSConnectorLabel)object);
        }
        iterator = this.edgeLabels.iterator();
        while (iterator.hasNext()) {
            object = (TSEEdgeLabel)iterator.next();
            tSGraphObject = (TSEEdge)((TSGraphObject)object).getOwner();
            if (((TSDEdge)tSGraphObject).labels().contains(object)) continue;
            ((TSDEdge)tSGraphObject).insert((TSEdgeLabel)object);
        }
        if (this.updateMetaEdges) {
            object = this.insertedMetaEdges.iterator();
            while (object.hasNext()) {
                tSGraphObject = (TSEEdge)object.next();
                this.graphManager.insert((TSEdge)tSGraphObject, ((TSEdge)tSGraphObject).getSourceNode(), ((TSEdge)tSGraphObject).getTargetNode());
            }
            object = this.removedMetaEdges.iterator();
            while (object.hasNext()) {
                tSGraphObject = (TSEEdge)object.next();
                this.graphManager.remove((TSEdge)tSGraphObject);
            }
        }
        this.setSelection();
    }

    private void setSelection() {
        TSGraphObject tSGraphObject;
        Object object;
        Iterator iterator;
        Object object2;
        TSEGraphManager tSEGraphManager = this.targetObject instanceof TSEGraph ? (TSEGraphManager)this.targetObject.getOwner() : (TSEGraphManager)this.targetObject.getOwnerGraph().getOwner();
        tSEGraphManager.selectAll(false);
        Iterator iterator2 = this.nodes.iterator();
        while (iterator2.hasNext()) {
            object2 = (TSENode)iterator2.next();
            ((TSENode)object2).setSelected(true);
            iterator = ((TSDNode)object2).labels().iterator();
            while (iterator.hasNext()) {
                ((TSENodeLabel)iterator.next()).setSelected(true);
            }
            object = ((TSDNode)object2).connectors().iterator();
            while (object.hasNext()) {
                tSGraphObject = (TSEConnector)object.next();
                ((TSEConnector)tSGraphObject).setSelected(true);
                ((TSEConnector)tSGraphObject).setLabelsSelected(true);
            }
        }
        iterator2 = this.edges.iterator();
        while (iterator2.hasNext()) {
            object = (TSEEdge)iterator2.next();
            if (((TSEdge)object).isIntergraphEdge() && !((TSDEdge)object).isViewable() && (tSGraphObject = (TSEEdge)tSEGraphManager.getMetaEdge((TSDEdge)object)) != null) {
                object = tSGraphObject;
            }
            ((TSEEdge)object).setSelected(true);
            object2 = ((TSDEdge)object).bendIterator();
            while (object2.hasNext()) {
                ((TSEPNode)object2.next()).setSelected(true);
            }
            iterator = ((TSDEdge)object).labels().iterator();
            while (iterator.hasNext()) {
                ((TSEEdgeLabel)iterator.next()).setSelected(true);
            }
        }
        iterator2 = this.nodeLabels.iterator();
        while (iterator2.hasNext()) {
            ((TSENodeLabel)iterator2.next()).setSelected(true);
        }
        iterator2 = this.connectorLabels.iterator();
        while (iterator2.hasNext()) {
            ((TSEConnectorLabel)iterator2.next()).setSelected(true);
        }
        iterator2 = this.edgeLabels.iterator();
        while (iterator2.hasNext()) {
            ((TSEEdgeLabel)iterator2.next()).setSelected(true);
        }
    }

    public boolean isCoalesced() {
        return true;
    }

    protected void undoCleanup() {
        Iterator iterator = this.nodes.iterator();
        while (iterator.hasNext()) {
            ((TSNode)iterator.next()).dispose();
        }
        iterator = this.edges.iterator();
        while (iterator.hasNext()) {
            ((TSEdge)iterator.next()).dispose();
        }
        iterator = this.nodeLabels.iterator();
        while (iterator.hasNext()) {
            ((TSENodeLabel)iterator.next()).dispose();
        }
        iterator = this.connectorLabels.iterator();
        while (iterator.hasNext()) {
            ((TSEConnectorLabel)iterator.next()).dispose();
        }
        iterator = this.edgeLabels.iterator();
        while (iterator.hasNext()) {
            ((TSEEdgeLabel)iterator.next()).dispose();
        }
    }

    private void storeOldMargins() {
        TSEGraphManager tSEGraphManager = this.targetObject instanceof TSEGraph ? (TSEGraphManager)this.targetObject.getOwner() : (TSEGraphManager)this.targetObject.getOwnerGraph().getOwner();
        if (tSEGraphManager != null) {
            this.graphs = new Vector();
            this.margins = new Vector();
            TSNestingManager.buildNestedGraphList(tSEGraphManager.getMainDisplayGraph(), this.graphs, false);
            if (this.graphs != null) {
                Iterator iterator = this.graphs.iterator();
                while (iterator.hasNext()) {
                    double[] dArray = new double[4];
                    TSGraphTailor tSGraphTailor = ((TSEGraph)iterator.next()).getTailor();
                    dArray[0] = tSGraphTailor.getLeftConstantMargin();
                    dArray[1] = tSGraphTailor.getRightConstantMargin();
                    dArray[2] = tSGraphTailor.getBottomConstantMargin();
                    dArray[3] = tSGraphTailor.getTopConstantMargin();
                    this.margins.add(dArray);
                }
            }
        }
    }

    private void restoreMargins() {
        if (this.graphs != null) {
            Iterator iterator = this.graphs.iterator();
            Iterator iterator2 = this.margins.iterator();
            while (iterator.hasNext()) {
                TSEGraph tSEGraph = (TSEGraph)iterator.next();
                TSGraphTailor tSGraphTailor = tSEGraph.getTailor();
                double[] dArray = (double[])iterator2.next();
                double d = tSGraphTailor.getOriginalLeftConstantMargin();
                double d2 = tSGraphTailor.getOriginalRightConstantMargin();
                double d3 = tSGraphTailor.getOriginalBottomConstantMargin();
                double d4 = tSGraphTailor.getOriginalTopConstantMargin();
                tSGraphTailor.setLeftConstantMargin(dArray[0]);
                tSGraphTailor.setRightConstantMargin(dArray[1]);
                tSGraphTailor.setBottomConstantMargin(dArray[2]);
                tSGraphTailor.setTopConstantMargin(dArray[3]);
                tSGraphTailor.setOriginalLeftConstantMargin(d);
                tSGraphTailor.setOriginalRightConstantMargin(d2);
                tSGraphTailor.setOriginalBottomConstantMargin(d3);
                tSGraphTailor.setOriginalTopConstantMargin(d4);
                tSEGraph.updateBounds();
            }
        }
    }

    public void setUpdateMetaEdges(boolean bl) {
        this.updateMetaEdges = bl;
    }
}

