/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editor.command;

import com.tomsawyer.complexity.TSNestingManager;
import com.tomsawyer.drawing.geometry.TSConstRect;
import com.tomsawyer.editor.TSEGraph;
import com.tomsawyer.editor.TSEGraphManager;
import com.tomsawyer.editor.TSEGraphWindow;
import com.tomsawyer.editor.command.TSELayoutOperationCommand;
import com.tomsawyer.editor.service.TSEAllOptionsServiceInputData;
import com.tomsawyer.editor.service.layout.TSEInteractiveLayoutInputTailor;
import com.tomsawyer.service.TSServiceInputData;
import com.tomsawyer.service.client.TSServiceProxy;
import com.tomsawyer.service.dp;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class TSELayoutCommand
extends TSELayoutOperationCommand {
    TSConstRect viewBounds;
    boolean isLayoutStyleSpecified = false;
    int newLayoutStyle = 0;
    int oldLayoutStyle = 0;

    public TSELayoutCommand(TSEGraphWindow tSEGraphWindow, TSServiceProxy tSServiceProxy, TSEAllOptionsServiceInputData tSEAllOptionsServiceInputData) {
        this(tSEGraphWindow.getGraphManager(), tSServiceProxy, tSEAllOptionsServiceInputData);
    }

    public TSELayoutCommand(TSEGraphManager tSEGraphManager, TSServiceProxy tSServiceProxy, TSEAllOptionsServiceInputData tSEAllOptionsServiceInputData) {
        super(tSEGraphManager, tSServiceProxy, tSEAllOptionsServiceInputData);
    }

    public TSELayoutCommand(TSEGraph tSEGraph, TSServiceProxy tSServiceProxy, TSEAllOptionsServiceInputData tSEAllOptionsServiceInputData) {
        super(tSEGraph, tSServiceProxy, tSEAllOptionsServiceInputData);
    }

    public TSELayoutCommand(TSEGraphWindow tSEGraphWindow, TSServiceProxy tSServiceProxy, TSEAllOptionsServiceInputData tSEAllOptionsServiceInputData, int n) {
        this(tSEGraphWindow.getGraphManager(), tSServiceProxy, tSEAllOptionsServiceInputData, n);
    }

    public TSELayoutCommand(TSEGraphManager tSEGraphManager, TSServiceProxy tSServiceProxy, TSEAllOptionsServiceInputData tSEAllOptionsServiceInputData, int n) {
        super(tSEGraphManager, tSServiceProxy, tSEAllOptionsServiceInputData);
        this.isLayoutStyleSpecified = true;
        this.newLayoutStyle = n;
        dp dp2 = new dp(tSServiceProxy.getServiceName());
        this.oldLayoutStyle = dp2.c((TSServiceInputData)tSEAllOptionsServiceInputData, (Object)this.graph, "layout:all:graph:layoutStyle");
    }

    public TSELayoutCommand(TSEGraph tSEGraph, TSServiceProxy tSServiceProxy, TSEAllOptionsServiceInputData tSEAllOptionsServiceInputData, int n) {
        super(tSEGraph, tSServiceProxy, tSEAllOptionsServiceInputData);
        this.isLayoutStyleSpecified = true;
        this.newLayoutStyle = n;
        dp dp2 = new dp(tSServiceProxy.getServiceName());
        this.oldLayoutStyle = dp2.c((TSServiceInputData)tSEAllOptionsServiceInputData, (Object)this.graph, "layout:all:graph:layoutStyle");
    }

    protected void doAction() throws Throwable {
        Iterator iterator;
        List<TSEGraph> list;
        if (this.isLayoutStyleSpecified) {
            this.inputData.setOption((Object)this.graph, "layout:all:graph:layoutStyle", this.newLayoutStyle);
        }
        if (this.singleGraph) {
            list = new LinkedList();
            list.add(this.graph);
        } else {
            list = TSNestingManager.getNestedGraphsWithin(this.graph);
        }
        if (this.graphWindow != null) {
            this.viewBounds = new TSConstRect(this.graphWindow.getTransform().getWorldBounds());
        }
        if (!this.singleGraph) {
            iterator = list.iterator();
            while (iterator.hasNext()) {
                TSEGraph tSEGraph = (TSEGraph)iterator.next();
                tSEGraph.setOriginalVisibleBounds(null);
            }
        }
        if (this.proxy.getServiceName().c().equals("jlayout")) {
            double d = (double)this.graphWindow.getWidth() / (double)this.graphWindow.getHeight();
            iterator = list.iterator();
            while (iterator.hasNext()) {
                TSEGraph tSEGraph = (TSEGraph)iterator.next();
                TSEInteractiveLayoutInputTailor tSEInteractiveLayoutInputTailor = new TSEInteractiveLayoutInputTailor((TSServiceInputData)this.inputData, tSEGraph);
                if (tSEInteractiveLayoutInputTailor.isDisconnectedAspectRatioSet() && tSEInteractiveLayoutInputTailor.getDisconnectedAspectRatio() == 1) {
                    this.inputData.setOption((Object)tSEGraph, "layout:all:graph:componentAspectRatio", d);
                }
                if (!tSEInteractiveLayoutInputTailor.isOrthogonalAspectRatioSet()) continue;
                if (tSEInteractiveLayoutInputTailor.getOrthogonalAspectRatio() == 1) {
                    this.inputData.setOption((Object)tSEGraph, "layout:orthogonal:graph:aspectRatio", d);
                    continue;
                }
                if (tSEInteractiveLayoutInputTailor.getOrthogonalAspectRatio() != 0) continue;
                this.inputData.setOption((Object)tSEGraph, "layout:orthogonal:graph:aspectRatio", 0.0);
            }
        }
        super.doAction();
    }

    protected void postLayout() {
        this.graphWindow.fitInWindow(true);
    }

    protected void undoAction() throws Throwable {
        TSConstRect tSConstRect = this.viewBounds;
        if (this.graphWindow != null) {
            this.viewBounds = new TSConstRect(this.graphWindow.getTransform().getWorldBounds());
        }
        if (this.isLayoutStyleSpecified) {
            this.inputData.setOption((Object)this.graph, "layout:all:graph:layoutStyle", this.oldLayoutStyle);
        }
        super.undoAction();
        if (this.graphWindow != null) {
            this.graphWindow.fitRectInWindow(tSConstRect, false);
        }
    }

    protected void redoAction() throws Throwable {
        TSConstRect tSConstRect = this.viewBounds;
        if (this.graphWindow != null) {
            this.viewBounds = new TSConstRect(this.graphWindow.getTransform().getWorldBounds());
        }
        if (this.isLayoutStyleSpecified) {
            this.inputData.setOption((Object)this.graph, "layout:all:graph:layoutStyle", this.newLayoutStyle);
        }
        super.redoAction();
        if (this.graphWindow != null) {
            this.graphWindow.fitRectInWindow(tSConstRect, false);
        }
    }

    public int getOperation() {
        return 1000;
    }
}

