/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editor.command;

import com.tomsawyer.drawing.TSDGraphManager;
import com.tomsawyer.drawing.command.TSDeleteChildGraphCommand;
import com.tomsawyer.editor.TSEEdge;
import com.tomsawyer.editor.TSEGraphManager;
import com.tomsawyer.editor.TSENode;
import com.tomsawyer.editor.complexity.TSENestingManager;
import com.tomsawyer.graph.TSGraphMember;
import com.tomsawyer.util.f2;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class TSEDeleteChildGraphCommand
extends TSDeleteChildGraphCommand {
    boolean updateMetaEdges = true;
    List removedMetaEdges = null;
    List insertedMetaEdges = null;
    TSEGraphManager graphManager;

    public TSEDeleteChildGraphCommand(TSGraphMember tSGraphMember) {
        super(tSGraphMember);
        this.graphManager = (TSEGraphManager)tSGraphMember.getOwnerGraphManager();
        f2.a(f2.br);
    }

    protected void doAction() throws Throwable {
        super.doAction();
        if (this.updateMetaEdges) {
            this.insertedMetaEdges = new Vector();
            this.removedMetaEdges = new Vector();
            this.graphManager.checkMetaEdges(this.insertedMetaEdges, this.removedMetaEdges);
            this.graphManager.updateMetaEdges(this.insertedMetaEdges, this.removedMetaEdges, this.insertedMetaEdges);
        }
    }

    protected void undoAction() throws Throwable {
        if (this.updateMetaEdges) {
            TSEEdge tSEEdge;
            Iterator iterator = this.insertedMetaEdges.iterator();
            while (iterator.hasNext()) {
                tSEEdge = (TSEEdge)iterator.next();
                this.graphManager.remove(tSEEdge);
            }
            iterator = this.removedMetaEdges.iterator();
            while (iterator.hasNext()) {
                tSEEdge = (TSEEdge)iterator.next();
                tSEEdge.getOwnerGraph().insert(tSEEdge);
            }
        }
        super.undoAction();
    }

    protected void redoAction() throws Throwable {
        super.redoAction();
        if (this.updateMetaEdges) {
            TSEEdge tSEEdge;
            Iterator iterator = this.insertedMetaEdges.iterator();
            while (iterator.hasNext()) {
                tSEEdge = (TSEEdge)iterator.next();
                tSEEdge.getOwnerGraph().insert(tSEEdge);
            }
            iterator = this.removedMetaEdges.iterator();
            while (iterator.hasNext()) {
                tSEEdge = (TSEEdge)iterator.next();
                this.graphManager.remove(tSEEdge);
            }
        }
    }

    public void setUpdateMetaEdges(boolean bl) {
        this.updateMetaEdges = bl;
    }

    protected void collapse(TSDGraphManager tSDGraphManager, TSGraphMember tSGraphMember) {
        TSENestingManager tSENestingManager = (TSENestingManager)TSENestingManager.getManager(tSDGraphManager);
        TSENestingManager.collapse((TSENode)tSGraphMember);
    }

    protected void expand(TSDGraphManager tSDGraphManager, TSGraphMember tSGraphMember) {
        TSENestingManager tSENestingManager = (TSENestingManager)TSENestingManager.getManager(tSDGraphManager);
        TSENestingManager.expand((TSENode)tSGraphMember);
    }
}

