/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editor.command;

import com.tomsawyer.editor.TSEEdge;
import com.tomsawyer.editor.TSEGraph;
import com.tomsawyer.editor.TSEGraphManager;
import com.tomsawyer.editor.TSEGraphWindow;
import com.tomsawyer.editor.TSENode;
import com.tomsawyer.editor.command.TSEDeleteEdgeCommand;
import com.tomsawyer.editor.command.TSEDeleteNodeCommand;
import com.tomsawyer.editor.command.ha;
import com.tomsawyer.editor.complexity.command.TSECollapseCommand;
import com.tomsawyer.editor.complexity.command.TSEUnhideCommand;
import com.tomsawyer.editor.event.TSEEventManager;
import com.tomsawyer.graph.TSGraph;
import com.tomsawyer.graph.TSGraphObject;
import com.tomsawyer.util.command.TSCommand;
import com.tomsawyer.util.command.TSGroupCommand;
import com.tomsawyer.util.f2;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class TSEClearAllCommand
extends TSCommand {
    TSEGraphManager graphManager;
    TSEGraph mainDisplayGraph;
    TSGroupCommand unhideGroupCommand = null;
    TSECollapseCommand collapseCommand = null;
    TSGroupCommand disassociateChildGraphGroupCommand = null;
    TSGroupCommand deleteNodeGroupCommand = null;
    TSGroupCommand deleteEdgeGroupCommand = null;
    List graphsToRemove = null;

    public TSEClearAllCommand(TSEGraphWindow tSEGraphWindow) {
        f2.a(f2.br);
        this.graphManager = tSEGraphWindow.getGraphManager();
        this.setCoalesced(true);
    }

    protected void doAction() throws Throwable {
        TSGraphObject tSGraphObject;
        Iterator iterator;
        Object object;
        this.mainDisplayGraph = (TSEGraph)this.graphManager.getMainDisplayGraph();
        TSEEventManager tSEEventManager = (TSEEventManager)this.graphManager.getEventManager();
        boolean bl = tSEEventManager.isCoalesce();
        tSEEventManager.setCoalesce(this.isCoalesced());
        this.unhideGroupCommand = new TSGroupCommand();
        this.disassociateChildGraphGroupCommand = new TSGroupCommand();
        this.graphsToRemove = new Vector();
        Iterator iterator2 = this.graphManager.graphs().iterator();
        while (iterator2.hasNext()) {
            TSEGraph tSEGraph = (TSEGraph)iterator2.next();
            object = new TSEUnhideCommand(tSEGraph, false);
            this.unhideGroupCommand.add((TSCommand)object);
            if (tSEGraph.isChildGraph()) {
                iterator = new ha(this, tSEGraph.getParent());
                this.disassociateChildGraphGroupCommand.add((TSCommand)((Object)iterator));
            }
            if (tSEGraph == this.mainDisplayGraph) continue;
            this.graphsToRemove.add(tSEGraph);
        }
        boolean bl2 = tSEEventManager.isFiringEvents();
        tSEEventManager.setFireEvents(false);
        this.unhideGroupCommand.execute();
        tSEEventManager.setFireEvents(bl2);
        this.deleteEdgeGroupCommand = new TSGroupCommand();
        object = this.mainDisplayGraph.edges().iterator();
        while (object.hasNext()) {
            iterator = (TSEEdge)object.next();
            this.deleteEdgeGroupCommand.add(new TSEDeleteEdgeCommand((TSEEdge)((Object)iterator)));
        }
        this.deleteNodeGroupCommand = new TSGroupCommand();
        iterator = this.mainDisplayGraph.nodes().iterator();
        while (iterator.hasNext()) {
            tSGraphObject = (TSENode)iterator.next();
            this.deleteNodeGroupCommand.add(new TSEDeleteNodeCommand((TSENode)tSGraphObject));
        }
        this.disassociateChildGraphGroupCommand.execute();
        this.deleteEdgeGroupCommand.execute();
        this.deleteNodeGroupCommand.execute();
        iterator2 = this.graphsToRemove.iterator();
        while (iterator2.hasNext()) {
            tSGraphObject = (TSEGraph)iterator2.next();
            this.graphManager.remove((TSGraph)tSGraphObject);
        }
        this.mainDisplayGraph.setViewability(true);
        this.mainDisplayGraph.setSelected(true);
        tSEEventManager.setCoalesce(bl);
    }

    protected void undoAction() throws Throwable {
        TSEEventManager tSEEventManager = (TSEEventManager)this.graphManager.getEventManager();
        boolean bl = tSEEventManager.isCoalesce();
        tSEEventManager.setCoalesce(this.isCoalesced());
        Iterator iterator = this.graphsToRemove.iterator();
        while (iterator.hasNext()) {
            TSEGraph tSEGraph = (TSEGraph)iterator.next();
            this.graphManager.insert(tSEGraph);
        }
        this.deleteNodeGroupCommand.undo();
        this.deleteEdgeGroupCommand.undo();
        this.disassociateChildGraphGroupCommand.undo();
        boolean bl2 = tSEEventManager.isFiringEvents();
        tSEEventManager.setFireEvents(false);
        this.unhideGroupCommand.undo();
        tSEEventManager.setFireEvents(bl2);
        tSEEventManager.setCoalesce(bl);
    }

    protected void redoAction() throws Throwable {
        TSEEventManager tSEEventManager = (TSEEventManager)this.graphManager.getEventManager();
        boolean bl = tSEEventManager.isCoalesce();
        tSEEventManager.setCoalesce(this.isCoalesced());
        boolean bl2 = tSEEventManager.isFiringEvents();
        tSEEventManager.setFireEvents(false);
        this.unhideGroupCommand.redo();
        tSEEventManager.setFireEvents(bl2);
        this.disassociateChildGraphGroupCommand.redo();
        this.deleteEdgeGroupCommand.redo();
        this.deleteNodeGroupCommand.redo();
        Iterator iterator = this.graphsToRemove.iterator();
        while (iterator.hasNext()) {
            TSEGraph tSEGraph = (TSEGraph)iterator.next();
            this.graphManager.remove(tSEGraph);
        }
        this.mainDisplayGraph.setViewability(true);
        tSEEventManager.setCoalesce(bl);
    }

    protected void doCleanup() {
        Iterator iterator = this.graphsToRemove.iterator();
        while (iterator.hasNext()) {
            TSEGraph tSEGraph = (TSEGraph)iterator.next();
            this.graphManager.discard(tSEGraph);
        }
        if (this.unhideGroupCommand != null) {
            this.unhideGroupCommand.doCleanup();
        }
        if (this.disassociateChildGraphGroupCommand != null) {
            this.disassociateChildGraphGroupCommand.doCleanup();
        }
        if (this.deleteNodeGroupCommand != null) {
            this.deleteNodeGroupCommand.doCleanup();
        }
        if (this.deleteEdgeGroupCommand != null) {
            this.deleteEdgeGroupCommand.doCleanup();
        }
    }
}

