/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editor;

import com.tomsawyer.drawing.geometry.TSConstPoint;
import com.tomsawyer.drawing.geometry.TSPoint;
import com.tomsawyer.editor.TSEGraphWindow;
import com.tomsawyer.editor.TSEGrid;
import com.tomsawyer.editor.TSEHitTesting;
import com.tomsawyer.editor.TSEObject;
import com.tomsawyer.editor.TSEWindowTool;
import com.tomsawyer.editor.g6;
import com.tomsawyer.util.TSSystem;
import java.awt.Point;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;

public class TSEWindowInputTool
extends TSEWindowTool {
    double gridOffsetX = 0.0;
    double gridOffsetY = 0.0;
    private g6 mouseInputHandler = new g6(this, this);
    boolean dragging;

    public TSEWindowInputTool() {
        this(null);
    }

    public TSEWindowInputTool(TSEWindowTool tSEWindowTool) {
        super(tSEWindowTool);
    }

    protected void init() {
        super.init();
        this.startMouseInput();
    }

    public void startMouseInput() {
        this.mouseInputHandler.b();
    }

    public void stopMouseInput() {
        this.mouseInputHandler.a();
    }

    public void resetTool() {
        this.setCursor(this.defaultCursor);
    }

    public void setTool(TSEWindowTool tSEWindowTool) {
        this.stopMouseInput();
        super.setTool(tSEWindowTool);
    }

    private final void mouseClickedEvent(MouseEvent mouseEvent) {
        this.onMouseClicked(mouseEvent);
    }

    private final void mouseEnteredEvent(MouseEvent mouseEvent) {
        this.onMouseEntered(mouseEvent);
    }

    private final void mouseExitedEvent(MouseEvent mouseEvent) {
        this.onMouseExited(mouseEvent);
    }

    private final void mousePressedEvent(MouseEvent mouseEvent) {
        this.setDragInProgress(false);
        this.onMousePressed(mouseEvent);
    }

    private final void mouseReleasedEvent(MouseEvent mouseEvent) {
        this.setDragInProgress(false);
        this.onMouseReleased(mouseEvent);
    }

    private final void mouseDraggedEvent(MouseEvent mouseEvent) {
        if (!this.isDragInProgress()) {
            this.onMouseDragged(mouseEvent);
        }
    }

    private final void mouseMovedEvent(MouseEvent mouseEvent) {
        this.onMouseMoved(mouseEvent);
    }

    private final void dragGestureRecognizedEvent(DragGestureEvent dragGestureEvent) {
        if ((dragGestureEvent.getDragAction() & this.getGraphWindow().getAcceptableDragActions()) != 0) {
            this.setDragInProgress(true);
            this.onDragGestureRecognized(dragGestureEvent);
        }
    }

    private final void dragDropEndEvent(DragSourceDropEvent dragSourceDropEvent) {
        this.setDragInProgress(false);
        this.onDragDropEnd(dragSourceDropEvent);
    }

    private final void dragEnterEvent(DragSourceDragEvent dragSourceDragEvent) {
        this.onDragEnter(dragSourceDragEvent);
    }

    private final void dragOverEvent(DragSourceDragEvent dragSourceDragEvent) {
        this.onDragOver(dragSourceDragEvent);
    }

    private final void dragExitEvent(DragSourceEvent dragSourceEvent) {
        this.onDragExit(dragSourceEvent);
    }

    private final void dropActionChangedEvent(DragSourceDragEvent dragSourceDragEvent) {
        this.onDropActionChanged(dragSourceDragEvent);
    }

    private final void dragEnterEvent(DropTargetDragEvent dropTargetDragEvent) {
        this.getGraphWindow().getCurrentTool().cancelAction();
        this.onDragEnter(dropTargetDragEvent);
    }

    private final void dragOverEvent(DropTargetDragEvent dropTargetDragEvent) {
        this.onDragOver(dropTargetDragEvent);
    }

    private final void dropActionChangedEvent(DropTargetDragEvent dropTargetDragEvent) {
        this.onDropActionChanged(dropTargetDragEvent);
    }

    private final void dragExitEvent(DropTargetEvent dropTargetEvent) {
        this.onDragExit(dropTargetEvent);
    }

    private final void dropEvent(DropTargetDropEvent dropTargetDropEvent) {
        this.onDrop(dropTargetDropEvent);
    }

    public void onMouseClicked(MouseEvent mouseEvent) {
        TSEWindowTool tSEWindowTool = this.getGraphWindow().getDefaultTool();
        if (tSEWindowTool != this && tSEWindowTool instanceof TSEWindowInputTool) {
            ((TSEWindowInputTool)tSEWindowTool).onMouseClicked(mouseEvent);
        }
    }

    public void onMousePressed(MouseEvent mouseEvent) {
        TSEWindowTool tSEWindowTool = this.getGraphWindow().getDefaultTool();
        if (tSEWindowTool != this && tSEWindowTool instanceof TSEWindowInputTool) {
            ((TSEWindowInputTool)tSEWindowTool).onMousePressed(mouseEvent);
        }
    }

    public void onMouseReleased(MouseEvent mouseEvent) {
        TSEWindowTool tSEWindowTool = this.getGraphWindow().getDefaultTool();
        if (tSEWindowTool != this && tSEWindowTool instanceof TSEWindowInputTool) {
            ((TSEWindowInputTool)tSEWindowTool).onMouseReleased(mouseEvent);
        }
    }

    public void onMouseDragged(MouseEvent mouseEvent) {
        TSEWindowTool tSEWindowTool = this.getGraphWindow().getDefaultTool();
        if (tSEWindowTool != this && tSEWindowTool instanceof TSEWindowInputTool) {
            ((TSEWindowInputTool)tSEWindowTool).onMouseDragged(mouseEvent);
        }
    }

    public void onMouseMoved(MouseEvent mouseEvent) {
        TSEWindowTool tSEWindowTool = this.getGraphWindow().getDefaultTool();
        if (tSEWindowTool != this && tSEWindowTool instanceof TSEWindowInputTool) {
            ((TSEWindowInputTool)tSEWindowTool).onMouseMoved(mouseEvent);
        }
    }

    public void onMouseEntered(MouseEvent mouseEvent) {
        TSEWindowTool tSEWindowTool = this.getGraphWindow().getDefaultTool();
        if (tSEWindowTool != this && tSEWindowTool instanceof TSEWindowInputTool) {
            ((TSEWindowInputTool)tSEWindowTool).onMouseEntered(mouseEvent);
        }
    }

    public void onMouseExited(MouseEvent mouseEvent) {
        TSEWindowTool tSEWindowTool = this.getGraphWindow().getDefaultTool();
        if (tSEWindowTool != this && tSEWindowTool instanceof TSEWindowInputTool) {
            ((TSEWindowInputTool)tSEWindowTool).onMouseExited(mouseEvent);
        }
    }

    public void onDragGestureRecognized(DragGestureEvent dragGestureEvent) {
        TSEWindowTool tSEWindowTool = this.getGraphWindow().getDefaultTool();
        if (tSEWindowTool != this && tSEWindowTool instanceof TSEWindowInputTool) {
            ((TSEWindowInputTool)tSEWindowTool).onDragGestureRecognized(dragGestureEvent);
        }
    }

    public void onDragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
        TSEWindowTool tSEWindowTool = this.getGraphWindow().getDefaultTool();
        if (tSEWindowTool != this && tSEWindowTool instanceof TSEWindowInputTool) {
            ((TSEWindowInputTool)tSEWindowTool).onDragDropEnd(dragSourceDropEvent);
        }
    }

    public void onDragEnter(DragSourceDragEvent dragSourceDragEvent) {
        TSEWindowTool tSEWindowTool = this.getGraphWindow().getDefaultTool();
        if (tSEWindowTool != this && tSEWindowTool instanceof TSEWindowInputTool) {
            ((TSEWindowInputTool)tSEWindowTool).onDragEnter(dragSourceDragEvent);
        }
    }

    public void onDragOver(DragSourceDragEvent dragSourceDragEvent) {
        TSEWindowTool tSEWindowTool = this.getGraphWindow().getDefaultTool();
        if (tSEWindowTool != this && tSEWindowTool instanceof TSEWindowInputTool) {
            ((TSEWindowInputTool)tSEWindowTool).onDragOver(dragSourceDragEvent);
        }
    }

    public void onDragExit(DragSourceEvent dragSourceEvent) {
        TSEWindowTool tSEWindowTool = this.getGraphWindow().getDefaultTool();
        if (tSEWindowTool != this && tSEWindowTool instanceof TSEWindowInputTool) {
            ((TSEWindowInputTool)tSEWindowTool).onDragExit(dragSourceEvent);
        }
    }

    public void onDropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
        TSEWindowTool tSEWindowTool = this.getGraphWindow().getDefaultTool();
        if (tSEWindowTool != this && tSEWindowTool instanceof TSEWindowInputTool) {
            ((TSEWindowInputTool)tSEWindowTool).onDropActionChanged(dragSourceDragEvent);
        }
    }

    public void onDragEnter(DropTargetDragEvent dropTargetDragEvent) {
        TSEWindowTool tSEWindowTool = this.getGraphWindow().getDefaultTool();
        if (tSEWindowTool != this && tSEWindowTool instanceof TSEWindowInputTool) {
            ((TSEWindowInputTool)tSEWindowTool).onDragEnter(dropTargetDragEvent);
        }
    }

    public void onDragOver(DropTargetDragEvent dropTargetDragEvent) {
        TSEWindowTool tSEWindowTool = this.getGraphWindow().getDefaultTool();
        if (tSEWindowTool != this && tSEWindowTool instanceof TSEWindowInputTool) {
            ((TSEWindowInputTool)tSEWindowTool).onDragOver(dropTargetDragEvent);
        }
    }

    public void onDropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        TSEWindowTool tSEWindowTool = this.getGraphWindow().getDefaultTool();
        if (tSEWindowTool != this && tSEWindowTool instanceof TSEWindowInputTool) {
            ((TSEWindowInputTool)tSEWindowTool).onDropActionChanged(dropTargetDragEvent);
        }
    }

    public void onDragExit(DropTargetEvent dropTargetEvent) {
        TSEWindowTool tSEWindowTool = this.getGraphWindow().getDefaultTool();
        if (tSEWindowTool != this && tSEWindowTool instanceof TSEWindowInputTool) {
            ((TSEWindowInputTool)tSEWindowTool).onDragExit(dropTargetEvent);
        }
    }

    public void onDrop(DropTargetDropEvent dropTargetDropEvent) {
        TSEWindowTool tSEWindowTool = this.getGraphWindow().getDefaultTool();
        if (tSEWindowTool != this && tSEWindowTool instanceof TSEWindowInputTool) {
            ((TSEWindowInputTool)tSEWindowTool).onDrop(dropTargetDropEvent);
        }
    }

    public boolean isAlignmentEnabled(InputEvent inputEvent) {
        return !inputEvent.isAltDown();
    }

    DragGestureListener getInternalDragGestureListener() {
        return this.mouseInputHandler;
    }

    protected DragSourceListener getInternalDragSourceListener() {
        return this.mouseInputHandler;
    }

    DropTargetListener getInternalDropTargetListener() {
        return this.mouseInputHandler;
    }

    public TSConstPoint getWorldPoint(MouseEvent mouseEvent) {
        return new TSConstPoint(this.getWorldX(mouseEvent), this.getWorldY(mouseEvent));
    }

    public TSConstPoint getNonalignedWorldPoint(MouseEvent mouseEvent) {
        return new TSConstPoint(this.getNonalignedWorldX(mouseEvent), this.getNonalignedWorldY(mouseEvent));
    }

    public double getWorldX(MouseEvent mouseEvent) {
        if (this.isAlignmentEnabled(mouseEvent)) {
            return this.getAlignedWorldX(mouseEvent);
        }
        return this.getNonalignedWorldX(mouseEvent);
    }

    public double getNonalignedWorldX(MouseEvent mouseEvent) {
        return this.getGraphWindow().getTransform().xToWorld(mouseEvent.getX());
    }

    public double getWorldY(MouseEvent mouseEvent) {
        if (this.isAlignmentEnabled(mouseEvent)) {
            return this.getAlignedWorldY(mouseEvent);
        }
        return this.getNonalignedWorldY(mouseEvent);
    }

    public double getNonalignedWorldY(MouseEvent mouseEvent) {
        return this.getGraphWindow().getTransform().yToWorld(mouseEvent.getY());
    }

    public TSConstPoint getAlignedWorldPoint(MouseEvent mouseEvent) {
        return new TSPoint(this.getAlignedWorldX(mouseEvent), this.getAlignedWorldY(mouseEvent));
    }

    public double getAlignedWorldX(MouseEvent mouseEvent) {
        double d = this.getNonalignedWorldX(mouseEvent);
        if (this.getGraphWindow().hasGrid()) {
            d = this.getGridOffsetX() + this.getGraphWindow().getGrid().getNearestGridX(d);
        }
        return d;
    }

    public double getAlignedWorldY(MouseEvent mouseEvent) {
        double d = this.getNonalignedWorldY(mouseEvent);
        if (this.getGraphWindow().hasGrid()) {
            d = this.getGridOffsetY() + this.getGraphWindow().getGrid().getNearestGridY(d);
        }
        return d;
    }

    public void setGridOffset(double d, double d2) {
        this.gridOffsetX = d;
        this.gridOffsetY = d2;
    }

    public void setGridOffset(TSConstPoint tSConstPoint) {
        this.gridOffsetX = 0.0;
        this.gridOffsetY = 0.0;
        if (this.getGraphWindow().hasGrid()) {
            TSEGrid tSEGrid = this.getGraphWindow().getGrid();
            this.gridOffsetX = tSConstPoint.getX() - tSEGrid.getNearestGridX(tSConstPoint.getX());
            this.gridOffsetY = tSConstPoint.getY() - tSEGrid.getNearestGridY(tSConstPoint.getY());
        }
    }

    public double getGridOffsetX() {
        return this.gridOffsetX;
    }

    public double getGridOffsetY() {
        return this.gridOffsetY;
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        String string = null;
        String string2 = null;
        TSConstPoint tSConstPoint = this.getNonalignedWorldPoint(mouseEvent);
        TSEHitTesting tSEHitTesting = this.getHitTesting();
        TSEObject tSEObject = tSEHitTesting.getGraphObjectAt(tSConstPoint, this.getGraph(), this.getGraphWindow().isNestedGraphEditingEnabled());
        string2 = tSEObject != null ? tSEObject.getToolTipText() : null;
        if (string2 != null && string2.length() > 0) {
            int n;
            boolean bl = true;
            for (n = 0; n < string2.length(); ++n) {
                if (string2.charAt(n) == ' ' || string2.charAt(n) == '\n') continue;
                bl = false;
                break;
            }
            if (!bl) {
                n = -1;
                while ((n = string2.indexOf("\n", n)) != -1) {
                    string2 = string2.substring(0, n) + "<br>" + string2.substring(n + 1);
                }
                string = TSSystem.replace(TSEGraphWindow.getToolTipFormat(), TSEGraphWindow.TOOLTIP_PLACEHOLDER, string2);
            }
        }
        return string;
    }

    public Point getToolTipLocation(MouseEvent mouseEvent) {
        return this.getGraphWindow().getDefaultToolTipLocation(mouseEvent);
    }

    public MouseEvent getMouseEvent() {
        return null;
    }

    protected boolean isDragInProgress() {
        return this.dragging;
    }

    protected void setDragInProgress(boolean bl) {
        this.dragging = bl;
    }

    static /* synthetic */ void access$000(TSEWindowInputTool tSEWindowInputTool, MouseEvent mouseEvent) {
        tSEWindowInputTool.mouseClickedEvent(mouseEvent);
    }

    static /* synthetic */ void access$100(TSEWindowInputTool tSEWindowInputTool, MouseEvent mouseEvent) {
        tSEWindowInputTool.mouseEnteredEvent(mouseEvent);
    }

    static /* synthetic */ void access$200(TSEWindowInputTool tSEWindowInputTool, MouseEvent mouseEvent) {
        tSEWindowInputTool.mouseExitedEvent(mouseEvent);
    }

    static /* synthetic */ void access$300(TSEWindowInputTool tSEWindowInputTool, MouseEvent mouseEvent) {
        tSEWindowInputTool.mousePressedEvent(mouseEvent);
    }

    static /* synthetic */ void access$400(TSEWindowInputTool tSEWindowInputTool, MouseEvent mouseEvent) {
        tSEWindowInputTool.mouseReleasedEvent(mouseEvent);
    }

    static /* synthetic */ void access$500(TSEWindowInputTool tSEWindowInputTool, MouseEvent mouseEvent) {
        tSEWindowInputTool.mouseDraggedEvent(mouseEvent);
    }

    static /* synthetic */ void access$600(TSEWindowInputTool tSEWindowInputTool, MouseEvent mouseEvent) {
        tSEWindowInputTool.mouseMovedEvent(mouseEvent);
    }

    static /* synthetic */ void access$700(TSEWindowInputTool tSEWindowInputTool, DragGestureEvent dragGestureEvent) {
        tSEWindowInputTool.dragGestureRecognizedEvent(dragGestureEvent);
    }

    static /* synthetic */ void access$800(TSEWindowInputTool tSEWindowInputTool, DragSourceDropEvent dragSourceDropEvent) {
        tSEWindowInputTool.dragDropEndEvent(dragSourceDropEvent);
    }

    static /* synthetic */ void access$900(TSEWindowInputTool tSEWindowInputTool, DragSourceDragEvent dragSourceDragEvent) {
        tSEWindowInputTool.dragEnterEvent(dragSourceDragEvent);
    }

    static /* synthetic */ void access$1000(TSEWindowInputTool tSEWindowInputTool, DragSourceEvent dragSourceEvent) {
        tSEWindowInputTool.dragExitEvent(dragSourceEvent);
    }

    static /* synthetic */ void access$1100(TSEWindowInputTool tSEWindowInputTool, DragSourceDragEvent dragSourceDragEvent) {
        tSEWindowInputTool.dragOverEvent(dragSourceDragEvent);
    }

    static /* synthetic */ void access$1200(TSEWindowInputTool tSEWindowInputTool, DragSourceDragEvent dragSourceDragEvent) {
        tSEWindowInputTool.dropActionChangedEvent(dragSourceDragEvent);
    }

    static /* synthetic */ void access$1300(TSEWindowInputTool tSEWindowInputTool, DropTargetDragEvent dropTargetDragEvent) {
        tSEWindowInputTool.dragEnterEvent(dropTargetDragEvent);
    }

    static /* synthetic */ void access$1400(TSEWindowInputTool tSEWindowInputTool, DropTargetDragEvent dropTargetDragEvent) {
        tSEWindowInputTool.dragOverEvent(dropTargetDragEvent);
    }

    static /* synthetic */ void access$1500(TSEWindowInputTool tSEWindowInputTool, DropTargetDragEvent dropTargetDragEvent) {
        tSEWindowInputTool.dropActionChangedEvent(dropTargetDragEvent);
    }

    static /* synthetic */ void access$1600(TSEWindowInputTool tSEWindowInputTool, DropTargetEvent dropTargetEvent) {
        tSEWindowInputTool.dragExitEvent(dropTargetEvent);
    }

    static /* synthetic */ void access$1700(TSEWindowInputTool tSEWindowInputTool, DropTargetDropEvent dropTargetDropEvent) {
        tSEWindowInputTool.dropEvent(dropTargetDropEvent);
    }
}

