/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editor;

import com.tomsawyer.editor.TSELocalization;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;

public class TSEResourceBundleWrapper {
    ResourceBundle resourceBundle = null;
    String name;
    static TSEResourceBundleWrapper systemLabelBundle = null;

    private TSEResourceBundleWrapper(ResourceBundle resourceBundle, String string) {
        this.resourceBundle = resourceBundle;
        this.name = string;
    }

    public static TSEResourceBundleWrapper getSystemLabelBundle() {
        if (systemLabelBundle == null) {
            systemLabelBundle = TSEResourceBundleWrapper.getBundle(TSELocalization.getBundlePath() + "LabelBundle", TSELocalization.getLocale());
        }
        return systemLabelBundle;
    }

    public static TSEResourceBundleWrapper getBundle(String string) {
        ResourceBundle resourceBundle = null;
        try {
            resourceBundle = ResourceBundle.getBundle(string);
        }
        catch (Exception exception) {
            System.err.println("ResourceBundle.getBundle() failed:");
            System.err.println("\texception = '" + exception.getClass().getName() + "',");
            System.err.println("\tbaseName = '" + string + "'.");
        }
        return new TSEResourceBundleWrapper(resourceBundle, string);
    }

    public static TSEResourceBundleWrapper getBundle(String string, Locale locale) {
        ResourceBundle resourceBundle = null;
        try {
            resourceBundle = ResourceBundle.getBundle(string, locale);
        }
        catch (Throwable throwable) {
            System.err.println("ResourceBundle.getBundle() failed:");
            System.err.println("\texception = '" + throwable.getClass().getName() + "',");
            System.err.println("\tbaseName = '" + string + "',");
            System.err.println("\tlocale = '" + locale + "'.");
        }
        return new TSEResourceBundleWrapper(resourceBundle, string);
    }

    public Enumeration getKeys() {
        Enumeration<String> enumeration = null;
        try {
            enumeration = this.resourceBundle.getKeys();
        }
        catch (Exception exception) {
            System.err.println("ResourceBundle.getKeys() failed:");
            System.err.println("\texception = '" + exception.getClass().getName() + "',");
            System.err.println("\tbundle name = '" + this.name + "'.");
        }
        return enumeration;
    }

    public Object getObject(String string) {
        Object object = null;
        try {
            object = this.resourceBundle.getObject(string);
        }
        catch (Exception exception) {
            System.err.println("ResourceBundle.getObject() failed:");
            System.err.println("\texception = '" + exception.getClass().getName() + "',");
            System.err.println("\tbundle name = '" + this.name + "',");
            System.err.println("\tkey = '" + string + "'.");
        }
        return object;
    }

    public String getStringSafely(String string) {
        String string2 = this.getString(string);
        if (string2 == null && string != null) {
            string2 = string.replace('_', ' ');
        }
        return string2;
    }

    public String getString(String string) {
        String string2 = null;
        boolean bl = false;
        if (string.endsWith(":")) {
            string = string.substring(0, string.length() - 1);
            bl = true;
        }
        try {
            string2 = this.resourceBundle.getString(string);
            if (bl) {
                string2 = string2 + ":";
            }
        }
        catch (Exception exception) {
            System.err.println("ResourceBundle.getString() failed:");
            System.err.println("\texception = '" + exception.getClass().getName() + "',");
            System.err.println("\tbundle name = '" + this.name + "',");
            System.err.println("\tkey = '" + string + "'.");
        }
        return string2;
    }

    public String[] getStringArray(String string) {
        String[] stringArray = null;
        try {
            stringArray = this.resourceBundle.getStringArray(string);
        }
        catch (Exception exception) {
            System.err.println("ResourceBundle.getStringArray()failed:");
            System.err.println("\texception = '" + exception.getClass().getName() + "',");
            System.err.println("\tbundle name = '" + this.name + "',");
            System.err.println("\tkey = '" + string + "'.");
        }
        return stringArray;
    }
}

