/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editor;

import com.tomsawyer.drawing.geometry.TSConstRect;
import com.tomsawyer.editor.TSEColor;
import com.tomsawyer.editor.TSEGrid;
import com.tomsawyer.editor.TSTransform;
import com.tomsawyer.editor.graphics.TSEGraphics;
import java.awt.Shape;

public class TSEPointGrid
extends TSEGrid {
    static final TSEColor[] COLORS = new TSEColor[]{new TSEColor(153, 153, 153), new TSEColor(102, 204, 204), new TSEColor(0, 153, 153)};
    private int cellsPerSubgrid;
    private int dropoutThreshold;
    private int subgridCount;
    private TSEColor[] colors;

    public TSEPointGrid() {
        this.setCellsPerSubgrid(this.getDefaultCellsPerSubgrid());
        this.setDropoutThreshold(this.getDefaultDropoutThreshold());
        this.setSubgridCount(this.getDefaultSubgridCount());
        this.setColors(this.getDefaultColors());
    }

    public int getCellsPerSubgrid() {
        return this.cellsPerSubgrid;
    }

    public void setCellsPerSubgrid(int n) {
        if (n > 1) {
            this.cellsPerSubgrid = n;
        }
    }

    public int getDefaultCellsPerSubgrid() {
        return 5;
    }

    public int getDropoutThreshold() {
        return this.dropoutThreshold;
    }

    public void setDropoutThreshold(int n) {
        if (n > 0) {
            this.dropoutThreshold = n;
        }
    }

    public int getDefaultDropoutThreshold() {
        return 8;
    }

    public int getSubgridCount() {
        return this.subgridCount;
    }

    public void setSubgridCount(int n) {
        if (n > 0) {
            this.subgridCount = n;
        }
    }

    public int getDefaultSubgridCount() {
        return 3;
    }

    public void setColors(TSEColor[] tSEColorArray) {
        this.colors = tSEColorArray;
    }

    public TSEColor[] getColors() {
        return this.colors;
    }

    public TSEColor[] getDefaultColors() {
        return COLORS;
    }

    protected void drawTile(TSEGraphics tSEGraphics, int n, int n2, int n3, int n4, int n5, int n6) {
        if (n6 == 0) {
            int n7 = this.getDropoutThreshold();
            for (int i = 0; i < n5 + 1; ++i) {
                n7 *= this.getCellsPerSubgrid();
            }
            if (n3 > n7 && n4 > n7) {
                this.selectColor(tSEGraphics, n5 + 1);
                ++n5;
            }
        }
        if (n5 == 0) {
            tSEGraphics.drawLine(n, n2, n, n2);
        } else if (n5 == 1) {
            tSEGraphics.drawLine(n - 2, n2, n + 2, n2);
            tSEGraphics.drawLine(n, n2 - 2, n, n2 + 2);
        } else {
            tSEGraphics.drawLine(n - 4, n2, n + 4, n2);
            tSEGraphics.drawLine(n, n2 - 4, n, n2 + 4);
        }
    }

    protected void selectColor(TSEGraphics tSEGraphics, int n) {
        if (this.colors != null && n < this.colors.length) {
            tSEGraphics.setColor(this.colors[n]);
        }
    }

    protected void drawSubgrid(TSEGraphics tSEGraphics, TSConstRect tSConstRect, double d, double d2, int n, int n2) {
        block6: {
            this.selectColor(tSEGraphics, n);
            TSTransform tSTransform = tSEGraphics.getTSTransform();
            int n3 = this.getDropoutThreshold();
            if (tSTransform.widthToDevice(d) < n3 || tSTransform.heightToDevice(d2) < n3) break block6;
            int n4 = (int)(tSConstRect.getLeft() / d) - 1;
            int n5 = (int)(tSConstRect.getBottom() / d2) - 1;
            int n6 = (int)(tSConstRect.getRight() / d) + 1;
            int n7 = (int)(tSConstRect.getTop() / d2) + 1;
            int n8 = tSTransform.widthToDevice(d);
            int n9 = tSTransform.heightToDevice(d2);
            if (n < this.getSubgridCount() - 1) {
                for (int i = n4; i < n6; ++i) {
                    int n10 = tSTransform.xToDevice((double)i * d);
                    for (int j = n5; j < n7; ++j) {
                        if (j % this.getCellsPerSubgrid() == 0 && i % this.getCellsPerSubgrid() == 0) continue;
                        this.drawTile(tSEGraphics, n10, tSTransform.yToDevice((double)j * d2), n8, n9, n, n2);
                    }
                }
            } else {
                for (int i = n4; i < n6; ++i) {
                    int n11 = tSTransform.xToDevice((double)i * d);
                    for (int j = n5; j < n7; ++j) {
                        this.drawTile(tSEGraphics, n11, tSTransform.yToDevice((double)j * d2), n8, n9, n, n2);
                    }
                }
            }
        }
    }

    public void draw(TSEGraphics tSEGraphics, TSConstRect tSConstRect) {
        int n;
        Shape shape = tSEGraphics.getClip();
        tSEGraphics.clipRect(tSConstRect);
        double d = this.getXSpacing();
        double d2 = this.getYSpacing();
        int n2 = 0;
        if (this.getCellsPerSubgrid() > 1) {
            n = this.getDropoutThreshold();
            TSTransform tSTransform = tSEGraphics.getTSTransform();
            while (tSTransform.widthToDevice(d) < n || tSTransform.heightToDevice(d2) < n) {
                d *= (double)this.getCellsPerSubgrid();
                d2 *= (double)this.getCellsPerSubgrid();
                ++n2;
            }
        }
        for (n = 0; n < this.getSubgridCount(); ++n) {
            this.drawSubgrid(tSEGraphics, tSConstRect, d, d2, n, n2);
            d *= (double)this.getCellsPerSubgrid();
            d2 *= (double)this.getCellsPerSubgrid();
        }
        tSEGraphics.setClip(shape);
    }
}

